/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IMethodCollection;
import com.vladium.jcd.cls.Method_info;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.IntVector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class MethodCollection
implements IMethodCollection {
    private List m_methods;

    public Method_info get(int n) {
        return (Method_info)this.m_methods.get(n);
    }

    public int[] get(ClassDef classDef, String string) {
        if (classDef == null) {
            throw new IllegalArgumentException("null input: cls");
        }
        int n = this.m_methods.size();
        IntVector intVector = new IntVector(n);
        for (int i = 0; i < n; ++i) {
            Method_info method_info = (Method_info)this.m_methods.get(i);
            if (!method_info.getName(classDef).equals(string)) continue;
            intVector.add(i);
        }
        return intVector.values();
    }

    public int size() {
        return this.m_methods.size();
    }

    public Object clone() {
        try {
            MethodCollection methodCollection = (MethodCollection)super.clone();
            int n = this.m_methods.size();
            methodCollection.m_methods = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                methodCollection.m_methods.add(((Method_info)this.m_methods.get(i)).clone());
            }
            return methodCollection;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        int n = this.m_methods.size();
        uDataOutputStream.writeU2(n);
        for (int i = 0; i < n; ++i) {
            this.get(i).writeInClassFormat(uDataOutputStream);
        }
    }

    public void accept(IClassDefVisitor iClassDefVisitor, Object object) {
        iClassDefVisitor.visit(this, object);
    }

    public int add(Method_info method_info) {
        int n = this.m_methods.size();
        this.m_methods.add(method_info);
        return n;
    }

    public Method_info set(int n, Method_info method_info) {
        return this.m_methods.set(n, method_info);
    }

    public Method_info remove(int n) {
        return (Method_info)this.m_methods.remove(n);
    }

    MethodCollection(int n) {
        this.m_methods = n < 0 ? new ArrayList() : new ArrayList(n);
    }
}

