/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.ElementFactory;
import com.vladium.jcd.cls.IAccessFlags;
import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.constant.CONSTANT_Utf8_info;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;

public final class Field_info
implements Cloneable,
IAccessFlags {
    public int m_name_index;
    public int m_descriptor_index;
    private int m_access_flags;
    private IAttributeCollection m_attributes;
    private static final boolean DEBUG = false;

    public Field_info(int n, int n2, int n3, IAttributeCollection iAttributeCollection) {
        this.m_access_flags = n;
        this.m_name_index = n2;
        this.m_descriptor_index = n3;
        this.m_attributes = iAttributeCollection;
    }

    public Field_info(IConstantCollection iConstantCollection, UDataInputStream uDataInputStream) throws IOException {
        this.m_access_flags = uDataInputStream.readU2();
        this.m_name_index = uDataInputStream.readU2();
        this.m_descriptor_index = uDataInputStream.readU2();
        int n = uDataInputStream.readU2();
        this.m_attributes = ElementFactory.newAttributeCollection(n);
        for (int i = 0; i < n; ++i) {
            Attribute_info attribute_info = Attribute_info.new_Attribute_info(iConstantCollection, uDataInputStream);
            this.m_attributes.add(attribute_info);
        }
    }

    public String getName(ClassDef classDef) {
        return ((CONSTANT_Utf8_info)classDef.getConstants().get((int)this.m_name_index)).m_value;
    }

    public String getDescriptor(ClassDef classDef) {
        return ((CONSTANT_Utf8_info)classDef.getConstants().get((int)this.m_descriptor_index)).m_value;
    }

    public boolean isSynthetic() {
        return this.m_attributes.hasSynthetic();
    }

    public final void setAccessFlags(int n) {
        this.m_access_flags = n;
    }

    public final int getAccessFlags() {
        return this.m_access_flags;
    }

    public IAttributeCollection getAttributes() {
        return this.m_attributes;
    }

    public String toString() {
        return "field_info: [modifiers: 0x" + Integer.toHexString(this.m_access_flags) + ", name_index = " + this.m_name_index + ", descriptor_index = " + this.m_descriptor_index + ']';
    }

    public Object clone() {
        try {
            Field_info field_info = (Field_info)super.clone();
            field_info.m_attributes = (IAttributeCollection)this.m_attributes.clone();
            return field_info;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        uDataOutputStream.writeU2(this.m_access_flags);
        uDataOutputStream.writeU2(this.m_name_index);
        uDataOutputStream.writeU2(this.m_descriptor_index);
        this.m_attributes.writeInClassFormat(uDataOutputStream);
    }
}

