/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.MethodDescriptor;
import com.vladium.emma.report.AllItem;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IReportDataModel;
import com.vladium.emma.report.IReportDataView;
import com.vladium.emma.report.Item;
import com.vladium.emma.report.MethodItem;
import com.vladium.emma.report.PackageItem;
import com.vladium.emma.report.SrcFileItem;
import com.vladium.util.Descriptors;
import java.util.HashMap;
import java.util.Iterator;

final class ReportDataModel
implements IReportDataModel {
    private final IMetaData m_mdata;
    private final ICoverageData m_cdata;
    private final IReportDataView[] m_views;

    public synchronized IReportDataView getView(int n) {
        boolean bl;
        if (n >= this.m_views.length) {
            throw new IllegalArgumentException("invalid viewType: " + n);
        }
        IReportDataView iReportDataView = this.m_views[n];
        if (iReportDataView != null) {
            return iReportDataView;
        }
        boolean bl2 = bl = n == 1;
        if (bl && !this.m_mdata.hasSrcFileData()) {
            throw new IllegalStateException("source file data view requested for metadata with incomplete SourceFile debug info");
        }
        AllItem allItem = new AllItem();
        HashMap<String, PackageItem> hashMap = new HashMap<String, PackageItem>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        Iterator iterator = this.m_mdata.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            ClassDescriptor classDescriptor = (ClassDescriptor)iterator.next();
            String string = classDescriptor.getPackageVMName();
            PackageItem packageItem = (PackageItem)hashMap.get(string);
            if (packageItem == null) {
                object3 = string.length() == 0 ? "default package" : Descriptors.vmNameToJavaName(string);
                packageItem = new PackageItem(allItem, (String)object3, string);
                hashMap.put(string, packageItem);
                allItem.addChild(packageItem);
            }
            object3 = null;
            if (bl && (object3 = (SrcFileItem)hashMap2.get(object2 = Descriptors.combineVMName(string, (String)(object = classDescriptor.getSrcFileName())))) == null) {
                object3 = new SrcFileItem(packageItem, (String)object, (String)object2);
                hashMap2.put(object2, object3);
                packageItem.addChild((IItem)object3);
            }
            if ((object = this.m_cdata.getCoverage(classDescriptor)) != null && ((ICoverageData.DataHolder)object).m_stamp != classDescriptor.getStamp()) {
                throw new EMMARuntimeException("CLASS_STAMP_MISMATCH", new Object[]{Descriptors.vmNameToJavaName(classDescriptor.getClassVMName())});
            }
            object2 = object != null ? ((ICoverageData.DataHolder)object).m_coverage : (boolean[][])null;
            ClassItem classItem = bl ? new ClassItem((IItem)object3, classDescriptor, (boolean[][])object2) : new ClassItem(packageItem, classDescriptor, (boolean[][])object2);
            MethodDescriptor[] methodDescriptorArray = classDescriptor.getMethods();
            for (int i = 0; i < methodDescriptorArray.length; ++i) {
                MethodDescriptor methodDescriptor = methodDescriptorArray[i];
                if ((methodDescriptor.getStatus() & 0xE) != 0) continue;
                MethodItem methodItem = new MethodItem(classItem, i, methodDescriptor.getName(), methodDescriptor.getDescriptor(), methodDescriptor.getFirstLine());
                classItem.addChild(methodItem);
            }
            if (bl) {
                ((Item)object3).addChild(classItem);
                continue;
            }
            packageItem.addChild(classItem);
        }
        this.m_views[n] = iReportDataView = new ReportDataView(allItem);
        return iReportDataView;
    }

    ReportDataModel(IMetaData iMetaData, ICoverageData iCoverageData) {
        if (iMetaData == null) {
            throw new IllegalArgumentException("null input: mdata");
        }
        if (iCoverageData == null) {
            throw new IllegalArgumentException("null input: cdata");
        }
        this.m_views = new IReportDataView[2];
        this.m_mdata = iMetaData;
        this.m_cdata = iCoverageData;
    }

    private static final class ReportDataView
    implements IReportDataView {
        private final IItem m_root;

        public IItem getRoot() {
            return this.m_root;
        }

        ReportDataView(IItem iItem) {
            this.m_root = iItem;
        }
    }
}

