/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Main;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

@Beta
public class TextReporter
extends Reporter {
    private final Writer mWriter;
    private final boolean mClose;
    private final LintCliFlags mFlags;

    public TextReporter(LintCliClient client, LintCliFlags flags, Writer writer, boolean close) {
        this(client, flags, null, writer, close);
    }

    public TextReporter(LintCliClient client, LintCliFlags flags, File file, Writer writer, boolean close) {
        super(client, file);
        this.mFlags = flags;
        this.mWriter = writer;
        this.mClose = close;
    }

    @Override
    public void write(int errorCount, int warningCount, List<Warning> issues) throws IOException {
        boolean abbreviate = !this.mFlags.isShowEverything();
        StringBuilder output = new StringBuilder(issues.size() * 200);
        if (issues.isEmpty()) {
            this.mWriter.write("No issues found.");
            this.mWriter.write(10);
            this.mWriter.flush();
        } else {
            for (Warning warning : issues) {
                List<String> names;
                Severity severity;
                int startLength = output.length();
                if (warning.path != null) {
                    output.append(warning.path);
                    output.append(':');
                    if (warning.line >= 0) {
                        output.append(Integer.toString(warning.line + 1));
                        output.append(':');
                    }
                    if (startLength < output.length()) {
                        output.append(' ');
                    }
                }
                if ((severity = warning.severity) == Severity.FATAL) {
                    severity = Severity.ERROR;
                }
                output.append(severity.getDescription());
                output.append(':');
                output.append(' ');
                output.append(warning.message);
                if (warning.issue != null) {
                    output.append(' ').append('[');
                    output.append(warning.issue.getId());
                    output.append(']');
                }
                output.append('\n');
                if (warning.errorLine != null && !warning.errorLine.isEmpty()) {
                    output.append(warning.errorLine);
                }
                if (warning.location != null && warning.location.getSecondary() != null) {
                    Location location;
                    for (location = warning.location.getSecondary(); location != null; location = location.getSecondary()) {
                        int line;
                        if (location.getMessage() == null || location.getMessage().isEmpty()) continue;
                        output.append("    ");
                        String path = this.mClient.getDisplayPath(warning.project, location.getFile());
                        output.append(path);
                        Position start = location.getStart();
                        if (start != null && (line = start.getLine()) >= 0) {
                            output.append(':');
                            output.append(Integer.toString(line + 1));
                        }
                        if (location.getMessage() != null && !location.getMessage().isEmpty()) {
                            output.append(':');
                            output.append(' ');
                            output.append(location.getMessage());
                        }
                        output.append('\n');
                    }
                    if (!abbreviate) {
                        StringBuilder sb = new StringBuilder(100);
                        sb.append("Also affects: ");
                        int begin = sb.length();
                        for (location = warning.location.getSecondary(); location != null; location = location.getSecondary()) {
                            int line;
                            if (location.getMessage() != null && location.getMessage().isEmpty()) continue;
                            if (sb.length() > begin) {
                                sb.append(", ");
                            }
                            String path = this.mClient.getDisplayPath(warning.project, location.getFile());
                            sb.append(path);
                            Position start = location.getStart();
                            if (start == null || (line = start.getLine()) < 0) continue;
                            sb.append(':');
                            sb.append(Integer.toString(line + 1));
                        }
                        String wrapped = Main.wrap(sb.toString(), 78, "     ");
                        output.append(wrapped);
                    }
                }
                if (!warning.isVariantSpecific()) continue;
                if (warning.includesMoreThanExcludes()) {
                    output.append("Applies to variants: ");
                    names = warning.getIncludedVariantNames();
                } else {
                    output.append("Does not apply to variants: ");
                    names = warning.getExcludedVariantNames();
                }
                output.append(Joiner.on((String)", ").join(names));
                output.append('\n');
            }
            this.mWriter.write(output.toString());
            this.mWriter.write(String.format("%1$d errors, %2$d warnings", errorCount, warningCount));
            this.mWriter.write(10);
            this.mWriter.flush();
            if (this.mClose) {
                this.mWriter.close();
                if (this.mOutput != null) {
                    String path = this.mOutput.getAbsolutePath();
                    System.out.println(String.format("Wrote text report to %1$s", path));
                }
            }
        }
    }

    boolean isWriteToConsole() {
        return this.mOutput == null;
    }
}

