/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.IJavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import java.io.File;
import java.util.List;
import lombok.ast.Node;
import lombok.ast.Position;
import lombok.ast.TypeReference;
import lombok.ast.ecj.EcjTreeConverter;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class EcjParser
implements IJavaParser {
    private final Parser mParser;
    private final LintClient mClient;

    public EcjParser(LintClient client) {
        this.mClient = client;
        CompilerOptions options = new CompilerOptions();
        options.complianceLevel = 0x330000L;
        options.sourceLevel = 0x330000L;
        options.targetJDK = 0x330000L;
        options.parseLiteralExpressionsAsConstants = true;
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.exitOnFirstError(), options, new DefaultProblemFactory());
        this.mParser = new Parser(problemReporter, options.parseLiteralExpressionsAsConstants);
        this.mParser.javadocParser.checkDocComment = false;
    }

    @Override
    public Node parseJava(@NonNull JavaContext context) {
        CompilationUnitDeclaration unit;
        EcjTreeConverter converter = new EcjTreeConverter();
        String code = context.getContents();
        if (code == null) {
            return null;
        }
        CompilationUnit sourceUnit = new CompilationUnit(code.toCharArray(), context.file.getName(), "UTF-8");
        CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, 0);
        try {
            unit = this.mParser.parse(sourceUnit, compilationResult);
        }
        catch (AbortCompilation e) {
            return null;
        }
        if (unit == null) {
            return null;
        }
        try {
            converter.visit(code, (ASTNode)unit);
            List nodes = converter.getAll();
            for (Node node : nodes) {
                if (!(node instanceof lombok.ast.CompilationUnit)) continue;
                return node;
            }
            return null;
        }
        catch (Throwable t) {
            this.mClient.log(t, "Failed converting ECJ parse tree to Lombok for file %1$s", context.file.getPath());
            return null;
        }
    }

    @Override
    @NonNull
    public Location getLocation(@NonNull JavaContext context, @NonNull Node node) {
        Position position = node.getPosition();
        return Location.create(context.file, context.getContents(), position.getStart(), position.getEnd());
    }

    @Override
    @NonNull
    public Location.Handle createLocationHandle(@NonNull JavaContext context, @NonNull Node node) {
        return new LocationHandle(context.file, node);
    }

    @Override
    public void dispose(@NonNull JavaContext context, @NonNull Node compilationUnit) {
    }

    @Override
    @Nullable
    public Node resolve(@NonNull JavaContext context, @NonNull Node node) {
        return null;
    }

    @Override
    @Nullable
    public TypeReference getType(@NonNull JavaContext context, @NonNull Node node) {
        return null;
    }

    private static class LocationHandle
    implements Location.Handle {
        private File mFile;
        private Node mNode;
        private Object mClientData;

        public LocationHandle(File file, Node node) {
            this.mFile = file;
            this.mNode = node;
        }

        @Override
        @NonNull
        public Location resolve() {
            Position pos = this.mNode.getPosition();
            return Location.create(this.mFile, null, pos.getStart(), pos.getEnd());
        }

        @Override
        public void setClientData(@Nullable Object clientData) {
            this.mClientData = clientData;
        }

        @Override
        @Nullable
        public Object getClientData() {
            return this.mClientData;
        }
    }
}

