/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    int labelHandle;
    int imageHandle;
    int buttonHandle;
    Table parent;
    int modelIndex;
    int lastButton;
    int lastTime;
    int lastX;
    int lastWidth;
    boolean customDraw;
    boolean useFixedWidth;
    String toolTipText;

    public TableColumn(Table table, int n) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        this.createWidget(table.getColumnCount());
    }

    public TableColumn(Table table, int n, int n2) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        this.createWidget(n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TableColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int n) {
        this.parent.createItem(this, n);
        this.setOrientation();
        this.hookEvents();
        this.register();
        this.text = "";
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.buttonHandle != 0) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return OS.gtk_tree_view_column_get_reorderable(this.handle);
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return OS.gtk_tree_view_column_get_resizable(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        if (!OS.gtk_tree_view_column_get_visible(this.handle)) {
            return 0;
        }
        if (this.useFixedWidth) {
            return OS.gtk_tree_view_column_get_fixed_width(this.handle);
        }
        return OS.gtk_tree_view_column_get_width(this.handle);
    }

    int gtk_clicked(int n) {
        boolean bl = false;
        boolean bl2 = true;
        int n2 = OS.gtk_get_current_event();
        if (n2 != 0) {
            GdkEventButton gdkEventButton = new GdkEventButton();
            OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
            OS.gdk_event_free(n2);
            switch (gdkEventButton.type) {
                case 7: {
                    int n3 = this.display.getDoubleClickTime();
                    int n4 = gdkEventButton.time;
                    int n5 = gdkEventButton.button;
                    if (this.lastButton == n5 && this.lastTime != 0 && Math.abs(this.lastTime - n4) <= n3) {
                        bl = true;
                    }
                    this.lastTime = n4 == 0 ? 1 : n4;
                    this.lastButton = n5;
                    break;
                }
                case 3: {
                    if (OS.GTK_VERSION >= OS.VERSION(2, 6, 0)) break;
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            this.postEvent(bl ? 14 : 13);
        }
        return 0;
    }

    int gtk_event_after(int n, int n2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.parent.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
            }
        }
        return 0;
    }

    int gtk_mnemonic_activate(int n, int n2) {
        return this.parent.gtk_mnemonic_activate(n, n2);
    }

    int gtk_size_allocate(int n, int n2) {
        this.useFixedWidth = false;
        int n3 = OS.GTK_WIDGET_X(n);
        int n4 = OS.GTK_WIDGET_WIDTH(n);
        if (n3 != this.lastX) {
            this.lastX = n3;
            this.sendEvent(10);
        }
        if (n4 != this.lastWidth) {
            this.lastWidth = n4;
            this.sendEvent(11);
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.closures[8], false);
        if (this.buttonHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[47], 0, this.display.closures[47], false);
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[16], 0, this.display.closures[16], false);
        }
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.closures[32], false);
        }
    }

    public void pack() {
        this.checkWidget();
        int n = 0;
        if (this.buttonHandle != 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            OS.gtk_widget_size_request(this.buttonHandle, gtkRequisition);
            n = gtkRequisition.width;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            int n2 = 0;
            while (n2 < this.parent.items.length) {
                TableItem tableItem = this.parent.items[n2];
                if (tableItem != null && tableItem.cached) {
                    n = Math.max(n, this.parent.calculateWidth(this.handle, tableItem.handle));
                }
                ++n2;
            }
        } else {
            int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter_first(this.parent.modelHandle, n3)) {
                do {
                    n = Math.max(n, this.parent.calculateWidth(this.handle, n3));
                } while (OS.gtk_tree_model_iter_next(this.parent.modelHandle, n3));
            }
            OS.g_free(n3);
        }
        this.setWidth(n);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.buttonHandle != 0) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0;
        this.labelHandle = 0;
        this.buttonHandle = 0;
        this.handle = 0;
        this.modelIndex = -1;
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        this.parent.createRenderers(this.handle, this.modelIndex, n2 == 0, this.style);
    }

    void setFontDescription(int n) {
        OS.gtk_widget_modify_font(this.labelHandle, n);
        OS.gtk_widget_modify_font(this.imageHandle, n);
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int n;
            ImageList imageList = this.parent.headerImageList;
            if (imageList == null) {
                imageList = this.parent.headerImageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            }
            int n2 = imageList.getPixbuf(n);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, n2);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_column_set_resizable(this.handle, bl);
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_column_set_reorderable(this.handle, bl);
    }

    void setOrientation() {
        if ((this.parent.style & 0x4000000) != 0 && this.buttonHandle != 0) {
            OS.gtk_widget_set_direction(this.buttonHandle, 2);
            OS.gtk_container_forall(this.buttonHandle, this.display.setDirectionProc, 2);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (string.length() != 0) {
            OS.gtk_widget_show(this.labelHandle);
        } else {
            OS.gtk_widget_hide(this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        Shell shell = this.parent._getShell();
        this.setToolTipText(shell, string);
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String string) {
        shell.setToolTipText(this.buttonHandle, string);
    }

    public void setWidth(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n == this.lastWidth) {
            return;
        }
        if (n > 0) {
            this.useFixedWidth = true;
            OS.gtk_tree_view_column_set_fixed_width(this.handle, n);
        }
        if (n != 0) {
            OS.gtk_widget_realize(this.parent.handle);
        }
        OS.gtk_tree_view_column_set_visible(this.handle, n != 0);
        this.lastWidth = n;
        this.sendEvent(11);
    }
}

