/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import com.google.clearsilver.jsilver.autoescape.AutoEscapeOptions;
import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.data.DataContext;
import com.google.clearsilver.jsilver.data.DefaultDataContext;
import com.google.clearsilver.jsilver.data.TypeConverter;
import com.google.clearsilver.jsilver.exceptions.ExceptionUtil;
import com.google.clearsilver.jsilver.exceptions.JSilverInterpreterException;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.template.DefaultRenderingContext;
import com.google.clearsilver.jsilver.template.Macro;
import com.google.clearsilver.jsilver.template.RenderingContext;
import com.google.clearsilver.jsilver.template.Template;
import com.google.clearsilver.jsilver.template.TemplateLoader;
import com.google.clearsilver.jsilver.values.Value;
import java.io.IOException;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCompiledTemplate
implements Template {
    private FunctionExecutor functionExecutor;
    private String templateName;
    private TemplateLoader templateLoader;
    private EscapeMode escapeMode = EscapeMode.ESCAPE_NONE;
    private AutoEscapeOptions autoEscapeOptions;

    public void setFunctionExecutor(FunctionExecutor functionExecutor) {
        this.functionExecutor = functionExecutor;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setTemplateLoader(TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    public void setAutoEscapeOptions(AutoEscapeOptions autoEscapeOptions) {
        this.autoEscapeOptions = autoEscapeOptions;
    }

    @Override
    public void render(Data data, Appendable out, ResourceLoader resourceLoader) throws IOException {
        this.render(this.createRenderingContext(data, out, resourceLoader));
    }

    @Override
    public RenderingContext createRenderingContext(Data data, Appendable out, ResourceLoader resourceLoader) {
        DefaultDataContext dataContext = new DefaultDataContext(data);
        return new DefaultRenderingContext(dataContext, resourceLoader, out, this.functionExecutor, this.autoEscapeOptions);
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    public void setEscapeMode(EscapeMode mode) {
        this.escapeMode = mode;
    }

    @Override
    public EscapeMode getEscapeMode() {
        return this.escapeMode;
    }

    @Override
    public String getDisplayName() {
        return this.templateName;
    }

    public static boolean validateLoopArgs(int start, int end, int increment) {
        if (increment == 0) {
            return false;
        }
        if (increment > 0 && start > end) {
            return false;
        }
        return increment >= 0 || start >= end;
    }

    public static boolean exists(Data data) {
        return TypeConverter.exists(data);
    }

    public static int asInt(String value) {
        return TypeConverter.asNumber(value);
    }

    public static int asInt(int value) {
        return value;
    }

    public static int asInt(boolean value) {
        return value ? 1 : 0;
    }

    public static int asInt(Value value) {
        return value.asNumber();
    }

    public static int asInt(Data data) {
        return TypeConverter.asNumber(data);
    }

    public static String asString(String value) {
        return value;
    }

    public static String asString(int value) {
        return Integer.toString(value);
    }

    public static String asString(boolean value) {
        return value ? "1" : "0";
    }

    public static String asString(Value value) {
        return value.asString();
    }

    public static String asString(Data data) {
        return TypeConverter.asString(data);
    }

    public static Value asValue(String value) {
        return Value.literalValue(value, EscapeMode.ESCAPE_NONE, false);
    }

    public static Value asValue(int value) {
        return Value.literalValue(value, EscapeMode.ESCAPE_NONE, false);
    }

    public static Value asValue(boolean value) {
        return Value.literalValue(value, EscapeMode.ESCAPE_NONE, false);
    }

    public static Value asValue(Value value) {
        return value;
    }

    public static Value asVariableValue(String variableName, DataContext context) {
        return Value.variableValue(variableName, context);
    }

    public static boolean asBoolean(boolean value) {
        return value;
    }

    public static boolean asBoolean(String value) {
        return TypeConverter.asBoolean(value);
    }

    public static boolean asBoolean(int value) {
        return value != 0;
    }

    public static boolean asBoolean(Value value) {
        return value.asBoolean();
    }

    public static boolean asBoolean(Data data) {
        return TypeConverter.asBoolean(data);
    }

    public static String getNodeName(Data data) {
        return data == null ? "" : data.getSymlink().getName();
    }

    public Iterable<? extends Data> getChildren(Data parent) {
        if (parent == null) {
            return Collections.emptySet();
        }
        return parent.getChildren();
    }

    protected TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    protected void include(String templateName, boolean ignoreMissingFile, RenderingContext context) {
        if (!context.pushIncludeStackEntry(templateName)) {
            throw new JSilverInterpreterException(this.createIncludeLoopErrorMessage(templateName, context.getIncludedTemplateNames()));
        }
        this.loadAndRenderIncludedTemplate(templateName, ignoreMissingFile, context);
        if (!context.popIncludeStackEntry(templateName)) {
            throw new IllegalStateException("Unable to find on include stack: " + templateName);
        }
    }

    private void loadAndRenderIncludedTemplate(String templateName, boolean ignoreMissingFile, RenderingContext context) {
        Template template = null;
        try {
            template = this.templateLoader.load(templateName, context.getResourceLoader(), context.getAutoEscapeMode());
        }
        catch (RuntimeException e) {
            if (ignoreMissingFile && ExceptionUtil.isFileNotFoundException(e)) {
                return;
            }
            throw e;
        }
        try {
            template.render(context);
        }
        catch (IOException e) {
            throw new JSilverInterpreterException(e.getMessage());
        }
    }

    private String createIncludeLoopErrorMessage(String templateName, Iterable<String> includeStack) {
        StringBuilder message = new StringBuilder();
        message.append("File included twice: ");
        message.append(templateName);
        message.append(" Include stack:");
        for (String fileName : includeStack) {
            message.append("\n -> ");
            message.append(fileName);
        }
        message.append("\n -> ");
        message.append(templateName);
        return message.toString();
    }

    public abstract class CompiledMacro
    implements Macro {
        private final String macroName;
        private final String[] argumentsNames;

        protected CompiledMacro(String macroName, String ... argumentsNames) {
            this.macroName = macroName;
            this.argumentsNames = argumentsNames;
        }

        public void render(Data data, Appendable out, ResourceLoader resourceLoader) throws IOException {
            this.render(this.createRenderingContext(data, out, resourceLoader));
        }

        public RenderingContext createRenderingContext(Data data, Appendable out, ResourceLoader resourceLoader) {
            return BaseCompiledTemplate.this.createRenderingContext(data, out, resourceLoader);
        }

        public String getTemplateName() {
            return BaseCompiledTemplate.this.getTemplateName();
        }

        public String getMacroName() {
            return this.macroName;
        }

        public String getArgumentName(int index) {
            if (index >= this.argumentsNames.length) {
                throw new JSilverInterpreterException("Too many arguments supplied to macro " + this.macroName);
            }
            return this.argumentsNames[index];
        }

        public int getArgumentCount() {
            return this.argumentsNames.length;
        }

        protected TemplateLoader getTemplateLoader() {
            return BaseCompiledTemplate.this.templateLoader;
        }

        public EscapeMode getEscapeMode() {
            return BaseCompiledTemplate.this.getEscapeMode();
        }

        public String getDisplayName() {
            return BaseCompiledTemplate.this.getDisplayName() + ":" + this.macroName;
        }
    }
}

