/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.TaskHelper;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public abstract class SingleInputOutputTask
extends Task {
    private String mInput;
    private String mOutput;

    public void setInput(Path inputPath) {
        this.mInput = TaskHelper.checkSinglePath("input", inputPath);
    }

    public void setOutput(Path outputPath) {
        this.mOutput = TaskHelper.checkSinglePath("output", outputPath);
    }

    public final void execute() throws BuildException {
        if (this.mInput == null) {
            throw new BuildException("Missing attribute input");
        }
        if (this.mOutput == null) {
            throw new BuildException("Missing attribute output");
        }
        File outputFile = new File(this.mOutput);
        if (outputFile.isFile()) {
            File inputFile = new File(this.mInput);
            if (outputFile.lastModified() >= inputFile.lastModified()) {
                System.out.println(String.format("Run cancelled: no changes to input file %1$s", inputFile.getAbsolutePath()));
                return;
            }
        }
        this.createOutput();
    }

    protected abstract void createOutput() throws BuildException;

    protected String getInput() {
        return this.mInput;
    }

    protected String getOutput() {
        return this.mOutput;
    }
}

