/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ant.TaskHelper;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.utils.ILogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class GetUiTargetTask
extends Task {
    private String mCompileClassPathOut;

    public void setCompileClassPathOut(String compileClassPathOut) {
        this.mCompileClassPathOut = compileClassPathOut;
    }

    public void execute() throws BuildException {
        if (this.mCompileClassPathOut == null) {
            throw new BuildException("Missing attribute compileClassPathOut");
        }
        Project antProject = this.getProject();
        File sdkDir = TaskHelper.getSdkLocation(antProject);
        String targetHashString = antProject.getProperty("target");
        if (targetHashString == null) {
            throw new BuildException("Android Target is not set.");
        }
        final ArrayList messages = new ArrayList();
        SdkManager manager = SdkManager.createManager(sdkDir.getPath(), new ILogger(){

            @Override
            public void error(@Nullable Throwable t, @Nullable String errorFormat, Object ... args) {
                if (errorFormat != null) {
                    messages.add(String.format("Error: " + errorFormat, args));
                }
                if (t != null) {
                    messages.add("Error: " + t.getMessage());
                }
            }

            @Override
            public void info(@NonNull String msgFormat, Object ... args) {
                messages.add(String.format(msgFormat, args));
            }

            @Override
            public void verbose(@NonNull String msgFormat, Object ... args) {
                this.info(msgFormat, args);
            }

            @Override
            public void warning(@NonNull String warningFormat, Object ... args) {
                messages.add(String.format("Warning: " + warningFormat, args));
            }
        });
        if (manager == null) {
            for (String msg : messages) {
                System.out.println(msg);
            }
            throw new BuildException("Failed to parse SDK content.");
        }
        IAndroidTarget androidTarget = manager.getTargetFromHashString(targetHashString);
        if (androidTarget == null) {
            throw new BuildException(String.format("Unable to resolve project target '%s'", targetHashString));
        }
        System.out.println("Project Target:   " + androidTarget.getName());
        if (!androidTarget.isPlatform()) {
            System.out.println("Vendor:           " + androidTarget.getVendor());
            System.out.println("Platform Version: " + androidTarget.getVersionName());
        }
        System.out.println("API level:        " + androidTarget.getVersion().getApiString());
        if (androidTarget.getVersion().getApiLevel() < 16) {
            throw new BuildException("UI Automator requires API 16");
        }
        String androidJar = androidTarget.getPath(1);
        String uiAutomatorJar = androidTarget.getPath(27);
        Path compileclasspath = new Path(antProject);
        Path.PathElement element = compileclasspath.createPathElement();
        element.setPath(androidJar);
        element = compileclasspath.createPathElement();
        element.setPath(uiAutomatorJar);
        IAndroidTarget.IOptionalLibrary[] libraries = androidTarget.getOptionalLibraries();
        if (libraries != null) {
            HashSet<String> visitedJars = new HashSet<String>();
            for (IAndroidTarget.IOptionalLibrary library : libraries) {
                String jarPath = library.getJarPath();
                if (visitedJars.contains(jarPath)) continue;
                visitedJars.add(jarPath);
                element = compileclasspath.createPathElement();
                element.setPath(jarPath);
            }
        }
        antProject.addReference(this.mCompileClassPathOut, (Object)compileclasspath);
    }
}

