/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.InputPath;
import com.android.ant.SingleDependencyTask;
import com.android.ant.TaskHelper;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;

public class DexExecTask
extends SingleDependencyTask {
    private String mExecutable;
    private String mOutput;
    private String mDexedLibs;
    private boolean mVerbose = false;
    private boolean mNoLocals = false;
    private boolean mForceJumbo = false;
    private boolean mDisableDexMerger = false;
    private List<Path> mPathInputs;
    private List<FileSet> mFileSetInputs;

    public void setExecutable(Path executable) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", executable);
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public void setOutput(Path output) {
        this.mOutput = TaskHelper.checkSinglePath("output", output);
    }

    public void setDexedLibs(Path dexedLibs) {
        this.mDexedLibs = TaskHelper.checkSinglePath("dexedLibs", dexedLibs);
    }

    public void setNoLocals(boolean nolocals) {
        this.mNoLocals = nolocals;
    }

    public void setForceJumbo(boolean forceJumbo) {
        this.mForceJumbo = forceJumbo;
    }

    public void setDisableDexMerger(boolean disableMerger) {
        this.mDisableDexMerger = disableMerger;
    }

    public Object createPath() {
        if (this.mPathInputs == null) {
            this.mPathInputs = new ArrayList<Path>();
        }
        Path path = new Path(this.getProject());
        this.mPathInputs.add(path);
        return path;
    }

    public Object createFileSet() {
        if (this.mFileSetInputs == null) {
            this.mFileSetInputs = new ArrayList<FileSet>();
        }
        FileSet fs = new FileSet();
        fs.setProject(this.getProject());
        this.mFileSetInputs.add(fs);
        return fs;
    }

    private void preDexLibraries(List<File> inputs) {
        if (this.mDisableDexMerger || inputs.size() == 1) {
            return;
        }
        int count = inputs.size();
        for (int i = 0; i < count; ++i) {
            File input = inputs.get(i);
            if (!input.isFile()) continue;
            String fileName = this.getDexFileName(input);
            File dexedLib = new File(this.mDexedLibs, fileName);
            String dexedLibPath = dexedLib.getAbsolutePath();
            if (!dexedLib.isFile() || dexedLib.lastModified() < input.lastModified()) {
                System.out.println(String.format("Pre-Dexing %1$s -> %2$s", input.getAbsolutePath(), fileName));
                if (dexedLib.isFile()) {
                    dexedLib.delete();
                }
                this.runDx(input, dexedLibPath, false);
            } else {
                System.out.println(String.format("Using Pre-Dexed %1$s <- %2$s", fileName, input.getAbsolutePath()));
            }
            inputs.set(i, dexedLib);
        }
    }

    private String getDexFileName(File inputFile) {
        String name = inputFile.getName();
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        HashFunction hashFunction = Hashing.md5();
        HashCode hashCode = hashFunction.hashString(inputFile.getAbsolutePath());
        return name + "-" + hashCode.toString() + ".jar";
    }

    public void execute() throws BuildException {
        ArrayList<File> paths = new ArrayList<File>();
        if (this.mPathInputs != null) {
            for (Path pathList : this.mPathInputs) {
                for (String path : pathList.list()) {
                    System.out.println("input: " + path);
                    paths.add(new File(path));
                }
            }
        }
        if (this.mFileSetInputs != null) {
            for (FileSet fs : this.mFileSetInputs) {
                for (FileResource fr : fs) {
                    System.out.println("input: " + fr.getFile().toString());
                    paths.add(fr.getFile());
                }
            }
        }
        this.preDexLibraries(paths);
        String depFile = this.mOutput + ".d";
        List<InputPath> inputPaths = DexExecTask.getInputPaths(paths, null, null);
        if (this.initDependencies(depFile, inputPaths) && !this.dependenciesHaveChanged()) {
            System.out.println("No new compiled code. No need to convert bytecode to dalvik format.");
            return;
        }
        System.out.println(String.format("Converting compiled files and external libraries into %1$s...", this.mOutput));
        this.runDx(paths, this.mOutput, this.mVerbose);
        this.generateDependencyFile(depFile, inputPaths, this.mOutput);
    }

    private void runDx(File input, String output, boolean showInputs) {
        this.runDx(Collections.singleton(input), output, showInputs);
    }

    private void runDx(Collection<File> inputs, String output, boolean showInputs) {
        ExecTask task = new ExecTask();
        task.setProject(this.getProject());
        task.setOwningTarget(this.getOwningTarget());
        task.setExecutable(this.mExecutable);
        task.setTaskName(this.getExecTaskName());
        task.setFailonerror(true);
        task.createArg().setValue("--dex");
        if (this.mNoLocals) {
            task.createArg().setValue("--no-locals");
        }
        if (this.mVerbose) {
            task.createArg().setValue("--verbose");
        }
        if (this.mForceJumbo) {
            task.createArg().setValue("--force-jumbo");
        }
        task.createArg().setValue("--output");
        task.createArg().setValue(output);
        for (File input : inputs) {
            String absPath = input.getAbsolutePath();
            if (showInputs) {
                System.out.println("Input: " + absPath);
            }
            task.createArg().setValue(absPath);
        }
        task.execute();
    }

    @Override
    protected String getExecTaskName() {
        return "dx";
    }
}

