/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.editors;

import com.android.ide.eclipse.gltrace.state.GLListProperty;
import com.android.ide.eclipse.gltrace.state.GLSparseArrayProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import java.util.Set;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class StateLabelProvider
extends ColumnLabelProvider {
    private Set<IGLProperty> mChangedProperties;
    private Color mHighlightForegroundColor = Display.getDefault().getSystemColor(9);
    private Color mNormalForegroundColor = Display.getDefault().getSystemColor(2);

    public String getColumnText(IGLProperty iGLProperty, int n) {
        switch (n) {
            case 0: {
                return this.getName(iGLProperty);
            }
            case 1: {
                return this.getValue(iGLProperty);
            }
        }
        return "";
    }

    private String getValue(IGLProperty iGLProperty) {
        return iGLProperty.getStringValue();
    }

    private String getName(IGLProperty iGLProperty) {
        IGLProperty iGLProperty2 = iGLProperty.getParent();
        if (iGLProperty2 instanceof GLListProperty) {
            int n = ((GLListProperty)iGLProperty2).indexOf(iGLProperty);
            if (iGLProperty.getType() == GLStateType.GL_STATE_ES1) {
                return String.format("Context %d (ES1)", n);
            }
            if (iGLProperty.getType() == GLStateType.GL_STATE_ES2) {
                return String.format("Context %d (ES2)", n);
            }
            return Integer.toString(n);
        }
        if (iGLProperty2 instanceof GLSparseArrayProperty) {
            int n = ((GLSparseArrayProperty)iGLProperty2).keyFor(iGLProperty);
            return Integer.toString(n);
        }
        return iGLProperty.getType().getDescription();
    }

    public void update(ViewerCell viewerCell) {
        Object object = viewerCell.getElement();
        if (!(object instanceof IGLProperty)) {
            return;
        }
        IGLProperty iGLProperty = (IGLProperty)object;
        String string = this.getColumnText(iGLProperty, viewerCell.getColumnIndex());
        viewerCell.setText(string);
        if (this.mChangedProperties != null && this.mChangedProperties.contains(iGLProperty)) {
            viewerCell.setForeground(this.mHighlightForegroundColor);
        } else {
            viewerCell.setForeground(this.mNormalForegroundColor);
        }
    }

    public void setChangedProperties(Set<IGLProperty> set) {
        this.mChangedProperties = set;
    }
}

