/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace;

import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class TraceFileWriter {
    private DataInputStream mInputStream;
    private DataOutputStream mOutputStream;
    private Thread mReceiverThread;
    private int mFileSize = 0;
    private int mFrameCount = 0;

    public TraceFileWriter(FileOutputStream fileOutputStream, DataInputStream dataInputStream) {
        this.mOutputStream = new DataOutputStream(fileOutputStream);
        this.mInputStream = dataInputStream;
    }

    public void start() {
        this.mReceiverThread = new Thread(new GLTraceReceiverTask());
        this.mReceiverThread.setName("GL Trace Receiver");
        this.mReceiverThread.start();
    }

    public void stopTracing() {
        try {
            this.mInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            this.mReceiverThread.join();
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.mOutputStream.close();
        }
        catch (IOException iOException) {}
    }

    private byte[] readTraceData(DataInputStream dataInputStream) {
        int n;
        int n2;
        try {
            n2 = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            return null;
        }
        n2 = Integer.reverseBytes(n2);
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; i += n) {
            block6: {
                try {
                    n = dataInputStream.read(byArray, i, n2 - i);
                    if (n >= 0) break block6;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            continue;
        }
        return byArray;
    }

    private void writeTraceData(byte[] byArray, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
    }

    private void updateTraceStats(byte[] byArray) {
        GLProtoBuf.GLMessage gLMessage = null;
        try {
            gLMessage = GLProtoBuf.GLMessage.parseFrom(byArray);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            return;
        }
        this.mFileSize += byArray.length;
        if (gLMessage.getFunction() == GLProtoBuf.GLMessage.Function.eglSwapBuffers) {
            ++this.mFrameCount;
        }
    }

    public int getCurrentFileSize() {
        return this.mFileSize;
    }

    public int getCurrentFrameCount() {
        return this.mFrameCount;
    }

    private class GLTraceReceiverTask
    implements Runnable {
        private GLTraceReceiverTask() {
        }

        @Override
        public void run() {
            byte[] byArray;
            while ((byArray = TraceFileWriter.this.readTraceData(TraceFileWriter.this.mInputStream)) != null) {
                try {
                    TraceFileWriter.this.writeTraceData(byArray, TraceFileWriter.this.mOutputStream);
                }
                catch (IOException iOException) {
                    break;
                }
                TraceFileWriter.this.updateTraceStats(byArray);
            }
        }
    }
}

