/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceType;
import com.google.common.annotations.Beta;
import java.util.EnumSet;

@Beta
public interface IAttributeInfo {
    @NonNull
    public String getName();

    @NonNull
    public EnumSet<Format> getFormats();

    @Nullable
    public String[] getEnumValues();

    @Nullable
    public String[] getFlagValues();

    @NonNull
    public String getJavaDoc();

    @Nullable
    public String getDeprecatedDoc();

    @NonNull
    public String getDefinedBy();

    public static enum Format {
        STRING,
        BOOLEAN,
        INTEGER,
        FLOAT,
        COLOR,
        DIMENSION,
        FRACTION,
        ENUM,
        FLAG,
        REFERENCE;

        public static final EnumSet<Format> NONE;
        public static final EnumSet<Format> FLAG_SET;
        public static final EnumSet<Format> ENUM_SET;
        public static final EnumSet<Format> COLOR_SET;
        public static final EnumSet<Format> STRING_SET;
        public static final EnumSet<Format> BOOLEAN_SET;
        public static final EnumSet<Format> INTEGER_SET;
        public static final EnumSet<Format> FLOAT_SET;
        public static final EnumSet<Format> DIMENSION_SET;
        public static final EnumSet<Format> REFERENCE_SET;

        @NonNull
        public EnumSet<Format> asSet() {
            switch (this) {
                case BOOLEAN: {
                    return BOOLEAN_SET;
                }
                case COLOR: {
                    return COLOR_SET;
                }
                case DIMENSION: {
                    return DIMENSION_SET;
                }
                case ENUM: {
                    return ENUM_SET;
                }
                case FLAG: {
                    return FLAG_SET;
                }
                case FLOAT: {
                    return FLOAT_SET;
                }
                case INTEGER: {
                    return INTEGER_SET;
                }
                case STRING: {
                    return STRING_SET;
                }
                case REFERENCE: {
                    return REFERENCE_SET;
                }
            }
            return EnumSet.of(this);
        }

        @Nullable
        public ResourceType getResourceType() {
            switch (this) {
                case STRING: {
                    return ResourceType.STRING;
                }
                case BOOLEAN: {
                    return ResourceType.BOOL;
                }
                case COLOR: {
                    return ResourceType.COLOR;
                }
                case DIMENSION: {
                    return ResourceType.DIMEN;
                }
                case FRACTION: {
                    return ResourceType.FRACTION;
                }
                case INTEGER: {
                    return ResourceType.INTEGER;
                }
                case ENUM: 
                case FLAG: 
                case FLOAT: 
                case REFERENCE: {
                    return null;
                }
            }
            return null;
        }

        static {
            NONE = EnumSet.noneOf(Format.class);
            FLAG_SET = EnumSet.of(FLAG);
            ENUM_SET = EnumSet.of(ENUM);
            COLOR_SET = EnumSet.of(COLOR);
            STRING_SET = EnumSet.of(STRING);
            BOOLEAN_SET = EnumSet.of(BOOLEAN);
            INTEGER_SET = EnumSet.of(INTEGER);
            FLOAT_SET = EnumSet.of(FLOAT);
            DIMENSION_SET = EnumSet.of(DIMENSION);
            REFERENCE_SET = EnumSet.of(REFERENCE);
        }
    }
}

