/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import java.math.BigInteger;
import llvm.SWIGTYPE_p_unsigned_int;
import llvm.SWIGTYPE_p_unsigned_long_long;
import llvm.llvmJNI;

public class TimeValue {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    protected TimeValue(long l2, boolean bl2) {
        this.swigCMemOwn = bl2;
        this.swigCPtr = l2;
    }

    protected static long getCPtr(TimeValue timeValue) {
        return timeValue == null ? 0L : timeValue.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_TimeValue(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static TimeValue getMinTime() {
        long l2 = llvmJNI.TimeValue_MinTime_get();
        return l2 == 0L ? null : new TimeValue(l2, false);
    }

    public static TimeValue getMaxTime() {
        long l2 = llvmJNI.TimeValue_MaxTime_get();
        return l2 == 0L ? null : new TimeValue(l2, false);
    }

    public static TimeValue getZeroTime() {
        long l2 = llvmJNI.TimeValue_ZeroTime_get();
        return l2 == 0L ? null : new TimeValue(l2, false);
    }

    public static TimeValue getPosixZeroTime() {
        long l2 = llvmJNI.TimeValue_PosixZeroTime_get();
        return l2 == 0L ? null : new TimeValue(l2, false);
    }

    public static TimeValue getWin32ZeroTime() {
        long l2 = llvmJNI.TimeValue_Win32ZeroTime_get();
        return l2 == 0L ? null : new TimeValue(l2, false);
    }

    public TimeValue(long l2, int n2) {
        this(llvmJNI.new_TimeValue__SWIG_0(l2, n2), true);
    }

    public TimeValue(long l2) {
        this(llvmJNI.new_TimeValue__SWIG_1(l2), true);
    }

    public TimeValue(double d2) {
        this(llvmJNI.new_TimeValue__SWIG_2(d2), true);
    }

    public static TimeValue now() {
        return new TimeValue(llvmJNI.TimeValue_now(), true);
    }

    public long seconds() {
        return llvmJNI.TimeValue_seconds__SWIG_0(this.swigCPtr, this);
    }

    public int nanoseconds() {
        return llvmJNI.TimeValue_nanoseconds__SWIG_0(this.swigCPtr, this);
    }

    public long microseconds() {
        return llvmJNI.TimeValue_microseconds__SWIG_0(this.swigCPtr, this);
    }

    public long milliseconds() {
        return llvmJNI.TimeValue_milliseconds__SWIG_0(this.swigCPtr, this);
    }

    public BigInteger usec() {
        return llvmJNI.TimeValue_usec__SWIG_0(this.swigCPtr, this);
    }

    public BigInteger msec() {
        return llvmJNI.TimeValue_msec__SWIG_0(this.swigCPtr, this);
    }

    public BigInteger toPosixTime() {
        return llvmJNI.TimeValue_toPosixTime(this.swigCPtr, this);
    }

    public BigInteger toEpochTime() {
        return llvmJNI.TimeValue_toEpochTime(this.swigCPtr, this);
    }

    public BigInteger toWin32Time() {
        return llvmJNI.TimeValue_toWin32Time(this.swigCPtr, this);
    }

    public void getTimespecTime(SWIGTYPE_p_unsigned_long_long sWIGTYPE_p_unsigned_long_long, SWIGTYPE_p_unsigned_int sWIGTYPE_p_unsigned_int) {
        llvmJNI.TimeValue_getTimespecTime(this.swigCPtr, this, SWIGTYPE_p_unsigned_long_long.getCPtr(sWIGTYPE_p_unsigned_long_long), SWIGTYPE_p_unsigned_int.getCPtr(sWIGTYPE_p_unsigned_int));
    }

    public String str() {
        return llvmJNI.TimeValue_str(this.swigCPtr, this);
    }

    public void seconds(long l2) {
        llvmJNI.TimeValue_seconds__SWIG_1(this.swigCPtr, this, l2);
    }

    public void nanoseconds(int n2) {
        llvmJNI.TimeValue_nanoseconds__SWIG_1(this.swigCPtr, this, n2);
    }

    public void microseconds(int n2) {
        llvmJNI.TimeValue_microseconds__SWIG_1(this.swigCPtr, this, n2);
    }

    public void milliseconds(int n2) {
        llvmJNI.TimeValue_milliseconds__SWIG_1(this.swigCPtr, this, n2);
    }

    public void usec(long l2) {
        llvmJNI.TimeValue_usec__SWIG_1(this.swigCPtr, this, l2);
    }

    public void msec(long l2) {
        llvmJNI.TimeValue_msec__SWIG_1(this.swigCPtr, this, l2);
    }

    public void fromEpochTime(long l2) {
        llvmJNI.TimeValue_fromEpochTime(this.swigCPtr, this, l2);
    }

    public void fromWin32Time(BigInteger bigInteger) {
        llvmJNI.TimeValue_fromWin32Time(this.swigCPtr, this, bigInteger);
    }

    public static final class TimeConversions {
        public static final TimeConversions NANOSECONDS_PER_SECOND = new TimeConversions("NANOSECONDS_PER_SECOND", llvmJNI.TimeValue_NANOSECONDS_PER_SECOND_get());
        public static final TimeConversions MICROSECONDS_PER_SECOND = new TimeConversions("MICROSECONDS_PER_SECOND", llvmJNI.TimeValue_MICROSECONDS_PER_SECOND_get());
        public static final TimeConversions MILLISECONDS_PER_SECOND = new TimeConversions("MILLISECONDS_PER_SECOND", llvmJNI.TimeValue_MILLISECONDS_PER_SECOND_get());
        public static final TimeConversions NANOSECONDS_PER_MICROSECOND = new TimeConversions("NANOSECONDS_PER_MICROSECOND", llvmJNI.TimeValue_NANOSECONDS_PER_MICROSECOND_get());
        public static final TimeConversions NANOSECONDS_PER_MILLISECOND = new TimeConversions("NANOSECONDS_PER_MILLISECOND", llvmJNI.TimeValue_NANOSECONDS_PER_MILLISECOND_get());
        public static final TimeConversions NANOSECONDS_PER_POSIX_TICK = new TimeConversions("NANOSECONDS_PER_POSIX_TICK", llvmJNI.TimeValue_NANOSECONDS_PER_POSIX_TICK_get());
        public static final TimeConversions NANOSECONDS_PER_WIN32_TICK = new TimeConversions("NANOSECONDS_PER_WIN32_TICK", llvmJNI.TimeValue_NANOSECONDS_PER_WIN32_TICK_get());
        private static TimeConversions[] swigValues = new TimeConversions[]{NANOSECONDS_PER_SECOND, MICROSECONDS_PER_SECOND, MILLISECONDS_PER_SECOND, NANOSECONDS_PER_MICROSECOND, NANOSECONDS_PER_MILLISECOND, NANOSECONDS_PER_POSIX_TICK, NANOSECONDS_PER_WIN32_TICK};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static TimeConversions swigToEnum(int n2) {
            if (n2 < swigValues.length && n2 >= 0 && TimeConversions.swigValues[n2].swigValue == n2) {
                return swigValues[n2];
            }
            for (int i2 = 0; i2 < swigValues.length; ++i2) {
                if (TimeConversions.swigValues[i2].swigValue != n2) continue;
                return swigValues[i2];
            }
            throw new IllegalArgumentException("No enum " + TimeConversions.class + " with value " + n2);
        }

        private TimeConversions(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private TimeConversions(String string, int n2) {
            this.swigName = string;
            this.swigValue = n2;
            swigNext = n2 + 1;
        }

        private TimeConversions(String string, TimeConversions timeConversions) {
            this.swigName = string;
            this.swigValue = timeConversions.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

