/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.DominatorTree;
import llvm.FastFoldingSetNode;
import llvm.SWIGTYPE_p_llvm__Loop;
import llvm.Type;
import llvm.llvmJNI;
import llvm.raw_ostream;

public class SCEV
extends FastFoldingSetNode {
    private long swigCPtr;

    protected SCEV(long l2, boolean bl2) {
        super(llvmJNI.SWIGSCEVUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(SCEV sCEV) {
        return sCEV == null ? 0L : sCEV.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public long getSCEVType() {
        return llvmJNI.SCEV_getSCEVType(this.swigCPtr, this);
    }

    public boolean isLoopInvariant(SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop) {
        return llvmJNI.SCEV_isLoopInvariant(this.swigCPtr, this, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop));
    }

    public boolean hasComputableLoopEvolution(SWIGTYPE_p_llvm__Loop sWIGTYPE_p_llvm__Loop) {
        return llvmJNI.SCEV_hasComputableLoopEvolution(this.swigCPtr, this, SWIGTYPE_p_llvm__Loop.getCPtr(sWIGTYPE_p_llvm__Loop));
    }

    public Type getType() {
        long l2 = llvmJNI.SCEV_getType(this.swigCPtr, this);
        return l2 == 0L ? null : new Type(l2, false);
    }

    public boolean isZero() {
        return llvmJNI.SCEV_isZero(this.swigCPtr, this);
    }

    public boolean isOne() {
        return llvmJNI.SCEV_isOne(this.swigCPtr, this);
    }

    public boolean isAllOnesValue() {
        return llvmJNI.SCEV_isAllOnesValue(this.swigCPtr, this);
    }

    public boolean hasOperand(SCEV sCEV) {
        return llvmJNI.SCEV_hasOperand(this.swigCPtr, this, SCEV.getCPtr(sCEV), sCEV);
    }

    public boolean dominates(BasicBlock basicBlock, DominatorTree dominatorTree) {
        return llvmJNI.SCEV_dominates(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock, DominatorTree.getCPtr(dominatorTree), dominatorTree);
    }

    public boolean properlyDominates(BasicBlock basicBlock, DominatorTree dominatorTree) {
        return llvmJNI.SCEV_properlyDominates(this.swigCPtr, this, BasicBlock.getCPtr(basicBlock), basicBlock, DominatorTree.getCPtr(dominatorTree), dominatorTree);
    }

    public void print(raw_ostream raw_ostream2) {
        llvmJNI.SCEV_print(this.swigCPtr, this, raw_ostream.getCPtr(raw_ostream2), raw_ostream2);
    }

    public void dump() {
        llvmJNI.SCEV_dump(this.swigCPtr, this);
    }
}

