/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.APFloat;
import llvm.Constant;
import llvm.LLVMContext;
import llvm.StringRef;
import llvm.Type;
import llvm.Value;
import llvm.llvmJNI;

public class ConstantFP
extends Constant {
    private long swigCPtr;

    protected ConstantFP(long l2, boolean bl2) {
        super(llvmJNI.SWIGConstantFPUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(ConstantFP constantFP) {
        return constantFP == null ? 0L : constantFP.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_ConstantFP(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static Constant getZeroValueForNegation(Type type) {
        long l2 = llvmJNI.ConstantFP_getZeroValueForNegation(Type.getCPtr(type), type);
        return l2 == 0L ? null : new Constant(l2, false);
    }

    public static Constant get(Type type, double d2) {
        long l2 = llvmJNI.ConstantFP_get__SWIG_0(Type.getCPtr(type), type, d2);
        return l2 == 0L ? null : new Constant(l2, false);
    }

    public static Constant get(Type type, StringRef stringRef) {
        long l2 = llvmJNI.ConstantFP_get__SWIG_1(Type.getCPtr(type), type, StringRef.getCPtr(stringRef), stringRef);
        return l2 == 0L ? null : new Constant(l2, false);
    }

    public static ConstantFP get(LLVMContext lLVMContext, APFloat aPFloat) {
        long l2 = llvmJNI.ConstantFP_get__SWIG_2(LLVMContext.getCPtr(lLVMContext), lLVMContext, APFloat.getCPtr(aPFloat), aPFloat);
        return l2 == 0L ? null : new ConstantFP(l2, false);
    }

    public static ConstantFP getNegativeZero(Type type) {
        long l2 = llvmJNI.ConstantFP_getNegativeZero(Type.getCPtr(type), type);
        return l2 == 0L ? null : new ConstantFP(l2, false);
    }

    public static ConstantFP getInfinity(Type type, boolean bl2) {
        long l2 = llvmJNI.ConstantFP_getInfinity__SWIG_0(Type.getCPtr(type), type, bl2);
        return l2 == 0L ? null : new ConstantFP(l2, false);
    }

    public static ConstantFP getInfinity(Type type) {
        long l2 = llvmJNI.ConstantFP_getInfinity__SWIG_1(Type.getCPtr(type), type);
        return l2 == 0L ? null : new ConstantFP(l2, false);
    }

    public static boolean isValueValidForType(Type type, APFloat aPFloat) {
        return llvmJNI.ConstantFP_isValueValidForType(Type.getCPtr(type), type, APFloat.getCPtr(aPFloat), aPFloat);
    }

    public APFloat getValueAPF() {
        return new APFloat(llvmJNI.ConstantFP_getValueAPF(this.swigCPtr, this), false);
    }

    public boolean isNullValue() {
        return llvmJNI.ConstantFP_isNullValue(this.swigCPtr, this);
    }

    public boolean isNegativeZeroValue() {
        return llvmJNI.ConstantFP_isNegativeZeroValue(this.swigCPtr, this);
    }

    public boolean isZero() {
        return llvmJNI.ConstantFP_isZero(this.swigCPtr, this);
    }

    public boolean isNaN() {
        return llvmJNI.ConstantFP_isNaN(this.swigCPtr, this);
    }

    public boolean isExactlyValue(APFloat aPFloat) {
        return llvmJNI.ConstantFP_isExactlyValue__SWIG_0(this.swigCPtr, this, APFloat.getCPtr(aPFloat), aPFloat);
    }

    public boolean isExactlyValue(double d2) {
        return llvmJNI.ConstantFP_isExactlyValue__SWIG_1(this.swigCPtr, this, d2);
    }

    public static boolean classof(ConstantFP constantFP) {
        return llvmJNI.ConstantFP_classof__SWIG_0(ConstantFP.getCPtr(constantFP), constantFP);
    }

    public static boolean classof(Value value) {
        return llvmJNI.ConstantFP_classof__SWIG_1(Value.getCPtr(value), value);
    }

    public static ConstantFP dyn_cast(Constant constant) {
        long l2 = llvmJNI.ConstantFP_dyn_cast(Constant.getCPtr(constant), constant);
        return l2 == 0L ? null : new ConstantFP(l2, false);
    }
}

