/*
 * Decompiled with CFR 0.152.
 */
package llvm;

import llvm.BasicBlock;
import llvm.Constant;
import llvm.Function;
import llvm.Use;
import llvm.Value;
import llvm.llvmJNI;

public class BlockAddress
extends Constant {
    private long swigCPtr;

    protected BlockAddress(long l2, boolean bl2) {
        super(llvmJNI.SWIGBlockAddressUpcast(l2), bl2);
        this.swigCPtr = l2;
    }

    protected static long getCPtr(BlockAddress blockAddress) {
        return blockAddress == null ? 0L : blockAddress.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                llvmJNI.delete_BlockAddress(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public static BlockAddress get(Function function, BasicBlock basicBlock) {
        long l2 = llvmJNI.BlockAddress_get__SWIG_0(Function.getCPtr(function), function, BasicBlock.getCPtr(basicBlock), basicBlock);
        return l2 == 0L ? null : new BlockAddress(l2, false);
    }

    public static BlockAddress get(BasicBlock basicBlock) {
        long l2 = llvmJNI.BlockAddress_get__SWIG_1(BasicBlock.getCPtr(basicBlock), basicBlock);
        return l2 == 0L ? null : new BlockAddress(l2, false);
    }

    public Value getOperandValue(long l2) {
        long l3 = llvmJNI.BlockAddress_getOperandValue(this.swigCPtr, this, l2);
        return l3 == 0L ? null : new Value(l3, false);
    }

    public void setOperand(long l2, Value value) {
        llvmJNI.BlockAddress_setOperand(this.swigCPtr, this, l2, Value.getCPtr(value), value);
    }

    public Use op_begin() {
        long l2 = llvmJNI.BlockAddress_op_begin__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Use(l2, false);
    }

    public Use op_end() {
        long l2 = llvmJNI.BlockAddress_op_end__SWIG_0(this.swigCPtr, this);
        return l2 == 0L ? null : new Use(l2, false);
    }

    public long getNumOperands() {
        return llvmJNI.BlockAddress_getNumOperands(this.swigCPtr, this);
    }

    public Function getFunction() {
        long l2 = llvmJNI.BlockAddress_getFunction(this.swigCPtr, this);
        return l2 == 0L ? null : new Function(l2, false);
    }

    public BasicBlock getBasicBlock() {
        long l2 = llvmJNI.BlockAddress_getBasicBlock(this.swigCPtr, this);
        return l2 == 0L ? null : new BasicBlock(l2, false);
    }

    public boolean isNullValue() {
        return llvmJNI.BlockAddress_isNullValue(this.swigCPtr, this);
    }

    public void destroyConstant() {
        llvmJNI.BlockAddress_destroyConstant(this.swigCPtr, this);
    }

    public void replaceUsesOfWithOnConstant(Value value, Value value2, Use use) {
        llvmJNI.BlockAddress_replaceUsesOfWithOnConstant(this.swigCPtr, this, Value.getCPtr(value), value, Value.getCPtr(value2), value2, Use.getCPtr(use), use);
    }

    public static boolean classof(BlockAddress blockAddress) {
        return llvmJNI.BlockAddress_classof__SWIG_0(BlockAddress.getCPtr(blockAddress), blockAddress);
    }

    public static boolean classof(Value value) {
        return llvmJNI.BlockAddress_classof__SWIG_1(Value.getCPtr(value), value);
    }

    public static BlockAddress dyn_cast(Constant constant) {
        long l2 = llvmJNI.BlockAddress_dyn_cast(Constant.getCPtr(constant), constant);
        return l2 == 0L ? null : new BlockAddress(l2, false);
    }
}

