/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.Utils;
import com.adobe.air.validator.DescriptorValidator;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApplicationDescriptorValidator
extends DescriptorValidator {
    private String _rootContent;
    private Map<String, Dimension> _icons = new HashMap<String, Dimension>();

    public Set<String> getIcons() {
        return this._icons.keySet();
    }

    public final Dimension getIconDimension(String path) {
        return this._icons.get(path);
    }

    protected String validateRootContentURI(String rootContent) {
        URI uri = this.validateUri(rootContent);
        if (uri == null) {
            return null;
        }
        this._rootContent = Utils.performPlatformUnicodePathNormalization(uri.getPath().substring(1));
        return this._rootContent;
    }

    public void validateRootContentFile(Map<String, File> sources, boolean allowHTML) {
        if (!sources.containsKey(this._rootContent)) {
            this.dispatchError(302, new String[]{this._rootContent.trim()});
            return;
        }
        File file = sources.get(this._rootContent);
        try {
            this.validateRootContentFile(new FileInputStream(file), allowHTML);
        }
        catch (IOException ex) {
            this.dispatchError(300, new String[]{this._rootContent.trim()});
        }
    }

    public void validateRootContentFile(InputStream is, boolean allowHTML) {
        try {
            boolean isSWF;
            byte[] firstBytes = new byte[4];
            is.read(firstBytes);
            is.close();
            boolean bl2 = isSWF = (firstBytes[0] == 70 || firstBytes[0] == 67) && firstBytes[1] == 87 && firstBytes[2] == 83;
            if (isSWF) {
                byte version = firstBytes[3];
                if (version == 0) {
                    this.dispatchError(304, new String[0]);
                    return;
                }
                if (version > this.getMaximumSWFVersion()) {
                    this.dispatchError(305, new String[]{Integer.toString(version), this.getNamespace()});
                    return;
                }
            } else {
                boolean isPNG;
                if (!allowHTML) {
                    this.dispatchError(304, new String[0]);
                    return;
                }
                boolean isGIF = firstBytes[0] == 71 && firstBytes[1] == 73 && firstBytes[2] == 70;
                boolean isTIFFM = firstBytes[0] == 77 && firstBytes[1] == 77 && firstBytes[2] == 0 && firstBytes[3] == 42;
                boolean isTIFFI = firstBytes[0] == 73 && firstBytes[1] == 73 && firstBytes[2] == 42 && firstBytes[3] == 0;
                boolean isJPEG = firstBytes[0] == -1 && firstBytes[1] == -40;
                boolean bl3 = isPNG = firstBytes[0] == -119 && firstBytes[1] == 80 && firstBytes[2] == 78 && firstBytes[3] == 71;
                if (isGIF || isTIFFM || isTIFFI || isJPEG || isPNG) {
                    this.dispatchError(304, new String[0]);
                }
            }
        }
        catch (IOException ex) {
            this.dispatchError(300, new String[]{this._rootContent.trim()});
        }
    }

    protected String validateImageUri(String path, int width, int height) {
        URI uri = this.validateUri(path);
        if (uri == null) {
            return null;
        }
        String uriPath = Utils.performPlatformUnicodePathNormalization(uri.getPath().substring(1));
        if (this._icons.get(uriPath) != null && this._icons.get((Object)uriPath).width != width && this._icons.get((Object)uriPath).height != height) {
            this.dispatchError(201, new String[]{uriPath});
            return null;
        }
        this._icons.put(uriPath, new Dimension(width, height));
        return uriPath;
    }

    public void validateImageFiles(Map<String, File> sources, boolean allowCrushedPNG) {
        for (String path : this._icons.keySet()) {
            this.validateImageFile(sources, path, allowCrushedPNG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateImageFile(Map<String, File> sources, String iconPath, boolean allowCrushedPNG) {
        if (!sources.containsKey(iconPath)) {
            this.dispatchError(303, new String[]{iconPath.trim()});
            return;
        }
        File file = sources.get(iconPath);
        String uriValue = iconPath.trim();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.validateImage(fis, uriValue, allowCrushedPNG);
        }
        catch (Exception e2) {
            this.dispatchError(200, new String[]{uriValue});
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e3) {}
        }
    }

    public void validateImage(InputStream is, String name, boolean allowCrushedPNG) {
        block14: {
            if (!this._icons.containsKey(name)) {
                throw new IllegalStateException("Tried to validate an icon that's not in the descriptor");
            }
            int requiredWidth = this._icons.get((Object)name).width;
            int requiredHeight = this._icons.get((Object)name).height;
            try {
                byte[] preamble = new byte[PNG_SIGNATURE.length];
                if (is.read(preamble) != preamble.length) {
                    this.dispatchError(202, new String[]{name});
                    return;
                }
                for (int i2 = 0; i2 < PNG_SIGNATURE.length; ++i2) {
                    if (preamble[i2] == PNG_SIGNATURE[i2]) continue;
                    this.dispatchError(202, new String[]{name});
                    return;
                }
                byte[] firstHeaderBytes = new byte[8];
                if (is.read(firstHeaderBytes) != firstHeaderBytes.length) {
                    this.dispatchError(202, new String[]{name});
                    return;
                }
                int chunkSize = ApplicationDescriptorValidator.bytesToInt(firstHeaderBytes, 0);
                int header = ApplicationDescriptorValidator.bytesToInt(firstHeaderBytes, 4);
                if (header == 1130840649) {
                    if (!allowCrushedPNG) {
                        this.dispatchError(202, new String[]{name});
                        return;
                    }
                    if (is.skip(chunkSize + 4) != (long)(chunkSize + 4)) {
                        this.dispatchError(202, new String[]{name});
                        return;
                    }
                    byte[] secondHeaderBytes = new byte[8];
                    if (is.read(secondHeaderBytes) != secondHeaderBytes.length) {
                        this.dispatchError(202, new String[]{name});
                        return;
                    }
                    chunkSize = ApplicationDescriptorValidator.bytesToInt(secondHeaderBytes, 0);
                    header = ApplicationDescriptorValidator.bytesToInt(secondHeaderBytes, 4);
                }
                if (header == 1229472850) {
                    if (chunkSize != 13) {
                        this.dispatchError(202, new String[]{name});
                        return;
                    }
                    byte[] chunk = new byte[chunkSize];
                    if (is.read(chunk) != chunk.length) {
                        this.dispatchError(202, new String[]{name});
                        return;
                    }
                    int pngWidth = ApplicationDescriptorValidator.bytesToInt(chunk, 0);
                    int pngHeight = ApplicationDescriptorValidator.bytesToInt(chunk, 4);
                    if (pngWidth != requiredWidth || pngHeight != requiredHeight) {
                        this.dispatchError(201, new String[]{name});
                        return;
                    }
                    break block14;
                }
                this.dispatchError(202, new String[]{name});
                return;
            }
            catch (Exception e2) {
                this.dispatchError(200, new String[]{name});
                return;
            }
        }
    }

    protected boolean validatePListString(String s2) {
        boolean valid = true;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new InputSource(new StringReader(s2)));
            Node rootNode = document.getDocumentElement().getFirstChild();
            NodeList children = rootNode.getChildNodes();
            HashSet<String> seenKeys = new HashSet<String>();
            for (int i2 = 0; i2 < children.getLength(); ++i2) {
                Node child = children.item(i2);
                if (child.getNodeType() != 1 || !child.getNodeName().equalsIgnoreCase("key")) continue;
                String keyValue = child.getTextContent().trim();
                if (!seenKeys.add(keyValue)) {
                    valid = false;
                    break;
                }
                if (!keyValue.equals("CFBundleVersion") && !keyValue.equals("CFBundleShortVersionString") && !keyValue.equals("CFBundleIdentifier") && !keyValue.equals("CFBundleInfoDictionaryVersion") && !keyValue.equals("CFBundleExecutable") && !keyValue.equals("CFBundleDisplayName") && !keyValue.equals("CFBundlePackageType") && !keyValue.equals("DTPlatformName") && !keyValue.equals("DTSDKName") && !keyValue.equals("DTCompiler") && !keyValue.equals("DTPlatformBuild") && !keyValue.equals("DTPlatformName") && !keyValue.equals("DTPlatformVersion") && !keyValue.equals("DTXcode") && !keyValue.equals("DTXcodeBuild") && !keyValue.equals("LSRequiresIPhoneOS") && !keyValue.equals("MinimumOSVersion") && !keyValue.equals("NSMainNibFile") && !keyValue.equals("CFBundleResourceSpecification") && !keyValue.equals("UIStatusBarHidden") && !keyValue.equals("UIInterfaceOrientation") && !keyValue.equals("UISupportedInterfaceOrientations") && !keyValue.equals("CTAutoOrients") && !keyValue.equals("CTInitialWindowVisible") && !keyValue.equals("CTInitialWindowTitle") && !keyValue.equals("CFBundleIconFiles") && !keyValue.equals("CFBundleSupportedPlatforms")) continue;
                valid = false;
                break;
            }
            if (valid) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                StreamSource schemaFile = new StreamSource(this.getClass().getResourceAsStream("PropertyList-1.0.xsd"));
                Schema schema = factory.newSchema(schemaFile);
                Validator validator = schema.newValidator();
                validator.validate(new DOMSource(document));
            }
        }
        catch (Exception e2) {
            valid = false;
        }
        return valid;
    }

    protected boolean validateManifestAdditions(String s2) {
        boolean valid = true;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new InputSource(new StringReader(s2)));
        }
        catch (Exception e2) {
            valid = false;
        }
        return valid;
    }

    public abstract int getMaximumSWFVersion();
}

