/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTPackager;
import com.adobe.air.AIROutputStream;
import com.adobe.air.ANEFile;
import com.adobe.air.ExtensionDescriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public final class ANEPackager
extends ADTPackager {
    protected static final int MIN_SWF_VERSION = 10;
    protected static final String PATH_CATALOG = "catalog.xml";
    protected static final String PATH_LIBRARY_SWF = "library.swf";
    private File m_swcFile;
    private File m_extensionDescriptorFile;
    private File m_unsignedAneFile;
    private HashSet<String> m_implementedPlatformNames = new HashSet();

    public ANEPackager() {
        super("ANE");
        this.setStream(new AIROutputStream());
    }

    protected void validate(File mainLibrarySWF) throws InvalidInputException, IOException {
        ExtensionDescriptor descriptor = new ExtensionDescriptor(this.m_extensionDescriptorFile, true);
        SortedMap<String, File> sources = this.getSources();
        if (!sources.containsKey(PATH_CATALOG) || !sources.containsKey(PATH_LIBRARY_SWF)) {
            throw new InvalidInputException("Invalid swc file: " + this.m_swcFile.getCanonicalPath());
        }
        if (Utils.getSWFVersion(mainLibrarySWF) < 10) {
            throw new InvalidInputException("Invalid swc file, SWF verison must be 10 or higher.");
        }
        Map<String, ExtensionDescriptor.Platform> descriptorPlatforms = descriptor.applicationDeployedPlatforms();
        Set<String> descriptorPlatformNames = descriptorPlatforms.keySet();
        LinkedList<String> unexpectedPlatformImplementations = new LinkedList<String>(this.m_implementedPlatformNames);
        unexpectedPlatformImplementations.removeAll(descriptorPlatformNames);
        if (unexpectedPlatformImplementations.size() > 0) {
            throw new InvalidInputException("Unexpected implementation for platform: " + unexpectedPlatformImplementations.getFirst());
        }
        LinkedList<String> missingImplementations = new LinkedList<String>(descriptorPlatformNames);
        missingImplementations.removeAll(this.m_implementedPlatformNames);
        if (missingImplementations.size() > 0) {
            throw new InvalidInputException("Missing implementation for platform: " + missingImplementations.getFirst());
        }
        for (ExtensionDescriptor.Platform platform : descriptorPlatforms.values()) {
            String librarySwfPath = "META-INF/ANE/" + platform.name + "/library.swf";
            if (!sources.containsKey(librarySwfPath)) {
                throw new InvalidInputException("Missing 'library.swf' for platform: " + platform.name);
            }
            if (Utils.getSWFVersion((File)sources.get(librarySwfPath)) < 10) {
                throw new InvalidInputException("Invalid 'library.swf' for platform: " + platform.name + ". SWF version must be " + 10 + " or higher.");
            }
            if (platform.nativeLibrary == null || sources.containsKey("META-INF/ANE/" + platform.name + "/" + platform.nativeLibrary)) continue;
            throw new InvalidInputException("Missing native library implementation '" + platform.nativeLibrary + "' for platform: " + platform.name);
        }
    }

    public void createPackage() throws IOException, GeneralSecurityException {
        if (this.m_unsignedAneFile != null) {
            this.getStream().addANEFile(ANEFile.getZipFile(this.m_unsignedAneFile), false);
        } else {
            File tmpSwcDir = Utils.createTempDirectory(this.getOutput().getAbsoluteFile().getParentFile());
            this.addFileForCleanup(tmpSwcDir);
            try {
                Utils.extractZipFile(this.m_swcFile, tmpSwcDir, "");
            }
            catch (Exception e2) {
                throw new InvalidInputException("Invalid swc file: " + this.m_swcFile.getCanonicalPath());
            }
            this.addSourceFileOrDir(tmpSwcDir, tmpSwcDir);
            if (this.m_validate) {
                this.validate(new File(tmpSwcDir, PATH_LIBRARY_SWF));
            }
            if (this.getOutput() == null) {
                throw new IllegalStateException("output not set");
            }
            this.addSpecialFiles();
            for (String path : this.getSources().keySet()) {
                File file = (File)this.getSources().get(path);
                this.getStream().addFile(file, path, this.m_sign);
            }
        }
        if (this.m_sign) {
            this.getStream().finalizeSig();
        }
        this.getStream().close();
        this.renameOutput();
    }

    public void createIntermediate() throws IOException {
        this.m_sign = false;
        try {
            this.createPackage();
        }
        catch (GeneralSecurityException ex) {
            throw new RuntimeException("certificate exception with signing disabled");
        }
    }

    public void setOutput(File output) throws FileNotFoundException, IOException {
        super.setOutput(output);
        this.initTempFile("ane");
    }

    protected void addSpecialFiles() throws IOException {
        this.getStream().addMimeTypeFile("application/vnd.adobe.air-native-extension-package+zip", this.m_sign);
        this.getStream().addFile(this.m_extensionDescriptorFile, "META-INF/ANE/extension.xml", this.m_sign);
    }

    public void setPrivateKey(PrivateKey key) {
        super.setPrivateKey(key);
        this.setTimestampURL("https://timestamp.geotrust.com/tsa");
    }

    public void setCertificateChain(Certificate[] certchain) throws CertificateException {
        this.validateSigningCertificate(certchain);
        super.setCertificateChain(certchain);
    }

    public void setSWC(File file) {
        this.m_swcFile = file;
    }

    public void setIntermediateFile(File aneiFile) {
        this.m_unsignedAneFile = aneiFile;
    }

    public void setExtensionDescriptor(File file) {
        this.m_extensionDescriptorFile = file;
    }

    public void addExtensionFileOrDir(File file, File root, String platform) {
        this.m_implementedPlatformNames.add(platform);
        this.addMetaFileOrDir(file, root, platform);
    }

    public void addExtensionFileWithPath(File file, String platform, String path) {
        String normalizedPath = Utils.performPlatformUnicodePathNormalization(path);
        if (normalizedPath.startsWith("/") || normalizedPath.length() == 0) {
            throw new IllegalArgumentException("Invalid path '" + path + "' for file " + file.getPath());
        }
        this.m_implementedPlatformNames.add(platform);
        this.addMetaWithPath(file, platform + "/" + normalizedPath);
    }

    protected AIROutputStream getStream() {
        return (AIROutputStream)super.getStream();
    }
}

