/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ExtensionDescriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.validator.DescriptorValidationException;
import com.adobe.air.validator.ExtensionDescriptorValidator25;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ANEFile {
    private File m_file;
    private ExtensionDescriptor m_descriptor;
    private boolean m_isSigned;

    public ANEFile(File file) throws DescriptorValidationException, InvalidInputException, IOException {
        this.m_file = file;
        ZipFile zipFile = ANEFile.getZipFile(file);
        ZipEntry descEntry = zipFile.getEntry("META-INF/ANE/extension.xml");
        this.m_descriptor = new ExtensionDescriptor(zipFile.getInputStream(descEntry), true, file.getCanonicalPath() + " [" + descEntry.getName() + "]");
        this.m_isSigned = zipFile.getEntry("META-INF/signatures.xml") != null;
        zipFile.close();
    }

    public static ZipFile getZipFile(File file) throws InvalidInputException, IOException {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(file);
        }
        catch (Exception e2) {
            throw new InvalidInputException(file.getCanonicalPath() + " is not a valid ANE file.");
        }
        if (zipFile.getEntry("catalog.xml") == null) {
            throw new InvalidInputException(file.getCanonicalPath() + " doesn't contain a catalog.xml file");
        }
        if (zipFile.getEntry("library.swf") == null) {
            throw new InvalidInputException(file.getCanonicalPath() + " doesn't contain a library.swf file");
        }
        if (zipFile.getEntry("META-INF/ANE/extension.xml") == null) {
            throw new InvalidInputException(file.getCanonicalPath() + " doesn't contain a descriptor file: " + "META-INF/ANE/extension.xml");
        }
        return zipFile;
    }

    public ExtensionDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public boolean supportsPlatform(String platform, boolean appBundled, boolean deviceDeployed) {
        ExtensionDescriptor.Platform p2 = this.m_descriptor.platforms().get(platform);
        return p2 != null && (appBundled && p2.deploymentModel.equals(ExtensionDescriptorValidator25.DEPLOYMENT_MODEL_APPLICATION) || deviceDeployed && p2.deploymentModel.equals(ExtensionDescriptorValidator25.DEPLOYMENT_MODEL_DEVICE));
    }

    public File getFile() {
        return this.m_file;
    }

    public String id() {
        return this.m_descriptor.id();
    }

    public boolean isSigned() {
        return this.m_isSigned;
    }

    public ZipEntryIterator getFilesForPlatform(String platform) throws IOException {
        return new ZipEntryIterator(platform);
    }

    public String getNativeLibraryPath(String platform) throws ZipException, IOException {
        String nativeLibrary = this.m_descriptor.getNativeLibrary(platform);
        return nativeLibrary != null ? "META-INF/ANE/" + platform + "/" + nativeLibrary : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZipEntryIterator
    implements Iterator<ZipEntry>,
    Iterable<ZipEntry> {
        private String m_platform;
        private Enumeration<? extends ZipEntry> m_entries;
        private ZipEntry m_next = null;
        private ZipFile m_zipFile;

        private ZipEntryIterator(String platform) throws IOException {
            this.m_platform = platform;
            this.m_zipFile = new ZipFile(ANEFile.this.m_file);
            this.m_entries = this.m_zipFile.entries();
            this.m_next = this._next();
        }

        @Override
        public Iterator<ZipEntry> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.m_next != null;
        }

        @Override
        public ZipEntry next() {
            if (this.m_next != null) {
                ZipEntry result = this.m_next;
                this.m_next = this._next();
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public ZipFile getZipFile() {
            return this.m_zipFile;
        }

        private ZipEntry _next() {
            ZipEntry result = null;
            while (this.m_entries.hasMoreElements() && result == null) {
                ZipEntry entry = this.m_entries.nextElement();
                if (!this.isValidEntry(entry.getName())) continue;
                result = entry;
            }
            return result;
        }

        private boolean isValidEntry(String name) {
            if (name.equals("mimetype") || name.equals("META-INF/signatures.xml")) {
                return false;
            }
            if (this.m_platform.equals("ALL")) {
                return true;
            }
            if (this.m_platform.equals("Android-ARM") && name.equals("META-INF/ANE/" + this.m_platform + "/" + ((ANEFile)ANEFile.this).m_descriptor.platforms().get((Object)this.m_platform).nativeLibrary)) {
                return false;
            }
            return !name.startsWith("META-INF/ANE") || name.startsWith("/" + this.m_platform + "/", "META-INF/ANE".length()) || name.startsWith("/extension.xml", "META-INF/ANE".length());
        }
    }
}

