/*
 * Copyright (C) 2011 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef EventConstructors_h
#define EventConstructors_h

namespace WebCore {

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(Event) \
        FILL_PROPERTY(bubbles) \
        FILL_PROPERTY(cancelable) \
    DICTIONARY_END(Event)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_CUSTOM_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(CustomEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(detail) \
    DICTIONARY_END(CustomEvent)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_PROGRESS_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(ProgressEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(lengthComputable) \
        FILL_PROPERTY(loaded) \
        FILL_PROPERTY(total) \
    DICTIONARY_END(ProgressEvent)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_WEBKIT_ANIMATION_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(WebKitAnimationEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(animationName) \
        FILL_PROPERTY(elapsedTime) \
    DICTIONARY_END(WebKitAnimationEvent)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_HASH_CHANGE_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(HashChangeEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(oldURL) \
        FILL_PROPERTY(newURL) \
    DICTIONARY_END(HashChangeEvent)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_PAGE_TRANSITION_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(PageTransitionEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(persisted) \
    DICTIONARY_END(PageTransitionEvent)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_POP_STATE_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(PopStateEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(state) \
    DICTIONARY_END(PopStateEvent)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_ERROR_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(ErrorEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(message) \
        FILL_PROPERTY(filename) \
        FILL_PROPERTY(lineno) \
    DICTIONARY_END(ErrorEvent)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_CLOSE_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(CloseEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(wasClean) \
        FILL_PROPERTY(code) \
        FILL_PROPERTY(reason) \
    DICTIONARY_END(CloseEvent)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_MESSAGE_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(MessageEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(data) \
        FILL_PROPERTY(origin) \
        FILL_PROPERTY(lastEventId) \
        FILL_PROPERTY(source) \
        FILL_PROPERTY(ports) \
    DICTIONARY_END(MessageEvent)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_WEBKIT_TRANSITION_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(WebKitTransitionEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(propertyName) \
        FILL_PROPERTY(elapsedTime) \
    DICTIONARY_END(WebKitTransitionEvent)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_BEFORE_LOAD_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(BeforeLoadEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(url) \
    DICTIONARY_END(BeforeLoadEvent)

#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_OVERFLOW_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(OverflowEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(orient) \
        FILL_PROPERTY(horizontalOverflow) \
        FILL_PROPERTY(verticalOverflow) \
    DICTIONARY_END(OverflowEvent)

#if ENABLE(VIDEO_TRACK)
#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_TRACK_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    \
    DICTIONARY_START(TrackEvent) \
        FILL_PARENT_PROPERTIES(Event) \
        FILL_PROPERTY(track) \
    DICTIONARY_END(TrackEvent)
#else
#define INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_TRACK_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY)
#endif

#define INSTANTIATE_ALL_EVENT_INITIALIZING_CONSTRUCTORS(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_CUSTOM_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_PROGRESS_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_WEBKIT_ANIMATION_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_HASH_CHANGE_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_PAGE_TRANSITION_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_POP_STATE_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_ERROR_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_CLOSE_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_MESSAGE_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_WEBKIT_TRANSITION_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_BEFORE_LOAD_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_OVERFLOW_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \
    INSTANTIATE_INITIALIZING_CONSTRUCTOR_FOR_TRACK_EVENT(DICTIONARY_START, DICTIONARY_END, FILL_PARENT_PROPERTIES, FILL_PROPERTY) \

} // namespace WebCore

#endif // EventConstructors_h
