//=========================================================================//
//                                                                         //
//  PonyProg - Serial Device Programmer                                    //
//                                                                         //
//  Copyright (C) 1997-2007   Claudio Lanconelli                           //
//                                                                         //
//  http://ponyprog.sourceforge.net                                        //
//                                                                         //
//-------------------------------------------------------------------------//
// $Id: picbus.h,v 1.7 2009/11/16 23:40:43 lancos Exp $
//-------------------------------------------------------------------------//
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public License            //
// as published by the Free Software Foundation; either version2 of        //
// the License, or (at your option) any later version.                     //
//                                                                         //
// This program is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU  General Public License      //
// along with this program (see COPYING);     if not, write to the         //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//                                                                         //
//-------------------------------------------------------------------------//
//=========================================================================//

#ifndef	_PICBUS_H
#define	_PICBUS_H

#include "busio.h"
#include "pgminter.h"

class PicBus : public BusIO
{
 public:		//------------------------------- public
	PicBus(BusInterface *ptr = 0);
	virtual ~PicBus();

	long Read(int addr, uint8_t *data, long length, int page_size = 0);
	long Write(int addr, uint8_t const *data, long length, int page_size = 0);
	
	int Erase(int type = ALL_TYPE);

	int Reset();

	long ReadConfig(uint16_t *data);
	long WriteConfig(uint16_t *data);

	void DisableCodeProtect();

	int CompareSingleWord(uint16_t data1, uint16_t data2, uint16_t mask);
	int CompareMultiWord(uint8_t *data1, uint8_t *data2, long length, int split);

	void SetDelay();

 protected:		//------------------------------- protected

	int SendDataWord(long wo, int wlen = 16);
	long RecDataWord(int wlen = 16);
	int WaitReadyAfterWrite(long timeout = 5000);

	int SendCmdCode(int opcode);
	int SendProgCode(uint16_t data);
	uint16_t RecvProgCode();
	int SendDataCode(uint16_t data);
	uint16_t RecvDataCode();

	void SetMCLR()
		{ busI->SetControlLine(1); }
	void ClearMCLR()
		{ busI->SetControlLine(0); }

	const uint16_t DataMask;
	const uint16_t ProgMask;

	//Command Opcode
	const uint8_t ReadProgCode;
	const uint8_t LoadProgCode;
	const uint8_t ReadDataCode;
	const uint8_t LoadDataCode;
	const uint8_t LoadConfigCode;
	const uint8_t IncAddressCode;
	const uint8_t EraseProgMem;
	const uint8_t EraseDataMem;
	const uint8_t BeginEraseProgCode;
	const uint8_t BeginProgOnlyCode;

 private:		//------------------------------- private

	int SendDataBit(int b);
	int RecDataBit();

	void bitDI(int b)
		{ busI->SetInvDataOut(b); }

	void setDI()
		{ busI->SetInvDataOut(1); }

	void clearDI()
		{ busI->SetInvDataOut(0); }

	void setCLK()
		{ busI->SetClock(1); }

	void clearCLK()
		{ busI->SetClock(0); }

	int getDO() const
		{ return busI->GetDataIn(); }

};

#endif
