//=========================================================================//
//                                                                         //
//  PonyProg - Serial Device Programmer                                    //
//                                                                         //
//  Copyright (C) 1997-2007   Claudio Lanconelli                           //
//                                                                         //
//  http://ponyprog.sourceforge.net                                        //
//                                                                         //
//-------------------------------------------------------------------------//
// $Id: intfbuf.h,v 1.4 2009/11/16 22:29:18 lancos Exp $
//-------------------------------------------------------------------------//
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public License            //
// as published by the Free Software Foundation; either version2 of        //
// the License, or (at your option) any later version.                     //
//                                                                         //
// This program is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU  General Public License      //
// along with this program (see COPYING);     if not, write to the         //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//                                                                         //
//-------------------------------------------------------------------------//
//=========================================================================//

#ifndef _INTELFBUF_H
#define _INTELFBUF_H

// Include standard V files as needed

#include "types.h"
#include "filebuf.h"

class IntelFileBuf : public FileBuf
{
  public:		//---------------------------------------- public

	IntelFileBuf(e2AppWinInfo *wininfo = 0);
	virtual ~IntelFileBuf();

	virtual int Load(int loadtype = ALL_TYPE, long relocation_offset = 0);
	virtual int Save(int savetype = ALL_TYPE, long relocation_offset = 0);

  protected:	//--------------------------------------- protected

  private:		//--------------------------------------- private

	int WriteRecord(FILE *fh, uint8_t *bptr, long curaddr, long recsize, int fmt);
	int WriteAddressRecord(FILE *fh, long curaddr, bool linear_address = false);

	int ScanHex(char **sp, int len, uint32_t &result);
	int ScanHex(char **sp, int len, uint16_t &result);
};
#endif
