//=========================================================================//
//                                                                         //
//  PonyProg - Serial Device Programmer                                    //
//                                                                         //
//  Copyright (C) 1997-2007   Claudio Lanconelli                           //
//                                                                         //
//  http://ponyprog.sourceforge.net                                        //
//                                                                         //
//-------------------------------------------------------------------------//
// $Id: e2cmdw.cpp,v 1.30 2013/05/08 19:29:07 lancos Exp $
//-------------------------------------------------------------------------//
//                                                                         //
// This program is free software; you can redistribute it and/or           //
// modify it under the terms of the GNU  General Public License            //
// as published by the Free Software Foundation; either version2 of        //
// the License, or (at your option) any later version.                     //
//                                                                         //
// This program is distributed in the hope that it will be useful,         //
// but WITHOUT ANY WARRANTY; without even the implied warranty of          //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       //
// General Public License for more details.                                //
//                                                                         //
// You should have received a copy of the GNU  General Public License      //
// along with this program (see COPYING);     if not, write to the         //
// Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. //
//                                                                         //
//-------------------------------------------------------------------------//
//=========================================================================//

//======================================================================
//@V@:Note: The scheleton for this file generated by vgen V1.02
//	e2cmdw.cpp:	Source for e2CmdWindow class
//=======================================================================
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <v/vicon.h>
#include <v/vnotice.h>	// for vNoticeDialog
#include <v/vynreply.h>	// for vYN dialog
#include <v/vreply.h>
#include <v/vfilesel.h>
#include <v/vkeys.h>	// to map keys
#include <v/vprintdc.h>
#include <v/vprinter.h>

#include <v/vcolor.h>
#include <v/vos.h>

#ifdef vDEBUG
#include <v/vdebug.h>
#endif

#include "e2app.h"
#include "e2awinfo.h"
#include "e2cmdw.h"		// our header
#include "infomdlg.h"
#include "aboutmdlg.h"
#include "filldlg.h"
#include "retrymdlg.h"
#include "fusemdlg.h"
#include "progoption.h"
#include "sernumdlg.h"

//#include "socksrv.h"

//	Start defines for the main window with 100
#include "cmdenum.h"
#include "string_table.h"

#ifdef	WIN32
# define	DEF_TITLE	STR_NONAME
# define	DEF_FNAME	STR_NONAME
# define	STR_TITLE	" "
#else
# define	DEF_TITLE	APPNAME " - " STR_NONAME
# define	DEF_FNAME	STR_NONAME
# define	STR_TITLE	APPNAME " - "
#endif

#ifdef	WIN32
#  ifdef	__BORLANDC__
#    define	strcasecmp stricmp
#  else // _MICROSOFT_ VC++
#    define strcasecmp	_stricmp
#    define snprintf	_snprintf
#  endif
#endif

//@V@:BeginPulldownMenu FileMenu
static vMenu FileMenu[] =
{
	{STR_NEWWIN, M_New, isSens, notChk, noKeyLbl, noKey, noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{STR_OPEN, M_Open, isSens, notChk, noKeyLbl, noKey, noSub},
	{STR_OPENFLASH, m_OpenProg, isSens, notChk, noKeyLbl, noKey, noSub},
	{STR_OPENDATA, m_OpenData, isSens, notChk, noKeyLbl, noKey, noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{STR_SAVE, M_Save, isSens, notChk, noKeyLbl, noKey, noSub},
	{STR_SAVEAS, M_SaveAs, isSens, notChk, noKeyLbl, noKey, noSub},
	{STR_SAVEFLASH, m_SaveProg, isSens, notChk, noKeyLbl, noKey, noSub},
	{STR_SAVEDATA, m_SaveData, isSens, notChk, noKeyLbl, noKey, noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{STR_RELOAD, m_Reload, isSens, notChk, "Ctrl-L", 'L'-'@', noSub},
	{STR_PRINT, M_Print, isSens, notChk, noKeyLbl, noKey, noSub},
#ifdef	vDEBUG
	{"&Debug", M_SetDebug, isSens, notChk, noKeyLbl, noKey, noSub},
#endif
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{STR_CLOSE, M_Close, isSens, notChk, noKeyLbl, noKey, noSub},
	{STR_EXIT, M_Exit, isSens, notChk, noKeyLbl, noKey, noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{" ", m_File1, isSens, notChk, noKeyLbl, noKey, noSub},
	{" ", m_File2, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu EditMenu
static vMenu EditMenu[] =
{
//	{"Cut  ", M_Cut, isSens, notChk, "Ctrl-X", 'X'-'@', noSub},
//	{"Copy ", M_Copy, isSens, notChk, "Ctrl-C", 'C'-'@', noSub},
//	{"Paste", M_Paste, isSens, notChk, "Ctrl-V", 'V'-'@', noSub},
//	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{STR_EDITNOTE, m_Note, isSens, notChk, noKeyLbl, noKey, noSub},
//	{STR_SECBITS,m_SpecBits,isSens,notChk,noKeyLbl,noKey,noSub},
	{"-", M_Line, notSens, notChk, noKeyLbl, noKey, noSub},
	{STR_EDITBUFENA, m_EditBuf, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};
//@V@:EndPulldownMenu

struct Menu2Type {
	int menu_id;
	long type;
	int cbx1_id;
	int cbx2_id;
};

static Menu2Type index_menu_type[] = {
	//AutoTag
	//List of menu item to device type
	{m_24XX, E2400},
	{m_2401a, E2401_A},
	{m_2401b, E2401_B},
	{m_2402, E2402},
	{m_2404, E2404},
	{m_2408, E2408},
	{m_2416, E2416},
	{m_24325, E24325},
	{m_24645, E24645},

	{m_24E16, E24E16},
	{m_2432, E2432},
	{m_2464, E2464},
	{m_24128, E24128},
	{m_24256, E24256},
	{m_24512, E24512},

//	{m_at90sXXXX, AT90S0000},
	{m_at90s1200, AT90S1200},
	{m_at90s2313, AT90S2313},
	{m_at90s4414, AT90S4414},
	{m_at90s8515, AT90S8515},
	{m_atmega8515, ATmega8515},
	{m_atmega8535, ATmega8535},
	{m_atmega603, ATmega603},
	{m_atmega103, ATmega103},
	{m_atmega8, ATmega8},
	{m_atmega16, ATmega16},
	{m_atmega128, ATmega128},
	{m_atmega64, ATmega64},
	{m_atmega161, ATmega161},
	{m_atmega162, ATmega162},
	{m_atmega163, ATmega163},
	{m_atmega169, ATmega169},
	{m_atmega32, ATmega32},
	{m_atmega323, ATmega323},
	{m_at90s2323, AT90S2323},
	{m_at90s2333, AT90S2333},
	{m_at90s2343, AT90S2343},
	{m_at90s4433, AT90S4433},
	{m_at90s4434, AT90S4434},
	{m_at90s8534, AT90S8534},
	{m_at90s8535, AT90S8535},
//	{m_attiny10, ATtiny10},
//	{m_attiny11, ATtiny11},
	{m_attiny12, ATtiny12},
	{m_attiny15, ATtiny15},
	{m_attiny22, ATtiny22},
	{m_attiny26, ATtiny26},
//	{m_attiny28, ATtiny28},
	{m_attiny2313, ATtiny2313},
	{m_attiny13, ATtiny13},
	{m_attiny25, ATtiny25},
	{m_attiny45, ATtiny45},
	{m_attiny85, ATtiny85},
	{m_attiny261, ATtiny261},
	{m_attiny461, ATtiny461},
	{m_attiny861, ATtiny861},
	{m_atmega48, ATmega48},
	{m_atmega88, ATmega88},
	{m_atmega168, ATmega168},
	{m_atmega164, ATmega164},
	{m_atmega324, ATmega324},
	{m_atmega644, ATmega644},
	{m_atmega640, ATmega640},
	{m_atmega1280, ATmega1280},
	{m_atmega1281, ATmega1281},
	{m_atmega2560, ATmega2560},
	{m_atmega2561, ATmega2561},
	{m_at90can32, AT90CAN32},
	{m_at90can64, AT90CAN64},
	{m_at90can128, AT90CAN128},

	{m_at89s8252, AT89S8252},
	{m_at89s8253, AT89S8253},
	{m_at89s51, AT89S51},
	{m_at89s52, AT89S52},
	{m_at89s53, AT89S53},

	{m_9306, E9306},
	{m_9346, E9346},
	{m_9356, E9356},
	{m_9357, E9357},
	{m_9366, E9366},
	{m_9376, E9376},
	{m_9386, E9386},

	{m_9306_8, E9306_8},
	{m_9346_8, E9346_8},
	{m_9356_8, E9356_8},
	{m_9357_8, E9357_8},
	{m_9366_8, E9366_8},
	{m_9376_8, E9376_8},
	{m_9386_8, E9386_8},

	{m_pic1683, PIC1683},
	{m_pic1684, PIC1684},
	{m_pic1684A, PIC1684A},
	{m_pic16870, PIC16870},
	{m_pic16871, PIC16871},
	{m_pic16872, PIC16872},

	{m_pic16873, PIC16873},
	{m_pic16874, PIC16874},
	{m_pic16876, PIC16876},
	{m_pic16877, PIC16877},

	{m_pic16873A, PIC16873A},
	{m_pic16874A, PIC16874A},
	{m_pic16876A, PIC16876A},
	{m_pic16877A, PIC16877A},

	{m_pic16627, PIC16627},
	{m_pic16628, PIC16628},

	{m_pic12508, PIC12508},
	{m_pic12509, PIC12509},
	{m_pic12508A, PIC12508A},
	{m_pic12509A, PIC12509A},
	{m_pic12518, PIC12E518},
	{m_pic12519, PIC12E519},

	{m_pic12671, PIC12671},
	{m_pic12672, PIC12672},
	{m_pic12673, PIC12673},
	{m_pic12674, PIC12674},

	{m_25010, E25010},
	{m_25020, E25020},
	{m_25040, E25040},
	{m_25080, E25080},
	{m_25160, E25160},
	{m_25320, E25320},
	{m_25640, E25640},
	{m_25128, E25128},
	{m_25256, E25256},

	{m_mda2062, EMDA2062},
	{m_nvm3060, ENVM3060},

	{m_sde2506, E2506},

	{m_at1765, AT1765},
	{m_at17128, AT17128},
	{m_at17256, AT17256},
	{m_at17512, AT17512},
	{m_at17010, AT17010},

	{m_s2430, S24H30},
	{m_x2444, X24C44},
	{m_x2445, X24C45},

	{0,0}
};

//The order of items in these list corresponds to menu item list at video
// only the labeld is replaced run-time with correspondign device label

//AutoTag
//List of vmenu items (device type)

static vMenu i2c8Menu[] = {
	{"", m_24XX, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_2401a, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_2401b, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_2402, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_2404, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_2408, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_2416, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_24325, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_24645, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu i2c16Menu[] = {
	{"", m_24E16, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_2432, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_2464, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_24128, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_24256, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_24512, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu at17Menu[] = {
	{"", m_at1765, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at17128, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at17256, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at17512, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at17010, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu spiMenu[] = {
	{"", m_25010, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_25020, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_25040, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_25080, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_25160, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_25320, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_25640, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_25128, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_25256, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu microwireMenu[] = {
	{"", m_9306, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9346, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9356, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9357, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9366, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9376, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9386, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu microwire8Menu[] = {
	{"", m_9306_8, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9346_8, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9356_8, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9357_8, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9366_8, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9376_8, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_9386_8, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu avrMenu[] = {
//	{"", m_at90sXXXX, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90s1200, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90s2313, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90s2323, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90s2333, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90s2343, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90s4414, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90s4433, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90s4434, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90s8515, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90s8534, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90s8535, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90can32, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90can64, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at90can128, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny12, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny13, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny15, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny22, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny2313, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny25, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny45, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny85, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny26, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny261, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny461, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_attiny861, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega603, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega103, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega48, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega8, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega8515, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega8535, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega88, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega16, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega161, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega162, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega163, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega164, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega168, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega169, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega32, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega323, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega324, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega64, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega640, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega644, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega128, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega1280, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega1281, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega2560, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_atmega2561, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu at89sMenu[] = {
	{"", m_at89s8252, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at89s8253, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at89s51, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at89s52, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_at89s53, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};


static vMenu pic16Menu[] = {
	{"", m_pic1683, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic1684, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic1684A, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16870, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16871, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16872, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16873, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16874, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16876, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16877, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16873A, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16874A, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16876A, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16877A, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16627, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic16628, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu pic12Menu[] = {
	{"", m_pic12508, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic12509, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic12508A, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic12509A, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic12518, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic12519, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic12671, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic12672, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic12673, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_pic12674, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu imbusMenu[] = {
	{"", m_mda2062, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_nvm3060, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu sde25xxMenu[] = {
	{"", m_sde2506, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu x2444_Menu[] = {
	{"", m_s2430, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_x2444, isSens, notChk, noKeyLbl, noKey, noSub},
	{"", m_x2445, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};

static vMenu DeviceMenu[] =
{
	{"I2C Bus 8bit eeprom", m_I2Cbus8, isSens, notUsed, notUsed, noKey, &i2c8Menu[0]},
	{"I2C Bus 16bit eeprom", m_I2Cbus16, isSens, notUsed, notUsed, noKey, &i2c16Menu[0]},
	{"I2C Bus AT17 eeprom", m_at17xx, isSens, notUsed, notUsed, noKey, &at17Menu[0]},
	{"MicroWire16 eeprom", m_MicroWire, isSens, notUsed, notUsed, noKey, &microwireMenu[0]},
	{"MicroWire8 eeprom", m_MicroWire, isSens, notUsed, notUsed, noKey, &microwire8Menu[0]},
	{"SPI eeprom", m_SPI, isSens, notUsed, notUsed, noKey, &spiMenu[0]},
	{"AVR micro", m_AVR, isSens, notUsed, notUsed, noKey, &avrMenu[0]},
	{"AT89S micro", m_at89s, isSens, notUsed, notUsed, noKey, &at89sMenu[0]},
	{"PIC 16 micro", m_PIC16, isSens, notUsed, notUsed, noKey, &pic16Menu[0]},
	{"PIC 12 micro", m_PIC12, isSens, notUsed, notUsed, noKey, &pic12Menu[0]},
	{"ImBus eeprom", m_imbus, isSens, notUsed, notUsed, noKey, &imbusMenu[0]},
	{"SDE2506 eeprom", m_sde25xx, isSens, notUsed, notUsed, noKey, &sde25xxMenu[0]},
	{"X2444 eeprom", m_x2444xx, isSens, notUsed, notUsed, noKey, &x2444_Menu[0]},
	{NULL}
};

static vMenu CommandMenu[] =
{
	{STR_READALL, m_Read, isSens, notChk, "Ctrl-R", 'R'-'@', noSub},
	{STR_READPROG,m_ReadProg,isSens,notChk,noKeyLbl,noKey,noSub},
	{STR_READDATA,m_ReadData,isSens,notChk,noKeyLbl,noKey,noSub},
//	{STR_READSECBITS,m_ReadSecurity,isSens,notChk,"Ctrl-B", 'B'-'@',noSub},
	{"-",M_Line,notSens,notChk,noKeyLbl,noKey,noSub},
	{STR_WRITEALL, m_Write,isSens, notChk, "Ctrl-W", 'W'-'@', noSub},
	{STR_WRITEPROG,m_WriteProg,isSens,notChk,noKeyLbl,noKey,noSub},
	{STR_WRITEDATA,m_WriteData,isSens,notChk,noKeyLbl,noKey,noSub},
//	{STR_WRITESECBITS,m_WriteSecurity,isSens,notChk,"Ctrl-S",'S'-'@',noSub},
	{"-",M_Line,notSens,notChk,noKeyLbl,noKey,noSub},
	{STR_VERIFYALL,m_Verify,isSens,notChk, "Ctrl-V", 'V'-'@', noSub},
	{STR_VERIFYPROG,m_VerifyProg,isSens,notChk,noKeyLbl,noKey,noSub},
	{STR_VERIFYDATA,m_VerifyData,isSens,notChk,noKeyLbl,noKey,noSub},
	{"-",M_Line,notSens,notChk,noKeyLbl,noKey,noSub},
	{STR_SECBITS,m_SpecBits,isSens,notChk,"Ctrl-S",'S'-'@',noSub},
	{STR_ERASE, m_Erase,isSens,notChk,"Ctrl-E",'E'-'@', noSub},
	{STR_RESET,m_Reset,isSens, notChk, "Ctrl-T", 'T'-'@', noSub},
	{"-",M_Line,notSens,notChk,noKeyLbl,noKey,noSub},
	{STR_PROGRAM,m_Program,isSens,notChk,"Ctrl-P",'P'-'@',noSub},
	{STR_PROGOPTION,m_ProgOptions,isSens,notChk,noKeyLbl,noKey,noSub},
	{"-",M_Line,notSens,notChk,noKeyLbl,noKey,noSub},
	{STR_READOSCCALIB,m_OscCalibRead,isSens,notChk,"Ctrl-O",'O'-'@',noSub},
	{STR_OSCCALIBOPTION,m_OscCalibConfig,isSens,notChk,noKeyLbl,noKey,noSub},
	{NULL}
};

/**
static vMenu RunScrMenu[] =
{
	{"Pippo", m_RunFile, isSens, notChk, "Ctrl-I", 'I'-'@', noSub},
	{NULL}
};
**/

static vMenu ScriptMenu[] =
{
//	{STR_EDITSCRIPT,m_EditScript,isSens,notChk,noKeyLbl,noKey,noSub},
	{STR_LOADSCR, m_LoadScript, isSens, notChk, noKeyLbl, noKey, noSub},
//	{STR_AUTOLOADSCR, m_AutoLoadScript, isSens, notChk, noKeyLbl, noKey, noSub},
	{"-",M_Line,notSens,notChk,noKeyLbl,noKey,noSub},
	{STR_RUNSCR " ", m_RunFile, notSens, notChk, "Ctrl-I", 'I'-'@', noSub},
	{NULL}
};

//@V@:BeginPulldownMenu Options
static vMenu SetupMenu[] =
{
	{STR_INTERFSETUP, m_InterfSetup, isSens, notChk, noKeyLbl, noKey, noSub},
	{STR_CALIBRATION, m_Calibration, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};
//@V@:EndPulldownMenu

//@V@:BeginPulldownMenu Options
static vMenu UtilityMenu[] =
{
	{STR_CLEARBUF,m_ClearBuf,isSens,notChk,"Ctrl-C",'C'-'@',noSub},
	{STR_FILLBUF,m_FillBuf,isSens,notChk,noKeyLbl,noKey,noSub},
	{STR_DOUBLEBANK,m_DoubleSize,isSens,notChk,noKeyLbl,noKey,noSub},
	{STR_BYTESWAP,m_ByteSwap,isSens,notChk,noKeyLbl,noKey,noSub},
	{STR_DOWNSERNUM,m_SetSerialNum,isSens,notChk,"Ctrl-N",'N'-'@',noSub},
	{"-",M_Line,notSens,notChk,noKeyLbl,noKey,noSub},
	{STR_SERNUMCONF,m_SerialNumConfig, isSens, notChk, noKeyLbl, noKey, noSub},

	{NULL}
};
//@V@:EndPulldownMenu

/**
static vMenu OptionsMenu[] =
{
	{STR_MENULOG, m_Log, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};
**/

//@V@:BeginPulldownMenu Help
static vMenu Help[] =
{
	{STR_MENUHELP, m_HIndex, isSens, notChk, noKeyLbl, noKey, noSub},
	{"-",M_Line,notSens,notChk,noKeyLbl,noKey,noSub},
	{STR_MENUABOUT, m_About, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
};
//@V@:EndPulldownMenu

//@V@:BeginMenu StandardMenu
static vMenu StandardMenu[] =
{
	{STR_MENUFILE, M_File, isSens, notUsed, notUsed, noKey, &FileMenu[0]},
	{STR_MENUEDIT, M_Edit, notSens, notUsed, notUsed, noKey, &EditMenu[0]},
	{STR_MENUDEVICE, m_Device, isSens, notUsed, notUsed, noKey, &DeviceMenu[0]},
	{STR_MENUCMD, m_Command, isSens, notUsed, notUsed, noKey, &CommandMenu[0]},
	{STR_MENUSCRIPT, m_Script, isSens, notUsed, notUsed, noKey, &ScriptMenu[0]},
	{STR_MENUUTIL, m_Utility, isSens, notUsed, notUsed, noKey, &UtilityMenu[0]},
	{STR_MENUSETUP, m_Setup, isSens, notUsed, notUsed, noKey, &SetupMenu[0]},
//	{STR_MENUOPTIONS, m_Options, isSens, notUsed, notUsed, noKey, &OptionsMenu[0]},
	{STR_MENUQMARK, m_Help, isSens, notUsed, notUsed, noKey, &Help[0]},
	{NULL}
};
//@V@:EndMenu

//@V@:BeginIcons
# include "icons/print20x20.vbm"
	static vIcon printI(&print20x20_bits[0],print20x20_height,print20x20_width,print20x20_depth);

# include "icons/open20x20.vbm"
	static vIcon openI(&open20x20_bits[0],open20x20_height,open20x20_width,open20x20_depth);
# include "icons/open_eep20x20.vbm"
	static vIcon openeepI(&open_eep20x20_bits[0],open_eep20x20_height,open_eep20x20_width,open_eep20x20_depth);
# include "icons/open_flash20x20.vbm"
	static vIcon openflashI(&open_flash20x20_bits[0],open_flash20x20_height,open_flash20x20_width,open_flash20x20_depth);

# include "icons/save20x20.vbm"
	static vIcon saveI(&save20x20_bits[0],save20x20_height,save20x20_width,save20x20_depth);
# include "icons/save_eep20x20.vbm"
	static vIcon saveeepI(&save_eep20x20_bits[0],save_eep20x20_height,save_eep20x20_width,save_eep20x20_depth);
# include "icons/save_flash20x20.vbm"
	static vIcon saveflashI(&save_flash20x20_bits[0],save_flash20x20_height,save_flash20x20_width,save_flash20x20_depth);

# include "icons/rd_all20x20.vbm"
	static vIcon readI(&rd_all20x20_bits[0],rd_all20x20_height,rd_all20x20_width,rd_all20x20_depth);
# include "icons/rd_eep20x20.vbm"
	static vIcon readeepI(&rd_eep20x20_bits[0],rd_eep20x20_height,rd_eep20x20_width,rd_eep20x20_depth);
# include "icons/rd_flash20x20.vbm"
	static vIcon readflashI(&rd_flash20x20_bits[0],rd_flash20x20_height,rd_flash20x20_width,rd_flash20x20_depth);

# include "icons/wr_all20x20.vbm"
	static vIcon writeI(&wr_all20x20_bits[0],wr_all20x20_height,wr_all20x20_width,wr_all20x20_depth);
# include "icons/wr_eep20x20.vbm"
	static vIcon writeeepI(&wr_eep20x20_bits[0],wr_eep20x20_height,wr_eep20x20_width,wr_eep20x20_depth);
# include "icons/wr_flash20x20.vbm"
	static vIcon writeflashI(&wr_flash20x20_bits[0],wr_flash20x20_height,wr_flash20x20_width,wr_flash20x20_depth);

# include "icons/erase20x20.vbm"
	static vIcon eraseI(&erase20x20_bits[0],erase20x20_height,erase20x20_width,erase20x20_depth);
# include "icons/help20x20.vbm"
	static vIcon helpI(&help20x20_bits[0],help20x20_height,help20x20_width,help20x20_depth);
# include "icons/lock20x20.vbm"
	static vIcon lockI(&lock20x20_bits[0],lock20x20_height,lock20x20_width,lock20x20_depth);
# include "icons/reload20x20.vbm"
	static vIcon reloadI(&reload20x20_bits[0],reload20x20_height,reload20x20_width,reload20x20_depth);

# include "icons/new20x20.vbm"
	static vIcon newI(&new20x20_bits[0],new20x20_height,new20x20_width,new20x20_depth);
# include "icons/script20x20.vbm"
	static vIcon scriptI(&script20x20_bits[0],script20x20_height,script20x20_width,script20x20_depth);
# include "icons/program20x20.vbm"
	static vIcon programI(&program20x20_bits[0],program20x20_height,program20x20_width,program20x20_depth);
# include "icons/sernum20x20.vbm"
	static vIcon sernumI(&sernum20x20_bits[0],sernum20x20_height,sernum20x20_width,sernum20x20_depth);
# include "icons/chip20x20.vbm"
	static vIcon chipI(&chip20x20_bits[0],chip20x20_height,chip20x20_width,chip20x20_depth);
# include "icons/setup20x20.vbm"
	static vIcon setupI(&setup20x20_bits[0],setup20x20_height,setup20x20_width,setup20x20_depth);
# include "icons/edit20x20.vbm"
	static vIcon editI(&edit20x20_bits[0],edit20x20_height,edit20x20_width,edit20x20_depth);
//@V@:EndIcons

#define COMBOLIST_SIZE	128

static char* comboList1[COMBOLIST_SIZE];

//this determines only the size of the comboBox, the content will be initialized
//  within PostInit()
static char* comboList2[COMBOLIST_SIZE] =
  {
    "123456789012345",   // The first item in the list
    0            // 0 terminates the list
  };


//@V@:BeginCmdPane ToolBar
static CommandObject ToolBar[] =
{
	{C_Frame,frmToolBar,0,"",NoList,CA_None,isSens,NoFrame,0,0},

	{C_IconButton,icbNew,0,"New",&newI,CA_None,isSens,frmToolBar,0,0, 0,STR_TTNEWWIN},

	{C_Blank,blkBlank1,0," ",NoList,CA_None,isSens,frmToolBar,icbNew,0},

	{C_IconButton,icbOpen,0,"Open",&openI,CA_None,isSens,frmToolBar,blkBlank1,0, 0,STR_TTOPENFILE},
	{C_IconButton,icbOpenFlash,0,"Open Flash",&openflashI,CA_None,isSens,frmToolBar,icbOpen,0, 0,STR_TTOPENPROG},
	{C_IconButton,icbOpenEep,0,"Open Eep",&openeepI,CA_None,isSens,frmToolBar,icbOpenFlash,0, 0,STR_TTOPENDATA},

	{C_Blank,blkBlank2,0," ",NoList,CA_None,isSens,frmToolBar,icbOpenEep,0},

	{C_IconButton,icbSave,0,"Save",&saveI,CA_None,isSens,frmToolBar,blkBlank2,0, 0,STR_TTSAVEFILE},
	{C_IconButton,icbSaveFlash,0,"Save Flash",&saveflashI,CA_None,isSens,frmToolBar,icbSave,0, 0,STR_TTSAVEPROG},
	{C_IconButton,icbSaveEep,0,"Save Eep",&saveeepI,CA_None,isSens,frmToolBar,icbSaveFlash,0, 0,STR_TTSAVEDATA},

	{C_Blank,blkBlank3,0," ",NoList,CA_None,isSens,frmToolBar,icbSaveEep,0},

	{C_IconButton,icbReload,0,"Reload",&reloadI,CA_None,isSens,frmToolBar,blkBlank3,0, 0,STR_TTRELOAD},
	{C_IconButton,icbScript,0,"Script",&scriptI,CA_None,isSens,frmToolBar,icbReload,0, 0,STR_TTSCRIPT},
	{C_IconButton,icbPrint,0,"Print",&printI,CA_None,isSens,frmToolBar,icbScript,0, 0,STR_TTPRINT},
	{C_IconButton,icbSetup,0,"Setup",&setupI,CA_None,isSens,frmToolBar,icbPrint,0, 0,STR_TTSETUP},
	{C_IconButton,icbHelp,0,"Help",&helpI,CA_None,isSens,frmToolBar,icbSetup,0, 0,STR_ABOUT " " APPNAME},

	{C_Frame,frmToolBar2,0,"",NoList,CA_None,isSens,NoFrame,0,0},
//	{C_Label, lblEEPType,0,"   " STR_MSGDEVTYPE,NoList,CA_None,isSens,frmToolBar2,0,0},
	{C_Icon,icoChip,0,STR_MSGDEVTYPE,&chipI,CA_None,isSens,frmToolBar2,0,0},

	{C_ComboBox,cbxEEPType,0,"Chip Type",comboList1,CA_None,isSens,frmToolBar2,icoChip,0, 0,STR_TTSELFAMILY},
//	{C_Label, lblEEPSubType,0," ",NoList,CA_None,isSens,frmToolBar2,cbxEEPType,0},
	{C_ComboBox,cbxEEPSubType,0,"Chip SubType",comboList2,CA_None,isSens,frmToolBar2,cbxEEPType,0, 0,STR_TTSELTYPE},

//	{C_Label, lblLegend,0,"Legend",NoList,CA_NoBorder,isSens,NoFrame,0,0, 0, "Program Memory = Blue;  Data Memory = Green"},

	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
};
//@V@:EndCmdPane

//@V@:BeginCmdPane ToolBar2
static CommandObject ToolBar2[] =
{
	{C_Frame,frmToolBar3,0,"",NoList,CA_None,isSens,NoFrame,0,0},

	{C_IconButton,icbRead,0,"Read All",&readI,CA_None,isSens,frmToolBar3,0,0,  0,STR_TTREADALL},
	{C_IconButton,icbReadFlash,0,"Read Flash",&readflashI,CA_None,isSens,frmToolBar3,icbRead,0,  0,STR_TTREADPROG},
	{C_IconButton,icbReadEep,0,"Read Eep",&readeepI,CA_None,isSens,frmToolBar3,icbReadFlash,0,  0,STR_TTREADDATA},

	{C_Blank,blkBlank2,0," ",NoList,CA_None,isSens,frmToolBar3,icbReadEep,0},

	{C_IconButton,icbWrite,0,"Write",&writeI,CA_None,isSens,frmToolBar3,blkBlank2,0, 0,STR_TTWRITEALL},
	{C_IconButton,icbWriteFlash,0,"Write Flash",&writeflashI,CA_None,isSens,frmToolBar3,icbWrite, 0, 0,STR_TTWRITEPROG},
	{C_IconButton,icbWriteEep,0,"Write Eep",&writeeepI,CA_None,isSens,frmToolBar3,icbWriteFlash,0, 0,STR_TTWRITEDATA},

	{C_Blank,blkBlank3,0," ",NoList,CA_None,isSens,frmToolBar3,icbWriteEep,0},

	{C_IconButton,icbErase,0,"Erase",&eraseI,CA_None,isSens,frmToolBar3,blkBlank3,0, 0, STR_TTERASE},
	{C_IconButton,icbLock,0,"Lock",&lockI,CA_None,isSens,frmToolBar3,icbErase,0, 0, STR_TTSECBITS},
	{C_IconButton,icbSernum,0,"Serial Number",&sernumI,CA_None,isSens,frmToolBar3,icbLock,0, 0, STR_MSGSERNUM},
	{C_IconButton,icbProgram,0,"Program",&programI,CA_None,isSens,frmToolBar3,icbSernum,0, 0,STR_TTPROGRAM},

	{C_Frame,frmToolBar4,0,"",NoList,CA_None,isSens,NoFrame,0,0},

	{C_IconButton,icbEdit,0,"Edit Note",&editI,CA_None,isSens,frmToolBar4,0,0, 0,STR_TTEDITNOTE},
	{C_Text,txtComment,0,"",(void *)"X                                                                 ",CA_None,isSens,frmToolBar4,icbEdit,0, 0,STR_MSGNOTE},
#ifndef	_WINDOWS
	//Workaround for X11 to allocate space for C_Text
	{C_Label,lblComment,0,STR_BTNNOTE "X                                                                 ",NoList,CA_Hidden,isSens,frmToolBar4,icbEdit,0},
#endif
	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
};
//@V@:EndCmdPane

#define	STATUSBAR_FORM	"    Size     0 Bytes     CRC  0000h      "
#define	STATUSBAR_PRINT	"    Size %5ld Bytes     CRC  %04Xh     %c"

//@V@:BeginStatPane StatBar
static vStatus StatBar[] =
{
	{APPNAME "   ", lblTestStat, CA_NoBorder, isSens, 0},
	{"                           ", lblStringID, CA_NoBorder, isSens, 0},
	{STATUSBAR_FORM, lblEEPInfo, CA_NoBorder, isSens, 0},

	{0,0,0,0,0}
};
//@V@:EndStatPane


//==================>>> e2CmdWindow::About <<<=======================
void e2CmdWindow::About()
{
/**
	char msg[256];
	vNoticeDialog note(this);

	char volname[32];
	char fsname[64];
	uint32_t volsn, volmaxlen, volfsflag;
	if (
		GetVolumeInformation(
			"C:\\",
			volname, 32,
			&volsn,
			&volmaxlen,
			&volfsflag,
			fsname, 64
			)
		)
	{
		sprintf(msg, "%s\n%lx\n%lu\n%02lXh\n%s\n",
			volname, volsn, volmaxlen, volfsflag, fsname);
		note.Notice(msg);
	}
**/
	AboutModalDialog about(this,STR_ABOUT " " APPNAME);

	PlaySoundMsg(THEAPP->GetSoundEnabled());

	if ( about.AboutAction("") == 2 )
	{
		CmdHelp();
	}
}


DialogCmd Notes[] =
{
#ifdef	_LINUX_
	{C_Label,lblMainMsg,0,"X",NoList,CA_MainMsg,isSens,NoFrame,0,0},
#else
	{C_Blank,lblMainMsg,0," ",NoList,CA_None,isSens,NoFrame,0,0},
#endif

	{C_Label, lblStrID,0,STR_MSGCHIPID,NoList,CA_None,isSens,NoFrame,0,lblMainMsg},
	{C_TextIn,txiStrID,0,"",NoList,CA_None,isSens,NoFrame,lblStrID,lblMainMsg,32},

	{C_Label, lblCommnt,0,STR_MSGNOTE,NoList,CA_None,isSens,NoFrame,0,lblStrID},
	{C_TextIn,txiCommnt,0,"",NoList,CA_None,isSens,NoFrame,lblCommnt,lblStrID,80},

	{C_Button, M_Cancel, 0,STR_BTNCANC,	NoList,CA_None, isSens,NoFrame,0, lblCommnt},
	{C_Button, M_OK, 0,STR_BTNOK, NoList, CA_DefaultButton, isSens, NoFrame, M_Cancel, lblCommnt},

	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
};


//====================>>> e2CmdWindow::e2CmdWindow <<<====================
e2CmdWindow::e2CmdWindow(char* name, int width, int height) :
		vCmdWindow(name, width, height),
		awip(0),
		editbuf_enabled(0),
		verbose(verboseAll)
{
	UserDebug1(Constructor,"e2CmdWindow::e2CmdWindow(%s) Constructor\n",name)

	CbxMenuInit();

	// The Menu Bar
	e2Menu = new vMenuPane(StandardMenu);
	AddPane(e2Menu);

	// The Command Pane
	e2CmdPane = new vCommandPane(ToolBar);
	e2CmdPane2 = new vCommandPane(ToolBar2);
#ifndef	_LINUX_
	AddPane(e2CmdPane2);
	AddPane(e2CmdPane);
#else
	AddPane(e2CmdPane);
	AddPane(e2CmdPane2);
#endif

	// The Canvas
	e2Canvas = new e2TextCanvasPane(this);
	AddPane(e2Canvas);

	// The Status Bar
	e2Status = new vStatusPane(StatBar);
	AddPane(e2Status);

//	_timer = new e2Timer(this);		// create timer
//	_timer->TimerSet(1000);		// 1 second intervals

	// Associated dialogs
	e2Prg = new e2ProgressDialog(this);

	// Show Window
#ifdef WIN32	// fill out client area (no useful reason not to do so) - heha 130406
	::ShowWindow(winHwnd(),SW_MAXIMIZE);
#else
	ShowWindow();
#endif

	type_index = -1;
	//Initialize Type controls in Tool Bars
//	UpdateChipType( GetE2PPriType(THEAPP->GetLastDevType()), GetE2PSubType(THEAPP->GetLastDevType()) );
	UpdateMenuType( THEAPP->GetLastDevType() );

	if (editbuf_enabled)
		e2Canvas->ShowTextCursor();
	else
		e2Canvas->HideTextCursor();

	first_line = 0;
	curIndex = 0;
}

//void e2CmdWindow::SetSubType()
//{
//}

//====================>>> e2CmdWindow::~e2CmdWindow <<<====================
e2CmdWindow::~e2CmdWindow()
{
    UserDebug(Destructor,"e2CmdWindow::~e2CmdWindow() destructor\n")

    // Now put a delete for each new in the constructor.

	delete e2Menu;
	delete e2Canvas;
	delete e2CmdPane;
	delete e2CmdPane2;
    delete e2Status;
//	_timer->TimerStop();	// end it
//	delete _timer;			// free it
//	delete e2Dlg;
	delete e2Prg;
}

//====================>>> e2CmdWindow::KeyIn <<<====================
void e2CmdWindow::KeyIn(vKey keysym, unsigned int shift)
{
	switch (keysym)
	{
	case vk_Up:
	  {
		PrevLine();
		break;
	  }
	case vk_Down:
	  {
		NextLine();
		break;
	  }
	case vk_Page_Up:
	  {
		PrevPage();
		break;
	  }
	case vk_Page_Down:
	  {
		NextPage();
		break;
	  }
	case vk_Home:
	  {
		FirstPage();
		break;
	  }
	case vk_End:
	  {
		LastPage();
		break;
	  }
	case vk_Return:
	  {
		CharEdit();
		break;
	  }
//	case vk_Left:
//	case vk_Right:
	default:
	  {
		vCmdWindow::KeyIn(keysym, shift);
		break;
	  }
	}
}


int e2CmdWindow::OnError(int err_no, char const *msgerr)
{
	int rv = 0;
	char msg[MAXMSG];
	vNoticeDialog note(this);

	switch(err_no)
	{
	case 0:
		strncpy(msg, STR_DEVNOTRESP, MAXMSG);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	case BADPARAM:
	{
		retryModalDialog re(this, STR_MSGBADPARAM);
		rv = re.retryAction();
		break;
	}
	case DEVICE_BADTYPE:
	{
		snprintf(msg, MAXMSG, STR_DEVBADTYPE " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		retryModalDialog re(this, msg);
		rv = re.retryAction();
		break;
	}
	case DEVICE_UNKNOWN:
	{
		snprintf(msg, MAXMSG, STR_DEVUNKNOWN " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		retryModalDialog re(this,msg);
		rv = re.retryAction();
		break;
	}
	case DEVICE_LOCKED:
	{
		snprintf(msg, MAXMSG, STR_DEVLOCKED " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		retryModalDialog re(this,msg);
		rv = re.retryAction();
		break;
	}
	case OP_ABORTED:
		note.Notice(STR_OPABORTED);
		break;
	case E2ERR_OPENFAILED:
		snprintf(msg, MAXMSG, STR_OPENFAILED " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	case E2ERR_ACCESSDENIED:
		snprintf(msg, MAXMSG, STR_ACCDENIED " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	case E2ERR_NOTINSTALLED:
		snprintf(msg, MAXMSG, STR_NOTINST " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	case IICERR_SDACONFLICT:
	case IICERR_SCLCONFLICT:
		snprintf(msg, MAXMSG, STR_HWERROR " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	case IICERR_BUSBUSY:
		snprintf(msg, MAXMSG, STR_BUSBUSY " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	case IICERR_NOTACK:
		snprintf(msg, MAXMSG, STR_I2CNOACK " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	case IICERR_NOADDRACK:
	{
		snprintf(msg, MAXMSG, STR_I2CNODEV " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		retryModalDialog re(this,msg);
		rv = re.retryAction();
	//	note.Notice(msg);
		break;
	}
	case IICERR_TIMEOUT:
		snprintf(msg, MAXMSG, STR_I2CTIMEOUT " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	case IICERR_STOP:
		snprintf(msg, MAXMSG, STR_I2CSTOPERR " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	case E2ERR_WRITEFAILED:
		snprintf(msg, MAXMSG, STR_WRITEERR " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	case E2ERR_BLANKCHECKFAILED:
		snprintf(msg, MAXMSG, STR_BLANKCHECKERR " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	case NOTSUPPORTED:
		snprintf(msg, MAXMSG, STR_OPNOTSUP " (%d)", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	default:
		if (msgerr)
			strncpy(msg, msgerr, MAXMSG);
		else
			snprintf(msg, MAXMSG, STR_ERRNO "%d", err_no);
		msg[MAXMSG-1] = '\0';
		note.Notice(msg);
		break;
	}

	return rv;
}

//====================>>> e2CmdWindow::WindowCommand <<<====================
void e2CmdWindow::WindowCommand(ItemVal id, ItemVal val, CmdType cType)
{
	// Default: route menu and toolbar commands here

	UserDebug1(CmdEvents,"e2CmdWindow:WindowCommand(%d)\n",id)

	switch (id)
	{
	//@V@:Case M_New
	case M_New:
	case icbNew:
		if (THEAPP->IsAppReady())
		{
			theApp->NewAppWin(0, "",
					theApp->DefaultWidth(), theApp->DefaultHeight(), 0);
		}
		break;

	//@V@:Case M_Open
	case M_Open:
	case icbOpen:
		if (THEAPP->IsAppReady())
		{
			CmdOpen(ALL_TYPE);
		}
		break;
	case m_OpenProg:
	case icbOpenFlash:
		if (THEAPP->IsAppReady())
		{
			CmdOpen(PROG_TYPE);
		}
		break;
	case m_OpenData:
	case icbOpenEep:
		if (THEAPP->IsAppReady())
		{
			CmdOpen(DATA_TYPE);
		}
		break;

	//Load last file
	case m_File1:
		if (THEAPP->IsAppReady())
		{
			CmdLastFile1();
		}
		break;

	//Load previous file
	case m_File2:
		if (THEAPP->IsAppReady())
		{
			CmdLastFile2();
		}
		break;

	//reload previous file and last file
	case m_Reload:
	case icbReload:
		if (THEAPP->IsAppReady())
		{
		//	CmdReload(val, cType);
			CmdReload();
		}
		break;

	//@V@:Case M_Save
	case M_Save:
	case icbSave:
		if (THEAPP->IsAppReady())
		{
			CmdSave(ALL_TYPE);
		}
		break;

	case m_SaveProg:
	case icbSaveFlash:
		if (THEAPP->IsAppReady())
		{
			CmdSaveAs(PROG_TYPE);
		}
		break;

	case m_SaveData:
	case icbSaveEep:
		if (THEAPP->IsAppReady())
		{
			CmdSaveAs(DATA_TYPE);
		}
		break;

	//@V@:Case M_SaveAs
	case M_SaveAs:
		if (THEAPP->IsAppReady())
		{
			CmdSaveAs(ALL_TYPE);
		}
		break;

#ifdef	vDEBUG
	case M_SetDebug:
	  {
		vDebugDialog debug(this);
		debug.SetDebug();
		break;
	  }
#endif

	//@V@:Case icbPrint
	case M_Print:
	case icbPrint:
		if (THEAPP->IsAppReady())
		{
			CmdPrint();
		}
		break;

	//@V@:Case M_Close
	case M_Close:
		{
			theApp->CloseAppWin(this);
		}
		break;

	//@V@:Case M_Exit
	case M_Exit:
		{
			theApp->Exit();
		}
		break;

	//@V@:Case M_Cut
	case M_Cut:
		if (THEAPP->IsAppReady())
		{
			vNoticeDialog note(this);
			note.Notice("Under construction");
		}
		break;

	//@V@:Case M_Copy
	case M_Copy:
		if (THEAPP->IsAppReady())
		{
			vNoticeDialog note(this);
			note.Notice("Under construction");
		}
		break;

	//@V@:Case M_Paste
	case M_Paste:
		if (THEAPP->IsAppReady())
		{
			vNoticeDialog note(this);
			note.Notice("Under construction");
		}
		break;

	case m_About:
	case icbHelp:
		if (THEAPP->IsAppReady())
		{
			About();
		}
		break;


//	case m_AutoLoadScript:
//		SetValue(m_AutoLoadScript, 1, Checked);
//		break;

	case m_LoadScript:
	case icbScript:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			int rv = OpenScript(0);
			if (rv == OK)
			{
				THEAPP->SetLastScript( THEAPP->script_name );

				char str[MAXPATH];
				int len = strlen(THEAPP->script_name);
				if (len >= MAXPATH)
				{
					strncpy(str, THEAPP->script_name, MAXPATH);
				}
				else
				{
					strncpy(str, STR_RUNSCR " ", MAXPATH - len);
					strcat(str, THEAPP->script_name);
				}
				str[MAXPATH-1] = '\0';
				SetStringAll(m_RunFile, str);
				SetValueAll(m_RunFile, isSens, Sensitive);
				CmdRunScript();
			}
		/**	else
			{
				SetStringAll(m_RunFile, "");
				SetValueAll(m_RunFile, notSens, Sensitive);

				THEAPP->script_name[0] = '\0';
			} **/
			THEAPP->SetAppReady();
		}
		break;

	case m_RunFile:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();

			char const *sp = THEAPP->GetLastScript();
			if (sp && strlen(sp) > 0 && strlen(sp) < MAXPATH)
			{
				strncpy(THEAPP->script_name, sp, MAXPATH);
				THEAPP->script_name[MAXPATH-1] = '\0';
				CmdRunScript();
			}
			THEAPP->SetAppReady();
		}
		break;

	case m_HIndex:
		if (THEAPP->IsAppReady())
		{
			CmdHelp();
		}
		break;

	//@V@:Case m_Setup
	case m_InterfSetup:
	case icbSetup:
		if (THEAPP->IsAppReady())
		{
			e2Dialog e2dlg(this, STR_DLGIOSETUP);
			e2dlg.DialogAction(STR_DLGIOSETUP);
		}
		break;

	//@V@:Case m_Calibration
	case m_Calibration:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdCalibration();
			THEAPP->SetAppReady();
		}
		break;

	case m_Read:
	case icbRead:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdRead(ALL_TYPE);
			THEAPP->SetAppReady();
		}
		break;

	case m_ReadProg:
	case icbReadFlash:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdRead(PROG_TYPE);
			THEAPP->SetAppReady();
		}
		break;

	case m_ReadData:
	case icbReadEep:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdRead(DATA_TYPE);
			THEAPP->SetAppReady();
		}
		break;

	case m_Write:
	case icbWrite:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdWrite(ALL_TYPE, THEAPP->GetVerifyAfterWrite() );
			THEAPP->SetAppReady();
		}
		break;

	case m_WriteProg:
	case icbWriteFlash:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdWrite(PROG_TYPE, THEAPP->GetVerifyAfterWrite());
			THEAPP->SetAppReady();
		}
		break;

	case m_WriteData:
	case icbWriteEep:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdWrite(DATA_TYPE, THEAPP->GetVerifyAfterWrite());
			THEAPP->SetAppReady();
		}
		break;

	case m_Verify:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdVerify(ALL_TYPE);
			THEAPP->SetAppReady();
		}
		break;

	case m_VerifyProg:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdVerify(PROG_TYPE);
			THEAPP->SetAppReady();
		}
		break;

	case m_VerifyData:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdVerify(DATA_TYPE);
			THEAPP->SetAppReady();
		}
		break;

	case m_Program:
	case icbProgram:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdProgram();
			THEAPP->SetAppReady();
		}
		break;

	case m_Erase:
	case icbErase:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdErase();
			THEAPP->SetAppReady();
		}
		break;

	case m_Info:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdGetInfo();
			THEAPP->SetAppReady();
		}
		break;

	case m_SpecBits:
	case icbLock:
		if (THEAPP->IsAppReady())
		{
			SpecialBits();
		}
		break;

	case m_Reset:
		if (THEAPP->IsAppReady())
		{
			CmdReset();
		}
		break;

	case m_DoubleSize:
		if (THEAPP->IsAppReady())
		{
		//	CmdDoubleSize(val, cType);
			CmdDoubleSize();
		}
		break;

	case m_ClearBuf:
		if (THEAPP->IsAppReady())
		{
			CmdClearBuf();
		}
		break;

	case m_FillBuf:
		if (THEAPP->IsAppReady())
		{
			CmdFillBuf();
		}
		break;

	case m_ByteSwap:
		if (THEAPP->IsAppReady())
		{
			CmdByteSwap();
		}
		break;

	case m_ReadSecurity:
		if (THEAPP->IsAppReady())
		{
			CmdReadSecurity(true);
		}
		break;

	case m_WriteSecurity:
		if (THEAPP->IsAppReady())
		{
			CmdWriteSecurity();
		}
		break;

	case m_WriteHEndurance:
		if (THEAPP->IsAppReady())
		{
			CmdWriteSpecial();
		}
		break;

	case m_EditBuf:
		{
			editbuf_enabled = !editbuf_enabled;
			SetValue(m_EditBuf, editbuf_enabled, Checked);
			Draw();
		}
		break;

	case m_Note:
	case icbEdit:
		if (THEAPP->IsAppReady())
		{
			CmdEditNote();
		}
		break;
/**
	case m_Remote:
		if (THEAPP->IsAppReady())
		{
			THEAPP->SetAppBusy();
			CmdRemoteMode();
			THEAPP->SetAppReady();
		}
		break;
**/
	case m_ProgOptions:
		if (THEAPP->IsAppReady())
		{
			ProgramOptions();
		}
		break;

	case m_SerialNumConfig:
		if (THEAPP->IsAppReady())
		{
			SerialNumberOptions();
		}
		break;

	case m_SetSerialNum:
	case icbSernum:
		if (THEAPP->IsAppReady())
		{
			CmdSetSerialNumber();
		}
		break;

	case m_OscCalibConfig:
		if (THEAPP->IsAppReady())
		{
			OscCalibOption();
		}
		break;

	case m_OscCalibRead:
		if (THEAPP->IsAppReady())
		{
			CmdReadCalibration(0);
		}
		break;


	//AutoTag
    //List of case menu Id
	case m_24XX:
	case m_2401a:
	case m_2401b:
	case m_2402:
	case m_2404:
	case m_2408:
	case m_2416:
	case m_24325:
	case m_24645:
	case m_24E16:
	case m_2432:
	case m_2464:
	case m_24128:
	case m_24256:
	case m_24512:
	case m_9306:
	case m_9346:
	case m_9356:
	case m_9357:
	case m_9366:
	case m_9376:
	case m_9386:
	case m_9306_8:
	case m_9346_8:
	case m_9356_8:
	case m_9357_8:
	case m_9366_8:
	case m_9376_8:
	case m_9386_8:
//	case m_at90sXXXX:
	case m_at90s1200:
	case m_at90s2313:
	case m_at90s4414:
	case m_at90s8515:
	case m_atmega8515:
	case m_atmega8535:
	case m_atmega603:
	case m_atmega103:
	case m_atmega8:
	case m_atmega16:
	case m_atmega128:
	case m_atmega64:
	case m_atmega161:
	case m_atmega162:
	case m_atmega163:
	case m_atmega169:
	case m_atmega32:
	case m_atmega323:
	case m_at90s2323:
	case m_at90s2333:
	case m_at90s2343:
	case m_at90s4433:
	case m_at90s4434:
	case m_at90s8534:
	case m_at90s8535:
	case m_attiny12:
	case m_attiny15:
	case m_attiny22:
	case m_attiny26:
	case m_attiny2313:
	case m_attiny13:
//	case m_attiny28:
	case m_attiny25: case m_attiny45: case m_attiny85:
	case m_attiny261: case m_attiny461: case m_attiny861:
	case m_atmega48: case m_atmega88: case m_atmega168:
	case m_atmega164: case m_atmega324: case m_atmega644:
	case m_atmega640: case m_atmega1280: case m_atmega1281:
	case m_atmega2560: case m_atmega2561:
	case m_at90can32: case m_at90can64: case m_at90can128:
	case m_at89s8252: case m_at89s8253:
	case m_at89s51:	case m_at89s52:	case m_at89s53:
	case m_pic12508:
	case m_pic12509:
	case m_pic12508A:
	case m_pic12509A:
	case m_pic12518:
	case m_pic12519:
	case m_pic12671:
	case m_pic12672:
	case m_pic12673:
	case m_pic12674:
	case m_pic1683:
	case m_pic1684:
	case m_pic1684A:
	case m_pic16870:
	case m_pic16871:
	case m_pic16872:
	case m_pic16873:
	case m_pic16874:
	case m_pic16876:
	case m_pic16877:
	case m_pic16873A:
	case m_pic16874A:
	case m_pic16876A:
	case m_pic16877A:
	case m_pic16627:
	case m_pic16628:
	case m_25010:
	case m_25020:
	case m_25040:
	case m_25080:
	case m_25160:
	case m_25320:
	case m_25640:
	case m_25128:
	case m_25256:
	case m_sde2506:
	case m_mda2062:
	case m_nvm3060:
	case m_at1765:
	case m_at17128:
	case m_at17256:
	case m_at17512:
	case m_at17010:
	case m_s2430:
	case m_x2444:
	case m_x2445:
		if (THEAPP->IsAppReady())
		{
		//	CmdSelectDevice(id);
			CmdSelectDevice( MenuIdToType(id) );
		}
		break;

	case cbxEEPType:
		if (THEAPP->IsAppReady())
		{
			CmdSetDeviceType(val);
		}
		break;

	case cbxEEPSubType:
		if (THEAPP->IsAppReady())
		{
			CmdSetDeviceSubType(val);
		}
		break;

	case idAskToSave:
		if ( IsBufChanged() )
		{
			vYNReplyDialog yn(this);
			char str[MAXPATH + MAXMSG];
			if ( strlen(GetFileName()) + strlen(STR_BUFCHANGED) < MAXPATH + MAXMSG )
				snprintf(str, MAXPATH + MAXMSG, STR_BUFCHANGED, GetFileName());
			else
				strncpy(str, STR_BUFCHANGED, MAXPATH + MAXMSG);

			if ( yn.AskYN(str) > 0 )
			{
				SaveFile();
			}
		}
		break;

	case pbrProgress:
		{
			e2Prg->UpdateDialog(val);
		}
		break;

	case idCloseAllDialog:
		{
			e2Prg->CloseDialog();
		//	e2Dlg->CloseDialog();
		}
		break;

	case idEnableToolBar:
		{
			if (val)
			{
				SetValue(cbxEEPType, 1, Sensitive);
				SetValue(cbxEEPSubType, 1, Sensitive);
				SetValue(icbRead, 1, Sensitive);
				SetValue(icbWrite, 1, Sensitive);
				SetValue(icbLock, 1, Sensitive);
				SetValue(icbOpen, 1, Sensitive);
				SetValue(icbSave, 1, Sensitive);
				SetValue(icbReload, 1, Sensitive);
				SetValue(icbPrint, 1, Sensitive);
				SetValue(icbHelp, 1, Sensitive);
			}
			else
			{
				SetValue(cbxEEPType, 0, Sensitive);
				SetValue(cbxEEPSubType, 0, Sensitive);
				SetValue(icbRead, 0, Sensitive);
				SetValue(icbWrite, 0, Sensitive);
				SetValue(icbLock, 0, Sensitive);
				SetValue(icbOpen, 0, Sensitive);
				SetValue(icbSave, 0, Sensitive);
				SetValue(icbReload, 0, Sensitive);
				SetValue(icbPrint, 0, Sensitive);
				SetValue(icbHelp, 0, Sensitive);
			}
		}
		break;

	default:		// route unhandled commands up
		{
			vCmdWindow::WindowCommand(id, val, cType);
			break;
		}
    }
}

HIDDEN int FileExist(char const *name);
HIDDEN int CmpExtension(char const *name, char const *ext);

//====================>>> e2CmdWindow::CmdSave <<<====================
int e2CmdWindow::CmdSave(int type, char *file, long relocation)
{
	int result = OK;

	if (awip->IsBufferValid())
	{
		awip->SetSaveRelocation(relocation);
		awip->SetSaveType(type);
		if (file != 0)
			awip->SetFileName(file);

		result = SaveFile(0);
	}
	else
	{
		result = CMD_NOTHINGTOSAVE;

		if (verbose != verboseNo)
		{
			vNoticeDialog note(this);
			note.Notice(STR_NOTHINGSAVE);
		}
	}

	return result;
}

//====================>>> e2CmdWindow::CmdSaveAs <<<====================
int e2CmdWindow::CmdSaveAs(int type, long relocation)
{
	int result = OK;

	if (awip->IsBufferValid())
	{
		awip->SetSaveRelocation(relocation);
		awip->SetSaveType(type);

		result = SaveFile(1);
	}
	else
	{
		result = CMD_NOTHINGTOSAVE;

		if (verbose != verboseNo)
		{
			vNoticeDialog note(this);
			note.Notice(STR_NOTHINGSAVE);
		}
	}

	return result;
}

//====================>>> e2CmdWindow::CmdLastFile1 <<<====================
int e2CmdWindow::CmdLastFile1()
{
	int result = OK;

	if (verbose == verboseAll)
	{
		if ( IsBufChanged() && awip->IsBufferValid() )
		{
			vYNReplyDialog yn(this);
			if ( yn.AskYN("Buffer changed. Save it before to close?") > 0 )
			{
				awip->SetSaveType(ALL_TYPE);	//??
				SaveFile();
			}
		}
	}
	int data_type;
	const char *s = THEAPP->GetLastFile(data_type);
	if ( s != 0 )
	{
		awip->SetLoadType(data_type);
		awip->SetLoadAutoClearBuf( THEAPP->GetClearBufBeforeLoad() );

		result = OpenFile(s);
//		UpdateChipType();
		UpdateMenuType();
		UpdateStatusBar();
	}

	return result;
}

//====================>>> e2CmdWindow::CmdLastFile2 <<<====================
int e2CmdWindow::CmdLastFile2()
{
	int result = OK;

	if (verbose == verboseAll)
	{
		if ( IsBufChanged() && awip->IsBufferValid() )
		{
			vYNReplyDialog yn(this);
			if ( yn.AskYN("Buffer changed. Save it before to close?") > 0 )
			{
				awip->SetSaveType(ALL_TYPE);	//??
				SaveFile();
			}
		}
	}
	int data_type;
	const char *s = THEAPP->GetPrevFile(data_type);
	if ( s != 0 )
	{
		awip->SetLoadType(data_type);
		awip->SetLoadAutoClearBuf( THEAPP->GetClearBufBeforeLoad() );

		result = OpenFile(s);
//		UpdateChipType();
		UpdateMenuType();
		UpdateStatusBar();
	}

	return result;
}

static char *strlower(char *s)
{
	char *sp = s;
	int ch;
	while (*sp)
	{
		ch = tolower(*sp);
		*sp++ = ch;
	}

	return s;
}

//====================>>> e2CmdWindow::CmdReload <<<====================
int e2CmdWindow::CmdReload()
{
	int result = OK;
/**
	//solo nel caso in cui il penultimo file era un .hex e l'ultimo
	//  un .eep (caso dell'AVR con caricamento Flash+eeprom), ricarica
	//  entrambi i file in sequenza, in caso contrario ricarica solo
	//  l'ultimo.
	int data_type;
	if ( THEAPP->GetPrevFile(data_type) && FileExist(THEAPP->GetPrevFile(data_type))
		 && CmpExtension(THEAPP->GetLastFile(data_type), ".eep") == 0
		 && CmpExtension(THEAPP->GetPrevFile(data_type), ".hex") == 0 )
**/
	char const *sp;
	int dt1, dt2;

	sp = THEAPP->GetLastFile(dt1);
	if ( sp && FileExist(sp) )
	{
		sp = THEAPP->GetPrevFile(dt2);

		/*
		 * We reload both files only if PrevFile is not E2P and last file is
		 * not ALL_TYPE
		 * because we don't want PrevFile change the selected device. In
		 * case of LastFile is ALL_TYPE there's no need to reload even
		 * PrevFile
		 */
		if ( sp && FileExist(sp) && dt1 != ALL_TYPE &&
				CmpExtension((char const *)strlower((char *)sp), ".e2p") != 0 )
		{
			result = CmdLastFile2();

			//A questo punto il last e` diventato Prev!!
			//Now Last become Prev
			if (THEAPP->GetPrevFile(dt1))
			{
				result = CmdLastFile2();
			}
		}
		else
		{
			result = CmdLastFile1();
		}
	}
	else
	{
		result = CMD_NOTHINGTOLOAD;
		if (verbose != verboseNo)
		{
			vNoticeDialog note(this);
			note.Notice(STR_NOTHINGLOAD);
		}
	}

	return result;
}

//====================>>> e2CmdWindow::CmdPrint <<<====================
int e2CmdWindow::CmdPrint()
{
	if (awip->IsBufferValid())
		Print();
	else
	{
		vNoticeDialog note(this);
		note.Notice(STR_NOTHINGPRINT);
	}

	return OK;
}

int e2CmdWindow::PlaySoundMsg(bool val)
{
	if (val)
	{
#ifdef	_WINDOWS
		::PlaySound(THEAPP->GetOkSound(), NULL, SND_FILENAME|SND_ASYNC);
#endif
	}

	return OK;
}

//====================>>> e2CmdWindow::CmdHelp <<<====================
int e2CmdWindow::CmdHelp()
{
#ifdef	_WINDOWS
	ShellExecute(NULL, "open", THEAPP->GetHelpFile(), NULL, NULL, SW_SHOWNORMAL);
#endif
#ifdef	_LINUX_
	char str[MAXPATH];
	snprintf(str, MAXPATH, "%s \"http://www.lancos.com/e2p/ponyprog2000.html\" &", THEAPP->GetHtmlBrowseApp());
	str[MAXPATH-1] = '\0';
	system(str);
#endif

	return OK;
}

//====================>>> e2CmdWindow::CmdCalibration <<<====================
int e2CmdWindow::CmdCalibration()
{
	vYNReplyDialog yn(this);
	if ( yn.AskYN(STR_BUSCALIBRA1 APPNAME STR_BUSCALIBRA2) > 0 )
	{
		vNoticeDialog note(this);
		int err = THEAPP->Calibration();
		if (err == OK)
		{
			note.Notice(STR_BUSCALIBRAOK);
			UpdateStatusBar();
		}
		else
		{
			char str[MAXMSG];
			if (strlen(STR_BUSCALIBRAFAIL) + 10 < MAXMSG)
				snprintf(str, MAXMSG, STR_BUSCALIBRAFAIL " (%d)", err);
			else
				snprintf(str, MAXMSG, "Calibration failed (%d)", err);
			str[MAXMSG-1] = '\0';
			note.Notice(str);
		}
	}

	return OK;
}

//====================>>> e2CmdWindow::CmdRead <<<====================
int e2CmdWindow::CmdRead(int type)
{
	if ( IsBufChanged() && awip->IsBufferValid() && verbose == verboseAll)
	{
		vYNReplyDialog yn(this);
		if ( yn.AskYN(STR_BUFCHANGED3) > 0 )
		{
			awip->SetSaveType(ALL_TYPE);	//???
			SaveFile();
		}
	}

	THEAPP->ClearIgnoreFlag();

	int result;
	int rval;
	int retry_flag = 1;

	while (retry_flag)
	{
		result = OK;

		retry_flag = 0;

		if (!e2Prg->IsDisplayed())
			e2Prg->UpdateDialog(0, STR_MSGREADING);

		awip->SetFileName(0);
		SetTitle();

		rval = awip->Read(type);
		e2Prg->CloseDialog();

	  	if ( rval > 0 )
	  	{
	 	 	first_line = 0;
			curIndex = 0;
			Draw();

			char const *sp;
			sp = GetEEPTypeString(awip->GetEEPPriType(), awip->GetEEPSubType());
			UpdateStrFromStr(sp, "");
			awip->RecalcCRC();
			UpdateStatusBar();

			char str[MAXMSG];
			if (strlen(STR_MSGREADOK) + 20 < MAXMSG)
				snprintf(str, MAXMSG, STR_MSGREADOK " %ld Byte", GetDevSize());
			else
				strncpy(str, "Translate error: STR_MSGREADOK", MAXMSG);
			str[MAXMSG-1] = '\0';

			if (verbose == verboseAll)
			{
				vNoticeDialog note(this);
				note.Notice(str);
			}
		}
		else
		{
	 	 	first_line = 0;
			curIndex = 0;
			Draw();

			UserDebug(UserApp1, "CmdWindow->Read -- Error\n");

			result = rval;

			if (verbose != verboseNo)
			{
				rval = OnError(rval);
				if (rval == 0)	//Abort
				{
					retry_flag = 0;
					THEAPP->ClearIgnoreFlag();
				}
				if (rval == 1)	//Retry
				{
					retry_flag = 1;
					THEAPP->ClearIgnoreFlag();
				}
				else
				if (rval == 2)	//Ignore
				{
					retry_flag = 1;
					THEAPP->SetIgnoreFlag();
				}
			}
		}
	} //while (retry_flag)

	THEAPP->ClearIgnoreFlag();

	return result;
}


//====================>>> e2CmdWindow::CmdWrite <<<====================
int e2CmdWindow::CmdWrite(int type, bool verify)
{
	int result = OK;
	int old_type = type;

	if (verify)
		type &= ~CONFIG_TYPE;

	if ( !awip->IsBufferValid() )
	{
		if (verbose != verboseNo)
		{
			vNoticeDialog note(this);
			note.Notice(STR_NOTHINGWRITE);
		}
		result = CMD_NOTHINGTOWRITE;
	}
	else
	{
		vYNReplyDialog yn(this);

		if ( verbose != verboseAll || yn.AskYN(STR_ASKWRITE) > 0 )
		{
			int rval;
			int retry_flag = 1;

			THEAPP->ClearIgnoreFlag();

			while (retry_flag)
			{
				result = OK;

				retry_flag = 0;

				if (!e2Prg->IsDisplayed())
					e2Prg->UpdateDialog(0, STR_MSGWRITING);

				rval = awip->Write(type, TRUE, verify ? TRUE : FALSE);
	  			if (rval > 0)
	  			{
					if (verify)
					{
						e2Prg->UpdateDialog(0, STR_MSGVERIFING);

						if ( (old_type & CONFIG_TYPE) &&
									!(awip->GetFuseBits() == 0 && awip->GetLockBits() == 0) )
						{
							rval = awip->Verify(type, FALSE, TRUE);
							if (rval > 0)
							{
							//	e2Prg->UpdateDialog(0, STR_MSGWRITINGFUSE);
								rval = awip->Write(CONFIG_TYPE, FALSE, TRUE);
								if (rval > 0)
									rval = awip->Verify(CONFIG_TYPE, FALSE, FALSE);
							}
						}
						else
							rval = awip->Verify(type, FALSE, FALSE);
					}

					e2Prg->CloseDialog();

					vNoticeDialog note(this);

					if ( rval > 0 )	//23/10/1999
					{
						//Aggiunto il 01/10/98
	 					first_line = 0;
						curIndex = 0;
						Draw();

						if (GetDevSize() == 0)
						{
							char const *sp;
							sp = GetEEPTypeString(awip->GetEEPPriType(), awip->GetEEPSubType());
							UpdateStrFromStr(sp);
						}
						awip->RecalcCRC();
						//---

						UpdateStatusBar();
						if (verbose == verboseAll)
							note.Notice(STR_MSGWRITEOK);
					}
					else
					if (rval == 0)
					{
						if (verbose != verboseNo)
							note.Notice(STR_MSGWRITEFAIL);
						result = CMD_WRITEFAILED;
					}
					else
					{
						if (verbose != verboseNo)
							OnError(rval, STR_MSGWRITEFAIL);
						result = rval;
					}
				} // if ( (rval = ...
				else
				{
					e2Prg->CloseDialog();
					THEAPP->CheckEvents();

					result = rval;

					if (verbose != verboseNo)
					{
						rval = OnError(rval, STR_MSGWRITEFAIL);
						if (rval == 0)	//Abort
						{
							retry_flag = 0;
							THEAPP->ClearIgnoreFlag();
						}
						if (rval == 1)	//Retry
						{
							retry_flag = 1;
							THEAPP->ClearIgnoreFlag();
						}
						else
						if (rval == 2)	//Ignore
						{
							retry_flag = 1;
							THEAPP->SetIgnoreFlag();
						}
					} // if (verbose != verboseNo)
				}
			} // while (retry_flag)

			THEAPP->ClearIgnoreFlag();

			e2Prg->CloseDialog();
		} // if ( yn.AskYN(...
	} //else

	return result;
}

//====================>>> e2CmdWindow::CmdReadCalibration <<<====================
int e2CmdWindow::CmdReadCalibration(int idx)
{
	THEAPP->ClearIgnoreFlag();

	int result;
	int rval = 0xFF;
	int retry_flag = 1;

	while (retry_flag)
	{
		result = OK;

		retry_flag = 0;

		long loc;
		int size;
		bool mtype;

		loc = 0; size = 1; mtype = false;
		THEAPP->GetCalibrationAddress(loc, size, mtype);

		if (mtype)
			loc += awip->GetSplittedInfo();

		rval = awip->ReadOscCalibration(idx);

		if (rval >= 0)
		{
			if	(	(size > 0 && size <= 4) &&
					(loc + size <= awip->GetBufSize())
				)
			{
				uint8_t *bp = awip->GetBufPtr() + loc;

				*bp = (uint8_t)rval;

				awip->RecalcCRC();
			//	awip->BufChanged();

				Draw();
				UpdateStatusBar();

				if (verbose == verboseAll)
				{
					char str[MAXMSG];

					if (strlen(STR_MSGREADCALIBOK) + 20 < MAXMSG)
						snprintf(str, MAXMSG, STR_MSGREADCALIBOK ": 0x%02X (%d)", rval, rval);
					else
						strncpy(str, "Translate error: STR_MSGREADCALIBOK", MAXMSG);
					str[MAXMSG-1] = '\0';

					vNoticeDialog note(this);
					note.Notice(str);
				}
			}
			else
			{
				result = BADPARAM;

				if (verbose != verboseNo)
				{
					rval = OnError(result);
					if (rval == 0)	//Abort
					{
						retry_flag = 0;
						THEAPP->ClearIgnoreFlag();
					}
					if (rval == 1)	//Retry
					{
						retry_flag = 1;
						THEAPP->ClearIgnoreFlag();
					}
					else
					if (rval == 2)	//Ignore
					{
						retry_flag = 1;
						THEAPP->SetIgnoreFlag();
					}
				}
			}
		}
		else
		{
			result = rval;

			if (verbose != verboseNo)
			{
				rval = OnError(rval);
				if (rval == 0)	//Abort
				{
					retry_flag = 0;
					THEAPP->ClearIgnoreFlag();
				}
				if (rval == 1)	//Retry
				{
					retry_flag = 1;
					THEAPP->ClearIgnoreFlag();
				}
				else
				if (rval == 2)	//Ignore
				{
					retry_flag = 1;
					THEAPP->SetIgnoreFlag();
				}
			}
		}
	} //while (retry_flag)

	THEAPP->ClearIgnoreFlag();
	return result;
}

//====================>>> e2CmdWindow::CmdErase <<<====================
int e2CmdWindow::CmdErase(int type)
{
	THEAPP->ClearIgnoreFlag();

	int result;
	int rval;
	int retry_flag = 1;

	while (retry_flag)
	{
		result = OK;

		retry_flag = 0;

		if (!e2Prg->IsDisplayed())
			e2Prg->UpdateDialog(0, STR_MSGERASING);

		rval = awip->Erase(type);
		e2Prg->CloseDialog();

	  	if ( rval > 0 )
	  	{
		//	CmdClearBuf();

			if (verbose == verboseAll)
			{
				vNoticeDialog note(this);
				note.Notice(STR_MSGERASEOK);
			}
		}
		else
		{
	 	/* 	first_line = 0;
			curIndex = 0;
			Draw(); */

			UserDebug(UserApp1, "CmdWindow->Erase -- Error\n");

			result = rval;

			if (verbose != verboseNo)
			{
				rval = OnError(rval);
				if (rval == 0)	//Abort
				{
					retry_flag = 0;
					THEAPP->ClearIgnoreFlag();
				}
				if (rval == 1)	//Retry
				{
					retry_flag = 1;
					THEAPP->ClearIgnoreFlag();
				}
				else
				if (rval == 2)	//Ignore
				{
					retry_flag = 1;
					THEAPP->SetIgnoreFlag();
				}
			}
		}
	} //while (retry_flag)

	THEAPP->ClearIgnoreFlag();

	return result;
}

//====================>>> e2CmdWindow::CmdVerify <<<====================
int e2CmdWindow::CmdVerify(int type)
{
	int result = OK;

	if ( !awip->IsBufferValid() )
	{
		if (verbose != verboseNo)
		{
			vNoticeDialog note(this);
			note.Notice(STR_NOTHINGVERIFY);
		}
		result = CMD_NOTHINGTOVERIFY;
	}
	else
	{
		if (!e2Prg->IsDisplayed())
			e2Prg->UpdateDialog(0, STR_MSGVERIFING);

		vNoticeDialog note(this);

		int rval = awip->Verify(type);
		e2Prg->CloseDialog();

		if (rval < 0)
		{
			result = rval;
			if (verbose != verboseNo)
				OnError(rval, STR_MSGVERIFYFAIL1);
		}
		else
		if (rval == 0)
		{
			result = CMD_VERIFYFAILED;
			if (verbose != verboseNo)
				note.Notice(STR_MSGVERIFYFAIL2);
		}
		else
		{
			result = OK;
			if (verbose == verboseAll)
				note.Notice(STR_MSGVERIFYOK);
		}
	}

	return result;
}

//====================>>> e2CmdWindow::CmdProgram <<<====================
int e2CmdWindow::CmdProgram()
{
	int result = OK;
	int prog_opt = THEAPP->GetProgramOptions();

	VerboseType old_verbose = verbose;
	if (verbose == verboseAll)
		verbose = verboseErr;		//Disable all ok messages

	if ( result == OK && (prog_opt & RELOAD_YES) )
	{
		result = CmdReload();
	}
	if ( result == OK && (prog_opt & READFLASH_YES) )
	{
		result = CmdRead(PROG_TYPE);
	}
	if ( result == OK && (prog_opt & READEEP_YES) )
	{
		result = CmdRead(DATA_TYPE);
	}
	if ( result == OK && (prog_opt & BYTESWAP_YES) )
	{
		result = CmdByteSwap();
	}
	if ( result == OK && (prog_opt & SETID_YES) )
	{
		result = CmdSetSerialNumber();
	}
	if ( result == OK && (prog_opt & READOSCAL_YES) )
	{
		result = CmdReadCalibration(0);
	}
	if ( result == OK && (prog_opt & ERASE_YES) )
	{
		result = CmdErase(ALL_TYPE);
	}
	if ( result == OK && (prog_opt & FLASH_YES) )
	{
		result = CmdWrite(PROG_TYPE, true);
	}
	if ( result == OK && (prog_opt & EEPROM_YES) )
	{
		result = CmdWrite(DATA_TYPE, true);
	}
	if ( result == OK && (prog_opt & LOCK_YES) )
	{
		result = CmdWriteSecurity();
	}
	verbose = old_verbose;

	if ( result == OK )
	{
		vNoticeDialog note(this);

		if (verbose == verboseAll)
			note.Notice(STR_MSGPROGRAMOK);
	}
	else
	{
		vNoticeDialog note(this);

		if (verbose != verboseNo)
		{
			char str[MAXMSG];
			snprintf(str, MAXMSG, STR_MSGPROGRAMFAIL " (%d)", result);
			str[MAXMSG-1] = '\0';
			note.Notice(str);
		}
	}

	return result;
}

//**
static char *mytokenizer(char *buf, char * &next)
{
	char *sp = buf;
	char *spend = NULL;

	if (sp == NULL)	// || next == NULL)
		return NULL;

	//ignore spaces, tabs, new-line, carriage return
	while (*sp == ' ' || *sp == '\t' || *sp == '\n' || *sp == '\r')
		sp++;
	if (*sp == '\0')
		return NULL;

	if (*sp == '\"')
	{
		sp++;
		spend = strchr(sp, '\"');

		//Substitute string "\n" char with 0x0A 0x32
		char *s1;

		for (s1 = sp; s1 < spend; s1++)
		{
			if (s1[0] == '\\' && s1[1] == 'n')
			{
				s1[0] = '\n';
				s1[1] = ' ';
			}
		}
	}
	else
	{
		char *s1, *s2;
		s1 = strchr(sp, '\t');
		s2 = strchr(sp, ' ');
		if (s1 != NULL && s2 != NULL)
		{
			if (s1 < s2)
				spend = s1;
			else
				spend = s2;
		}
		else
		if (s1 != NULL && s2 == NULL)
		{
			spend = s1;
		}
		else
		if (s2 != NULL && s1 == NULL)
		{
			spend = s2;
		}
		else
		{
			spend = strchr(sp, '\n');
		}
	}

	if (spend != NULL)
	{
		*spend++ = '\0';
		if (*spend == '\0')
			next = NULL;
		else
			next = spend;
	}
	else
		next = NULL;

	return sp;
}

static int myscantokenizer(char *buf, char *arg[], int arglen)
{
	int k;
	char *sp, *next;

	if (arg == NULL)
		return 0;

	for (k = 0; k < arglen; k++)
		arg[k] = NULL;

	sp = buf;
	for (k = 0; (sp = mytokenizer(sp, next)) != NULL && k < arglen; k++ )
	{
		arg[k] = sp;
		sp = next;
	}

	return k;
}

#define	cmdbuf	arg[0]

int e2CmdWindow::ScriptError(int line_number, int arg_index, char *arg, char *msg)
{
	char str[MAXMSG];

	if (arg == NULL)
		arg = "";

	vNoticeDialog note(this);
	if (arg_index == 0)
		snprintf(str, MAXMSG, STR_MSGSCRIPTERROR " %d: %s '%s'", line_number, msg ? msg : STR_MSGSCRIPTBADCOMMAND, arg);
	else
	if (arg == NULL || arg[0] == '\0')
		snprintf(str, MAXMSG, STR_MSGSCRIPTERROR " %d: %s", line_number, msg ? msg : STR_MSGSCRIPTARGMISSING);
	else
		snprintf(str, MAXMSG, STR_MSGSCRIPTERROR " %d: %s '%s'", line_number, msg ? msg : STR_MSGSCRIPTBADARGUMENT, arg);
	str[MAXMSG-1] = '\0';
	note.Notice(str);

	return CMD_SCRIPTERROR;
}

//====================>>> e2CmdWindow::CmdRunScript <<<====================
int e2CmdWindow::CmdRunScript(bool test_mode)
{
	int result = OK;
	char buf[512];
	char *arg[32];
	int n;
	int linecounter;
	FILE *fh;

	VerboseType old_verbose = verbose;
	if (verbose == verboseAll)
		verbose = verboseErr;		//Disable all ok messages

	if ( strlen(THEAPP->script_name) == 0 )
		return BADPARAM;

	fh = fopen(THEAPP->script_name, "r");
	if (fh == NULL)
		return FILENOTFOUND;

	linecounter = 0;
	while (result == OK && fgets(buf, 511, fh) != NULL)
	{
		linecounter++;

		if (buf[0] == '#')		//Skip comments
			continue;

		n = myscantokenizer(buf, arg, 32);
		if (n >= 1 )
		{
			if (strcasecmp(cmdbuf, "SELECTDEVICE") == 0)
			{
				if (n == 2 && arg[1])
				{
					long new_type;
					new_type = GetEEPTypeFromString(arg[1]);
					if (new_type <= 0)
						result = ScriptError(linecounter, 1, arg[1]);
					else
					{
						if (!test_mode)
							result = CmdSelectDevice(new_type);
					}
				}
				else	//Argument missing
				{
					result = ScriptError(linecounter, 1, arg[1]);
				}
			}
			else
			if (strcasecmp(cmdbuf, "LOAD-ALL") == 0)
			{
				if (n >= 2 && arg[1])
				{
					long reloc_off = 0;

					if (n >= 3 && arg[2])
						reloc_off = strtol(arg[2], NULL, 0);

					if ( !FileExist(arg[1]) )
						result = ScriptError(linecounter, 1, arg[1], STR_MSGFILENOTFOUND);
					else
					{
						if (!test_mode)
							result = CmdOpen(ALL_TYPE, arg[1], reloc_off, 0);		//Don't clear buffer before load on script
					}
				}
				else
				if (n == 1)
				{
					if (!test_mode)
						result = CmdOpen(ALL_TYPE);
				}
			}
			else
			if (strcasecmp(cmdbuf, "LOAD-PROG") == 0)
			{
				if (n >= 2 && arg[1])
				{
					long reloc_off = 0;

					if (n >= 3 && arg[2])
						reloc_off = strtol(arg[2], NULL, 0);

					if ( !FileExist(arg[1]) )
						result = ScriptError(linecounter, 1, arg[1], STR_MSGFILENOTFOUND);
					else
					{
						if (!test_mode)
							result = CmdOpen(PROG_TYPE, arg[1], reloc_off, 0);		//Don't clear buffer before load on script
					}
				}
				else
				if (n == 1)
				{
					if (!test_mode)
						result = CmdOpen(PROG_TYPE);
				}
			}
			else
			if (strcasecmp(cmdbuf, "LOAD-DATA") == 0)
			{
				if (n >= 2 && arg[1])
				{
					long reloc_off = 0;

					if (n >= 3 && arg[2])
						reloc_off = strtol(arg[2], NULL, 0);

					if ( !FileExist(arg[1]) )
						result = ScriptError(linecounter, 1, arg[1], STR_MSGFILENOTFOUND);
					else
					{
						if (!test_mode)
							result = CmdOpen(DATA_TYPE, arg[1], reloc_off, 0);		//Don't clear buffer before load on script
					}
				}
				else
				if (n == 1)
				{
					if (!test_mode)
						result = CmdOpen(DATA_TYPE);
				}
			}
			else
			if (strcasecmp(cmdbuf, "SAVE-ALL") == 0)
			{
				if (n >= 2 && arg[1])
				{
					if (n >= 3 && arg[2])
					{
						if ( strcasecmp(arg[2], "e2p") == 0 )
							awip->SetFileBuf(E2P);
						else
						if ( strcasecmp(arg[2], "bin") == 0 )
							awip->SetFileBuf(BIN);
						else
						if ( strcasecmp(arg[2], "csm") == 0 )
							awip->SetFileBuf(CSM);
						else
						if ( strcasecmp(arg[2], "intel-hex") == 0 )
							awip->SetFileBuf(INTEL);
						else
						if ( strcasecmp(arg[2], "mot-srec") == 0 )
							awip->SetFileBuf(MOTOS);
						else
						{
							result = ScriptError(linecounter, 2, arg[2]);
						}
					}

					if (result == OK && !test_mode)
					{
						if ( strcmp(arg[1], "--") == 0 )
							result = CmdSaveAs(ALL_TYPE);
						else
							result = CmdSave(ALL_TYPE, arg[1]);
					}
				}
				else
				if (n == 1)
				{
					if (!test_mode)
						result = CmdSave(ALL_TYPE);
				}
			}
			else
			if (strcasecmp(cmdbuf, "SAVE-PROG") == 0)
			{
				if (n >= 2 && arg[1])
				{
					if (n >= 3 && arg[2])
					{
						if ( strcasecmp(arg[2], "e2p") == 0 )
							awip->SetFileBuf(E2P);
						else
						if ( strcasecmp(arg[2], "bin") == 0 )
							awip->SetFileBuf(BIN);
						else
						if ( strcasecmp(arg[2], "csm") == 0 )
							awip->SetFileBuf(CSM);
						else
						if ( strcasecmp(arg[2], "intel-hex") == 0 )
							awip->SetFileBuf(INTEL);
						else
						if ( strcasecmp(arg[2], "mot-srec") == 0 )
							awip->SetFileBuf(MOTOS);
						else
						{
							result = ScriptError(linecounter, 2, arg[2]);
						}
					}

					if (result == OK && !test_mode)
					{
						if ( strcmp(arg[1], "--") == 0 )
							result = CmdSaveAs(PROG_TYPE);
						else
							result = CmdSave(PROG_TYPE, arg[1]);
					}
				}
				else
				if (n == 1)
				{
					if (!test_mode)
						result = CmdSave(PROG_TYPE);
				}
			}
			else
			if (strcasecmp(cmdbuf, "SAVE-DATA") == 0)
			{
				if (n >= 2 && arg[1])
				{
					if (n >= 3 && arg[2])
					{
						if ( strcasecmp(arg[2], "e2p") == 0 )
							awip->SetFileBuf(E2P);
						else
						if ( strcasecmp(arg[2], "bin") == 0 )
							awip->SetFileBuf(BIN);
						else
						if ( strcasecmp(arg[2], "csm") == 0 )
							awip->SetFileBuf(CSM);
						else
						if ( strcasecmp(arg[2], "intel-hex") == 0 )
							awip->SetFileBuf(INTEL);
						else
						if ( strcasecmp(arg[2], "mot-srec") == 0 )
							awip->SetFileBuf(MOTOS);
						else
						{
							result = ScriptError(linecounter, 2, arg[2]);
						}
					}

					if (result == OK && !test_mode)
					{
						if ( strcmp(arg[1], "--") == 0 )
							result = CmdSaveAs(DATA_TYPE);
						else
							result = CmdSave(DATA_TYPE, arg[1]);
					}
				}
				else
				if (n == 1)
				{
					if (!test_mode)
						result = CmdSave(DATA_TYPE);
				}
			}
			else
			if (strcasecmp(cmdbuf, "READ-ALL") == 0)
			{
				if (!test_mode)
					result = CmdRead(ALL_TYPE);
			}
			else
			if (strcasecmp(cmdbuf, "READ-PROG") == 0)
			{
				if (!test_mode)
					result = CmdRead(PROG_TYPE);
			}
			else
			if (strcasecmp(cmdbuf, "READ-DATA") == 0)
			{
				if (!test_mode)
					result = CmdRead(DATA_TYPE);
			}
			else
			if (strcasecmp(cmdbuf, "WRITE&VERIFY-ALL") == 0)
			{
				if (!test_mode)
					result = CmdWrite(ALL_TYPE, true);
			}
			else
			if (strcasecmp(cmdbuf, "WRITE&VERIFY-PROG") == 0)
			{
				if (!test_mode)
					result = CmdWrite(PROG_TYPE, true);
			}
			else
			if (strcasecmp(cmdbuf, "WRITE&VERIFY-DATA") == 0)
			{
				if (!test_mode)
					result = CmdWrite(DATA_TYPE, true);
			}
			else
			if (strcasecmp(cmdbuf, "WRITE-ALL") == 0)
			{
				if (!test_mode)
					result = CmdWrite(ALL_TYPE, false);
			}
			else
			if (strcasecmp(cmdbuf, "WRITE-PROG") == 0)
			{
				if (!test_mode)
					result = CmdWrite(PROG_TYPE, false);
			}
			else
			if (strcasecmp(cmdbuf, "WRITE-DATA") == 0)
			{
				if (!test_mode)
					result = CmdWrite(DATA_TYPE, false);
			}
			else
			if (strcasecmp(cmdbuf, "ERASE-ALL") == 0)
			{
				if (!test_mode)
					result = CmdErase(ALL_TYPE);
			}
			else
			if (strcasecmp(cmdbuf, "VERIFY-ALL") == 0)
			{
				if (!test_mode)
					result = CmdVerify(ALL_TYPE);
			}
			else
			if (strcasecmp(cmdbuf, "VERIFY-PROG") == 0)
			{
				if (!test_mode)
					result = CmdVerify(PROG_TYPE);
			}
			else
			if (strcasecmp(cmdbuf, "VERIFY-DATA") == 0)
			{
				if (!test_mode)
					result = CmdVerify(DATA_TYPE);
			}
			else
			if (strcasecmp(cmdbuf, "WRITE-FUSE") == 0)
			{
				if (n >= 2 && arg[1])
				{
					if (!test_mode)
					{
						int fuse;
						fuse = strtol(arg[1], NULL, 0);
						awip->SetFuseBits(fuse);
						result = CmdWriteSpecial();
					}
				}
				else
				if (n == 1)
				{
					if (!test_mode)
						result = CmdWriteSpecial();
				}
			}
			else
			if (strcasecmp(cmdbuf, "SET-FUSE") == 0)
			{
				if (n >= 2 && arg[1])
				{
					if (!test_mode)
					{
						int fuse;
						fuse = strtol(arg[1], NULL, 0);
						awip->SetFuseBits(fuse);
						result = OK;
					}
				}
				else	//Argument missing
				{
					result = ScriptError(linecounter, 1, arg[1]);
				}
			}
			else
			if (strcasecmp(cmdbuf, "WRITE-LOCK") == 0)
			{
				if (n >= 2 && arg[1])
				{
					if (!test_mode)
					{
						int lock;
						lock = strtol(arg[1], NULL, 0);
						awip->SetLockBits(lock);
						result = CmdWriteLock();
					}
				}
				else
				if (n == 1)
				{
					if (!test_mode)
						result = CmdWriteLock();
				}
			}
			else
			if (strcasecmp(cmdbuf, "SET-LOCK") == 0)
			{
				if (n >= 2 && arg[1])
				{
					if (!test_mode)
					{
						int lock;
						lock = strtol(arg[1], NULL, 0);
						awip->SetLockBits(lock);
					}
				}
				else	//Argument missing
				{
					result = ScriptError(linecounter, 1, arg[1]);
				}
			}
			else
			if (strcasecmp(cmdbuf, "EDIT-SECURITY") == 0)
			{
				if (!test_mode)
					result = SpecialBits();
			}
			else
			if (strcasecmp(cmdbuf, "READ-FUSE") == 0)
			{
				if (!test_mode)
					result = CmdReadSpecial();
			}
			else
			if (strcasecmp(cmdbuf, "READ-LOCK") == 0)
			{
				if (!test_mode)
					result = CmdReadLock();
			}
			else
			if (strcasecmp(cmdbuf, "SERIALNUMBER") == 0)
			{
				if (!test_mode)
				{
					if (n >= 2 && arg[1])
					{
						int sernum = strtol(arg[1], NULL, 0);
						THEAPP->SetSerialNumVal(sernum);
					}

					if (n >= 3)
					{
						long start;
						int size;
						bool mtype;
						start = 0; size = 1; mtype = false;
						THEAPP->GetSerialNumAddress(start, size, mtype);
						if (n >= 3 && arg[2])
						{
							start = strtol(arg[2],NULL,0);		//address location
						}
						if (n >= 4 && arg[3])
						{
							size = atoi(arg[3]);				//address size
						}
						if (n >= 5 && arg[4])
						{
							if (strcmp(arg[4], "DATA") == 0)		//offset
								mtype = true;
						}
						THEAPP->SetSerialNumAddress(start, size, mtype);
					}

					if (n >= 6)
					{
						FmtEndian fmt;
						fmt = THEAPP->GetSerialNumFormat();
						if (n >= 6 && arg[5])
						{
							if ( strcmp("LITTLEENDIAN", arg[5]) == 0 )
								fmt = FMT_LITTLE_ENDIAN;
							else
								fmt = FMT_BIG_ENDIAN;
						}
						THEAPP->SetSerialNumFormat(fmt);
					}

					if (n >= 7)
					{
						bool autoinc = THEAPP->GetSerialNumAutoInc();
						if (n >= 7 && arg[6])
						{
							autoinc =  ( strcmp("NO", arg[6]) == 0 ) ? false : true;
						}
						THEAPP->SetSerialNumAutoInc(autoinc);
					}

					result = CmdSetSerialNumber();
				}
			}
			else
			//READ-CALIBRATION <address>[mem][osc_index]
			if (strcasecmp(cmdbuf, "READ-CALIBRATION") == 0)
			{
				if (!test_mode)
				{
					if (n >= 2)
					{
						long start;
						int size;
						bool mtype;

						start = 0; size = 1; mtype = false;
						THEAPP->GetCalibrationAddress(start, size, mtype);
						if (n >= 2 && arg[1])
						{
							start = strtol(arg[1],NULL,0);		//address location
						}
						if (n >= 3 && arg[2])
						{
							if (strcmp(arg[2], "DATA") == 0)	//offset
								mtype = true;
						}
						THEAPP->SetCalibrationAddress(start, size, mtype);
					}

					int osc_index = 0;

					if (n >= 4 && arg[3])
					{
						osc_index = atoi(arg[3]);				//address size
					}

					result = CmdReadCalibration(osc_index);
				}
			}
			else
			if (strcasecmp(cmdbuf, "BYTESWAP") == 0)
			{
				if (!test_mode)
					result = CmdByteSwap();
			}
			else
			if (strcasecmp(cmdbuf, "RESET") == 0)
			{
				if (!test_mode)
					result = CmdReset();
			}
			else
			if (strcasecmp(cmdbuf, "CLEARBUFFER") == 0 || strcasecmp(cmdbuf, "CLEARBUF-ALL") == 0)
			{
				if (!test_mode)
					result = CmdClearBuf(ALL_TYPE);
			}
			else
			if (strcasecmp(cmdbuf, "CLEARBUF-PROG") == 0)
			{
				if (!test_mode)
					result = CmdClearBuf(PROG_TYPE);
			}
			else
			if (strcasecmp(cmdbuf, "CLEARBUF-DATA") == 0)
			{
				if (!test_mode)
					result = CmdClearBuf(DATA_TYPE);
			}
			else
			if (strcasecmp(cmdbuf, "FILLBUFFER") == 0)
			{
				if (n >= 4 && arg[1] && arg[2] && arg[3])
				{
					int from, val, to;
					val = strtol(arg[1], NULL, 0);
					from = strtol(arg[2], NULL, 0);
					to = strtol(arg[3], NULL, 0);

					if (from < to && from >= 0)
					{
						if (!test_mode)
						{
							awip->FillBuffer(from, val, to - from + 1);
							Draw();
							UpdateStatusBar();
						}
					}
					else
						result = ScriptError(linecounter, 2, arg[2]);
				}
				else
				if (n == 1)
				{
					if (!test_mode)
						result = CmdFillBuf();
				}
				else
				{
					result = ScriptError(linecounter, 3, arg[3]);
				}
			}
			else
			if (strcasecmp(cmdbuf, "PAUSE") == 0)
			{
				char *s;

				if (n >= 2 && arg[1])
					s = arg[1];
				else
					s = STR_MSGDEFAULTPAUSE;

				if (!test_mode)
				{
					vYNReplyDialog yn(this);
	  				if ( yn.AskYN(s) > 0 )
						result = OK;
					else
						result = OP_ABORTED;
				}
			}
			else
			if (strcasecmp(cmdbuf, "CALL") == 0)
			{
				if (n >= 2 && arg[1])
				{
					if (!test_mode)
					{
						vOS os;
						result = os.vRunProcess(arg[1], 0, 0, /*Wait*/ 1, /*minimize*/ 0);
						if (result == 99)
							result = ScriptError(linecounter, 1, arg[1], STR_MSGFILENOTFOUND);
					}
				}
				else	//Argument missing
				{
					result = ScriptError(linecounter, 1, arg[1]);
				}
			}
			else
			if (strcasecmp(cmdbuf, "DELAY") == 0)
			{
				if (n >= 2 && arg[1])
				{
					if (!test_mode)
					{
						Wait w;
						int msec = atoi(arg[1]);
						w.WaitMsec(msec);
					}

					result = OK;
				}
				else
				{	//Bad argument
					result = ScriptError(linecounter, 1, arg[1]);
				}
			}
			else
			{
				result = ScriptError(linecounter, 0, arg[0]);	//Bad command
			}
		}
		else
		{
			//Line empty: do nothing
		}
	} //while

	//If in scriptMode don't restore the normal verbose yet
	if (!THEAPP->scriptMode && !test_mode)
		verbose = old_verbose;

	if ( result == OK )
	{
		vNoticeDialog note(this);

		if (verbose == verboseAll)
			note.Notice(STR_MSGPROGRAMOK);
	}
	else
	if ( result == OP_ABORTED)
	{
		if (verbose == verboseAll)
		{
			vNoticeDialog note(this);
			note.Notice(STR_OPABORTED);
		}
	}
	else
	if ( result == CMD_SCRIPTERROR)
	{
		if (verbose == verboseAll)
		{
			vNoticeDialog note(this);
			note.Notice(STR_SCRIPTERROR);
		}
	}
	else
	{
		vNoticeDialog note(this);

		if (verbose != verboseNo)
		{
			char str[MAXMSG];
			snprintf(str, MAXMSG, STR_MSGPROGRAMFAIL " (%d)", result);
			str[MAXMSG-1] = '\0';
			note.Notice(str);
		}
	}

	verbose = old_verbose;

	return result;
}

//====================>>> e2CmdWindow::CmdGetInfo <<<====================
int e2CmdWindow::CmdGetInfo()
{
	long fsize, esize, tsize;

	tsize = GetDevSize();
	fsize = awip->GetSplittedInfo();
	if (fsize == tsize)
		fsize = 0;
	esize = tsize - fsize;

	int pritype = awip->GetEEPPriType();
	if (pritype == E24XX || pritype == E24XX2 || pritype == E24XX5)
	{
	//	uint32_t hblock, secbits;
		int rlv;

		if (pritype != E24XX)
		{
			rlv = 3;
		}
		else
		{
			rlv = awip->GetBankRollOver();
			if (rlv == 0)
			{
				vYNReplyDialog yn(this);
				if ( yn.AskYN(STR_MSGBANKROLLOVER) > 0 )
				{
					rlv = awip->BankRollOverDetect(1);
				}
			}
		}

	//	awip->SecurityRead(secbits);
	//	awip->HighEnduranceRead(hblock);

		e24xx_infoModalDialog info(this, rlv, awip->GetCRC(), tsize);

		info.infoAction();
	}
	else
	{
		other_infoModalDialog info(this, fsize, esize, awip->GetCRC());

		info.infoAction();
	}

	return OK;
}

int e2CmdWindow::CmdReset()
{
	vNoticeDialog note(this);
	awip->Reset();
	if (verbose == verboseAll)
		note.Notice(STR_MSGDEVRESET);

	return OK;
}

//====================>>> e2CmdWindow::CmdDoubleSize <<<====================
int e2CmdWindow::CmdDoubleSize()
{
	vNoticeDialog note(this);

	if ( !awip->IsBufferValid() )
	{
		note.Notice(STR_BUFEMPTY);
	}
	else
	{
		// Double the size
		long new_type = GetEEPTypeFromSize(awip->GetEEPPriType(), awip->GetNoOfBlock() * 2);
		if (new_type > 0)
		{
			awip->DoubleSize();
			CmdSelectDevice(new_type);
		}
		else
		{
			note.Notice(STR_OPNOTSUP);
		}
	}

	return OK;
}

//====================>>> e2CmdWindow::CmdSetDeviceType <<<====================
int e2CmdWindow::CmdSetDeviceType(ItemVal val)
{
	long new_type = CbxIdToType(val, 0);
//	awip->SetEEProm(eeptype_vector[val]);
	awip->SetEEProm( GetE2PPriType(new_type), GetE2PSubType(new_type) );

	UpdateMenuType();
	char const *sp = GetEEPTypeString(awip->GetEEPPriType(), awip->GetEEPSubType());
	UpdateStrFromStr(sp);

//	SetChipSubType(awip->GetEEPPriType());

	first_line = 0;
	curIndex = 0;
	Draw();
	awip->RecalcCRC();	//??? 08/02/1998 riguardare
	UpdateStatusBar();

	//Memorizza in memoria e nel file .INI
	THEAPP->SetLastDevType( BuildE2PType(awip->GetEEPPriType(), awip->GetEEPSubType()) );

	return OK;
}

//====================>>> e2CmdWindow::CmdSetDeviceSubType <<<====================
int e2CmdWindow::CmdSetDeviceSubType(ItemVal val)
{
//	long *vp = GetEEPSubTypeVector(awip->GetEEPPriType());
//	long newtype = vp[val];

	ItemVal v1 = GetValue(cbxEEPType);
	long newtype = CbxIdToType(v1, val);

	UserDebug3(UserApp1, "CmdSetDeviceSubType(%d), v1=%d, type=0x%lx\n", val, v1, newtype);

	awip->SetEEProm(GetE2PPriType(newtype), GetE2PSubType(newtype));
	UpdateMenuType();
	char const *sp = GetEEPTypeString(awip->GetEEPPriType(), awip->GetEEPSubType());
	UpdateStrFromStr(sp);
	first_line = 0;
	curIndex = 0;
	Draw();
	awip->RecalcCRC();	//??? 08/02/1998 riguardare
	UpdateStatusBar();

	//Store in the .INI file
	THEAPP->SetLastDevType( BuildE2PType(awip->GetEEPPriType(), awip->GetEEPSubType()) );

	return OK;
}

//====================>>> e2CmdWindow::CmdOpen <<<====================
int e2CmdWindow::CmdOpen(int type, char *file, long relocation, int clear_buffer)
{
	int result = OK;

	if ( IsBufChanged() && awip->IsBufferValid() && verbose == verboseAll)
	{
		vYNReplyDialog yn(this);
		if ( yn.AskYN(STR_BUFCHANGED2) > 0 )
		{
			awip->SetSaveType(ALL_TYPE);
			SaveFile();
		}
	}

	awip->SetLoadType(type);
	awip->SetLoadRelocation(relocation);
	if (clear_buffer != -1)
		awip->SetLoadAutoClearBuf( (clear_buffer == 0) ? false : true );

	result = OpenFile(file);
//	UpdateChipType();
	UpdateMenuType();
	UpdateStatusBar();

	return result;
}

//====================>>> e2CmdWindow::CmdClearBuf <<<====================
int e2CmdWindow::CmdClearBuf(int type)
{
//	awip->FillBuffer();
	awip->ClearBuffer(type);
	Draw();
	UpdateStatusBar();

	return OK;
}

//====================>>> e2CmdWindow::CmdFillBuf <<<====================
int e2CmdWindow::CmdFillBuf()
{
	static long from = 0, to = 0xFFFF;
	static int val = 0xFF;

	FillDialog e2Fill(this, from, to, val);
	if ( e2Fill.fillAction(STR_MSGINSPARAM) )
	{
		if (e2Fill.GetFrom() <= e2Fill.GetTo())
		{
			from = e2Fill.GetFrom();
			to = e2Fill.GetTo();
			val = e2Fill.GetValue();

			awip->FillBuffer(from, val, to - from + 1);
		//	awip->BufChanged();		moved into awip->FillBuffer()
			Draw();
			UpdateStatusBar();
		}
		else
		{
			vNoticeDialog note(this);
			note.Notice(STR_MSGBADPARAM);
		}
	}

	return OK;
}

//====================>>> e2CmdWindow::SpecialBits <<<====================
int e2CmdWindow::SpecialBits(int readonly)
{
	int rval;
	uint32_t lock, fuse;

	//If the current fuse settings is invalid try to read it from the device
	if (!awip->IsFuseValid())
		CmdReadSecurity(false);	//call with 'false' to avoid recursion!!!

	int repeat;
	do {
		repeat = 0;

		lock = awip->GetLockBits();
		fuse = awip->GetFuseBits();

		fuseModalDialog e2Fuse(this);
		rval = e2Fuse.fuseAction(" ", BuildE2PType(awip->GetEEPPriType(), awip->GetEEPSubType()), lock, fuse, readonly);
		if (rval != 0)	//OK
		{
			if (rval == 3)	//Read
			{
				CmdReadSecurity(false);
				repeat = 1;
			}
			else
			{
				awip->SetLockBits(lock);
				awip->SetFuseBits(fuse);

				if (rval == 2)	//Program
				{
					CmdWriteSecurity();
				}
			}
		}
	} while (repeat);

	return OK;
}

//====================>>> e2CmdWindow::ProgramOptions <<<====================
int e2CmdWindow::ProgramOptions()
{
	int rval;
	int reload, reep, erase, flash, eeprom, lock;

//	lock = awip->GetLockBits();
//	fuse = awip->GetFuseBits();

	progOptionDialog prog(this);
	rval = prog.progAction(" ", BuildE2PType(awip->GetEEPPriType(), awip->GetEEPSubType()),
								reload, reep, erase, flash, eeprom, lock);
	if (rval != 0)	//OK
	{
//		awip->SetLockBits(lock);
//		awip->SetFuseBits(fuse);

//		if (rval == 2)	//Program
//		{
//			CmdWriteSecurity();
//		}
	}

	return OK;
}

//==================>>> e2CmdWindow::SerialNumberOptions <<<=======================
int e2CmdWindow::SerialNumberOptions()
{
	long loc = 0;
	uint32_t val = 0;
	bool memtype = false;
	bool autoinc = false;
	int size = 1;
	FmtEndian fmt = FMT_BIG_ENDIAN;

	val = THEAPP->GetSerialNumVal();
	THEAPP->GetSerialNumAddress(loc, size, memtype);
	autoinc = THEAPP->GetSerialNumAutoInc();
	fmt = THEAPP->GetSerialNumFormat();

	SerNumDialog dlg(this);
	int rval = dlg.SerNumAction(loc, memtype, autoinc, fmt, size, val);
	if (rval)
	{
		THEAPP->SetSerialNumAddress(loc, size, memtype);
		THEAPP->SetSerialNumVal(val);
		THEAPP->SetSerialNumFormat(fmt);
		THEAPP->SetSerialNumAutoInc(autoinc);
	}

	return OK;
}

//==================>>> e2CmdWindow::OscCalibOption <<<=======================
int e2CmdWindow::OscCalibOption()
{
	long loc = 0;
	uint8_t val = 0;
	bool memtype = false;
	int size = 1;

	THEAPP->GetCalibrationAddress(loc, size, memtype);

	OscCalibDialog dlg(this, awip);
	int rval = dlg.OscCalibAction(loc, memtype, val);
	if (rval)
	{
		THEAPP->SetCalibrationAddress(loc, size, memtype);
	}

	return OK;
}


//====================>>> e2CmdWindow::CmdReadSecurity <<<====================
int e2CmdWindow::CmdReadSecurity(bool display_dialog)
{
	int result;

	result = CmdReadLock();
	if (result == OK)
	{
		result = CmdReadSpecial();
		if (result == OK && display_dialog)
			SpecialBits();
	}

	return result;
}

//====================>>> e2CmdWindow::CmdWriteSecurity <<<====================
int e2CmdWindow::CmdWriteSecurity()
{
	int result;

	if ( awip->GetEEPType() == AT90S4433 || awip->GetEEPType() == AT90S2333 )
	{
		result = CmdWriteLock();
		if (result == OK)
		{
			Wait w;
			w.WaitMsec(100);
			result = CmdWriteSpecial();
		}
	}
	else
	{
		result = CmdWriteSpecial();
		if (result == OK)
		{
			result = CmdWriteLock();
		}
	}

	return result;
}

//====================>>> e2CmdWindow::CmdWriteLock <<<====================
int e2CmdWindow::CmdWriteLock()
{
	int result = OK;

	vNoticeDialog note(this);
/**
	long type = BuildE2PType( awip->GetEEPPriType(), awip->GetEEPSubType() );
	if (type == E2464)		//implementazione per le Microchip 24C65
	{
		vReplyDialog rp(this);      // instantiate
		char r[100];                // a buffer for reply

		rp.Reply("Enter the first block      ",r,99);
		if (*r)
		{
			int sb, nb;

			sb = atoi(r);

			rp.Reply("Enter the number of blocks ",r,99);
			if (*r)
			{
				if ((nb = atoi(r)) != 0)
				{
					char str[MAXMSG];
					sprintf(str, "Security bits write succesful (%d,%d)", sb, nb);

					int err = awip->SecurityWrite( ((sb << 4) & 0xF0) | (nb & 0x0F) );
					if (err)
					{
						if (err == IICERR_NOADDRACK)
							note.Notice("Device Not Responding");
						else
							note.Notice("Security bits write error");
					}
					else
					{
						int val;
						awip->SecurityRead(val);
						if ( ((val >> 4) & 0x0F) != sb || (val & 0xF) != nb)
							note.Notice("Security bits write failed");
						else
							note.Notice(str);
					}
				}
				else
					note.Notice("Error");
			}
		}
	}
	else
**/
	{
		int rval;
		int retry_flag = 1;

		THEAPP->ClearIgnoreFlag();

		while (retry_flag)
		{
			result = OK;

			retry_flag = 0;

			if (!e2Prg->IsDisplayed())
				e2Prg->UpdateDialog(0, STR_MSGWRITINGSEC);

			rval = awip->SecurityWrite(0, true);
			if (rval == OK)
			{
				e2Prg->CloseDialog();

			//	if (verbose == verboseAll)
			//		note.Notice("Security bits write successful");

			} // if ( (rval = ...
			else
			if (rval == NOTSUPPORTED)
			{
				e2Prg->CloseDialog();
			}
			else
			{
				e2Prg->CloseDialog();
				THEAPP->CheckEvents();

				result = rval;

				if (verbose != verboseNo)
				{
					rval = OnError(rval, STR_MSGWRITESECFAIL);
					if (rval == 0)	//Abort
					{
						retry_flag = 0;
						THEAPP->ClearIgnoreFlag();
					}
					if (rval == 1)	//Retry
					{
						retry_flag = 1;
						THEAPP->ClearIgnoreFlag();
					}
					else
					if (rval == 2)	//Ignore
					{
						retry_flag = 1;
						THEAPP->SetIgnoreFlag();
					}
				} // if (verbose != verboseNo)
			} // else
		} // while (retry_flag)

		THEAPP->ClearIgnoreFlag();
	}

	return result;
}

//====================>>> e2CmdWindow::CmdReadLock <<<====================
int e2CmdWindow::CmdReadLock()
{
	int result = OK;
	uint32_t bits;

	THEAPP->ClearIgnoreFlag();

	int rval;
	int retry_flag = 1;

//	long type = BuildE2PType( awip->GetEEPPriType(), awip->GetEEPSubType() );

	while (retry_flag)
	{
		result = OK;

		retry_flag = 0;

		if (!e2Prg->IsDisplayed())
			e2Prg->UpdateDialog(0, STR_MSGREADINGSEC);

		rval = awip->SecurityRead(bits);

	  	if ( rval == OK )
	  	{
			Draw();
			UpdateStatusBar();

			e2Prg->CloseDialog();

		//	SpecialBits();
		} // if ( (rval = ...
		else
		if (rval == NOTSUPPORTED)
		{
			e2Prg->CloseDialog();
		}
		else
		{
			e2Prg->CloseDialog();
			THEAPP->CheckEvents();

			result = rval;

			if (verbose != verboseNo)
			{
				rval = OnError(rval, STR_MSGREADSECFAIL);
				if (rval == 0)	//Abort
				{
					retry_flag = 0;
					THEAPP->ClearIgnoreFlag();
				}
				if (rval == 1)	//Retry
				{
					retry_flag = 1;
					THEAPP->ClearIgnoreFlag();
				}
				else
				if (rval == 2)	//Ignore
				{
					retry_flag = 1;
					THEAPP->SetIgnoreFlag();
				}
			}
		} // else
	} // while (retry_flag)

	THEAPP->ClearIgnoreFlag();

	return result;
}

//====================>>> e2CmdWindow::CmdReadSpecial <<<====================
int e2CmdWindow::CmdReadSpecial()
{
	int result = OK;
	uint32_t bits;

	THEAPP->ClearIgnoreFlag();

	int rval;
	int retry_flag = 1;

	long type = BuildE2PType( awip->GetEEPPriType(), awip->GetEEPSubType() );

	while (retry_flag)
	{
		result = OK;

		retry_flag = 0;

		if (!e2Prg->IsDisplayed())
			e2Prg->UpdateDialog(0, STR_MSGREADINGFUSE);

		if (type == E2464)
			rval = awip->HighEnduranceRead(bits);
		else
			rval = awip->FusesRead(bits);

	  	if ( rval == OK )
	  	{
			e2Prg->CloseDialog();

		//	SpecialBits(1);
		} // if ( (rval = ...
		else
		if (rval == NOTSUPPORTED)
		{
			e2Prg->CloseDialog();
		}
		else
		{
			e2Prg->CloseDialog();
			THEAPP->CheckEvents();

			result = rval;

			if (verbose != verboseNo)
			{
				rval = OnError(rval, STR_MSGREADFUSEFAIL);
				if (rval == 0)	//Abort
				{
					retry_flag = 0;
					THEAPP->ClearIgnoreFlag();
				}
				if (rval == 1)	//Retry
				{
					retry_flag = 1;
					THEAPP->ClearIgnoreFlag();
				}
				else
				if (rval == 2)	//Ignore
				{
					retry_flag = 1;
					THEAPP->SetIgnoreFlag();
				}
			}
		} // else
	} // while (retry_flag)

	THEAPP->ClearIgnoreFlag();

	return result;
}

//====================>>> e2CmdWindow::CmdWriteSpecial <<<====================
int e2CmdWindow::CmdWriteSpecial()
{
	int result = OK;

	vNoticeDialog note(this);

	long type = BuildE2PType( awip->GetEEPPriType(), awip->GetEEPSubType() );
	/**
	if (type == E2464)		//Microchip 24C65 high endurance block
	{
		vReplyDialog rp(this);      // instantiate
		char r[100];                // a buffer for reply

		rp.Reply("Enter the high endurance block ",r,99);
		if (*r)
		{
			int a, err;

			a = atoi(r);
			if ( (err = awip->HighEnduranceWrite(a)) )
			{
				if (err == IICERR_NOADDRACK)
					note.Notice("Device Not Responding");
				else
					note.Notice("High endurance block write error");
			}
			else
			{
				int hend = -1;
				awip->HighEnduranceRead(hend);
				if (hend != a)
					note.Notice("High enduranche block write failed");
				else
				{
					result = OK;
					note.Notice("High endurance block write succesful");
				}
			}
		}
	}
	else
	**/
	{
		int rval;
		int retry_flag = 1;
		THEAPP->ClearIgnoreFlag();

		while (retry_flag)
		{
			result = OK;

			retry_flag = 0;

			if (!e2Prg->IsDisplayed())
				e2Prg->UpdateDialog(0, STR_MSGWRITINGFUSE);

			if (type == E2464)
				rval = awip->HighEnduranceWrite(0, true);
			else
				rval = awip->FusesWrite(0, true);

	  		if ( rval == OK )
	  		{
				e2Prg->CloseDialog();

			//	if (verbose == verboseAll)
			//		note.Notice("Special write successful");
			} // if ( (rval = ...
			else
			if (rval == NOTSUPPORTED)
			{
				e2Prg->CloseDialog();
			}
			else
			{
				e2Prg->CloseDialog();
				THEAPP->CheckEvents();

				result = rval;

				if (verbose != verboseNo)
				{
					rval = OnError(rval, STR_MSGWRITEFUSEFAIL);
					if (rval == 0)	//Abort
					{
						retry_flag = 0;
						THEAPP->ClearIgnoreFlag();
					}
					if (rval == 1)	//Retry
					{
						retry_flag = 1;
						THEAPP->ClearIgnoreFlag();
					}
					else
					if (rval == 2)	//Ignore
					{
						retry_flag = 1;
						THEAPP->SetIgnoreFlag();
					}
				}
			} // else
		} // while (retry_flag)

		THEAPP->ClearIgnoreFlag();
	}

	return result;
}

//====================>>> e2CmdWindow::CmdByteSwap <<<====================
int e2CmdWindow::CmdByteSwap()
{
	int result = OK;

	if ( !awip->IsBufferValid() )
	{
		result = CMD_BUFFEREMPTY;
		if (verbose != verboseNo)
		{
			vNoticeDialog note(this);
			note.Notice(STR_BUFEMPTY);
		}
	}
	else
	{
		awip->SwapBytes();
		Draw();
		UpdateStatusBar();
	}

	return result;
}

//====================>>> e2CmdWindow::CmdEditNote <<<====================
int e2CmdWindow::CmdEditNote()
{
	char str1[STRINGID_SIZE+1];
	char str2[COMMENT_SIZE+1];
	notesModalDialog notes(this,awip->GetStringID(),awip->GetComment());
	int rv;

	rv = notes.notesAction();
	notes.GetTextIn(txiStrID, str1, STRINGID_SIZE+1);
	notes.GetTextIn(txiCommnt, str2, COMMENT_SIZE+1);

	if (rv)
	{
		UpdateStrFromStr(str1, str2);
		UpdateStatusBar();
	}

	return OK;
}

//====================>>> e2CmdWindow::CmdSelectDevice <<<====================
int e2CmdWindow::CmdSelectDevice(long new_type)
{
	awip->SetEEProm( GetE2PPriType(new_type), GetE2PSubType(new_type) );
	UpdateMenuType(new_type);
//	UpdateChipType(awip->GetEEPPriType(), awip->GetEEPSubType());
	char const *sp = GetEEPTypeString(awip->GetEEPPriType(), awip->GetEEPSubType());
	UpdateStrFromStr(sp);
	first_line = 0;
	curIndex = 0;
	Draw();
	awip->RecalcCRC();	//??? 08/02/1998 riguardare
	UpdateStatusBar();

	//Memorizza in memoria e nel file .INI
	THEAPP->SetLastDevType( BuildE2PType(awip->GetEEPPriType(), awip->GetEEPSubType()) );

	return OK;
}

/**
//==================>>> e2CmdWindow::CmdRemoteMode <<<=======================
void e2CmdWindow::CmdRemoteMode()
{
	VerboseType old_verbose = verbose;
	verbose = verboseNo;	//No messages when running in remote mode

	e2Prg->UpdateDialog(0, STR_MSGACCEPTCMD);

	SocketServer srv(0, this);

	if ( srv.UDPMainLoop() != OK)
		e2Prg->CloseDialog();

	verbose = old_verbose;
}
**/

//==================>>> e2CmdWindow::CmdSetSerialNumber <<<=======================
int e2CmdWindow::CmdSetSerialNumber()
{
	long loc = 0;
	int size = 1;
	uint32_t val = 0;
	bool memtype = false;

	val = THEAPP->GetSerialNumVal();
	THEAPP->GetSerialNumAddress(loc, size, memtype);

	if (memtype)
		loc += awip->GetSplittedInfo();

	if	(	(size > 0 && size <= 4) &&
			(loc + size <= awip->GetBufSize())
		)
	{
		uint8_t *bp = awip->GetBufPtr() + loc;

		if (THEAPP->GetSerialNumFormat() == FMT_BIG_ENDIAN)
		{
			if (size > 3)
				*bp++ = (uint8_t)((val >> 24) & 0xff);
			if (size > 2)
				*bp++ = (uint8_t)((val >> 16) & 0xff);
			if (size > 1)
				*bp++ = (uint8_t)((val >> 8) & 0xff);
			if (size > 0)
				*bp++ = (uint8_t)(val & 0xff);
		}
		else
		{
			if (size > 0)
				*bp++ = (uint8_t)(val & 0xff);
			if (size > 1)
				*bp++ = (uint8_t)((val >> 8) & 0xff);
			if (size > 2)
				*bp++ = (uint8_t)((val >> 16) & 0xff);
			if (size > 3)
				*bp++ = (uint8_t)((val >> 24) & 0xff);
		}

		awip->RecalcCRC();
	//	awip->BufChanged();

		if ( THEAPP->GetSerialNumAutoInc() )
			THEAPP->SetSerialNumVal(++val);

		Draw();
		UpdateStatusBar();
	}

	return OK;
}

//===================>>> e2CmdWindow::GetDevSize <<<=========================
long e2CmdWindow::GetDevSize() const
{
	return awip->GetSize() == AUTOSIZE_ID ? 0 : awip->GetSize();
}

//===================>>> e2CmdWindow::IsBufChanged <<<=========================
int e2CmdWindow::IsBufChanged() const
{
	return awip->IsBufChanged();
}

//==================>>> e2CmdWindow::UpdateStatusBar <<<=======================
void e2CmdWindow::UpdateStatusBar()
{
//	int is_splitted = awip->GetSplittedInfo() > 0 && awip->GetSplittedInfo() != awip->GetSize();

  	char buf[MAXMSG+1];
	//*** 13/09/99
	snprintf(buf, MAXMSG+1, STATUSBAR_PRINT, GetDevSize(), awip->GetCRC(), awip->IsBufChanged() ? '*' : ' ');
	buf[MAXMSG] = '\0';
	SetString(lblEEPInfo, buf);
	SetString(lblStringID, awip == 0 ? (char *)" " : awip->GetStringID());
}

/**
//==================>>> e2CmdWindow::SetChipSubType <<<=======================
void e2CmdWindow::SetChipSubType(int pritype, int subtype)
{
	long type = BuildE2PType(pritype, subtype);

	//11 - indice pulsante all'interno della toolbar
	//ATTENZIONE! cambia ogni volta che si sposta il gadget!

	//Look for cbxEEPSubType item index
	int index = -1;
	int k;
	for (k = 0; ToolBar[k].cmdType != C_EndOfList; k++)
	{
		if (ToolBar[k].cmdId == cbxEEPSubType)
		{
			index = k;
			break;
		}
	}
	if (index > -1)
	{
		ToolBar[index].itemList = (void*) GetEEPSubTypeList(pritype);
		SetValue(cbxEEPSubType, 0, ChangeListPtr);
	}

	int j = GetEEPSubTypeIndex(type);
	if (j > -1)		//-1 significa non trovato
	{
	//
		if (awip && strlen(awip->GetStringID()) > 0)
		{
			GetEEPSubTypeList(pritype)[j] = awip->GetStringID();
			SetValue(cbxEEPSubType, 0, ChangeList);
		}
	//
		SetValue(cbxEEPSubType, j, Value);
	}

}
**/

/**
//==================>>> e2CmdWindow::UpdateChipType <<<=======================
void e2CmdWindow::UpdateChipType(int pritype, int subtype)
{
	if (pritype < 0)
		pritype = awip->GetEEPPriType();
	if (pritype == 0)
		pritype = E24XX;
	if (subtype < 0)
		subtype = awip->GetEEPSubType();

	SetValue(cbxEEPType, GetEEPTypeIndex(pritype), Value);
	SetChipSubType(pritype, subtype);
}
**/

//==================>>> e2CmdWindow::UpdateMenuType <<<=======================
void e2CmdWindow::UpdateMenuType(long new_type)
{
	if (new_type == 0)
		new_type = BuildE2PType( awip->GetEEPPriType(), awip->GetEEPSubType() );

	//deselect current menu item
	if (type_index > 0)
		SetValue(type_index, 0, Checked);
	//select new menu item
	type_index = TypeToMenuId(new_type);
	if (type_index > 0)
		SetValue(type_index, 1, Checked);

	int a,b;
	TypeToCbxId(new_type, a, b);
	if (a >= 0 && b >= 0)
	{
		SetValue(cbxEEPType, a, Value);

		vMenu *vm = DeviceMenu[a].SubMenu;
		if (vm)
		{
			int k;
			for (k = 0; vm[k].label != 0 && k < COMBOLIST_SIZE; k++)
			{
				comboList2[k] = vm[k].label;
			}
			//Null terminate the list
			if (k < COMBOLIST_SIZE)
				comboList2[k] = 0;
			else
				comboList2[COMBOLIST_SIZE-1] = 0;

			SetValue(cbxEEPSubType, 0, ChangeList);
			SetValue(cbxEEPSubType, b, Value);
		}
	}

	if ( awip && awip->GetEEPPriType() == PIC125XX )	//Not Erasable
	{
		SetValue(m_Erase, 0, Sensitive);
		SetValue(icbErase, 1, Hidden);
	}
	else
	{
		SetValue(m_Erase, 1, Sensitive);
		SetValue(icbErase, 0, Hidden);
	}

	if ( awip && awip->GetSplittedInfo() > 0 && awip->GetSize() > awip->GetSplittedInfo() )
	{
		//Enable menus
		SetValue(m_ReadProg, 1, Sensitive);
		SetValue(m_ReadData, 1, Sensitive);
		SetValue(m_WriteProg, 1, Sensitive);
		SetValue(m_WriteData, 1, Sensitive);
		SetValue(m_VerifyProg, 1, Sensitive);
		SetValue(m_VerifyData, 1, Sensitive);

		SetValue(m_OpenProg, 1, Sensitive);
		SetValue(m_OpenData, 1, Sensitive);
		SetValue(m_SaveProg, 1, Sensitive);
		SetValue(m_SaveData, 1, Sensitive);

		SetValue(icbOpenFlash, 0, Hidden);
		SetValue(icbOpenEep, 0, Hidden);
		SetValue(icbSaveFlash, 0, Hidden);
		SetValue(icbSaveEep, 0, Hidden);
		SetValue(icbReadFlash, 0, Hidden);
		SetValue(icbReadEep, 0, Hidden);
		SetValue(icbWriteFlash, 0, Hidden);
		SetValue(icbWriteEep, 0, Hidden);
	}
	else
	{
		//Disable menus
		SetValue(m_ReadProg, 0, Sensitive);
		SetValue(m_ReadData, 0, Sensitive);
		SetValue(m_WriteProg, 0, Sensitive);
		SetValue(m_WriteData, 0, Sensitive);
		SetValue(m_VerifyProg, 0, Sensitive);
		SetValue(m_VerifyData, 0, Sensitive);

		SetValue(m_OpenProg, 0, Sensitive);
		SetValue(m_OpenData, 0, Sensitive);
		SetValue(m_SaveProg, 0, Sensitive);
		SetValue(m_SaveData, 0, Sensitive);

		SetValue(icbOpenFlash, 1, Hidden);
		SetValue(icbOpenEep, 1, Hidden);
		SetValue(icbSaveFlash, 1, Hidden);
		SetValue(icbSaveEep, 1, Hidden);
		SetValue(icbReadFlash, 1, Hidden);
		SetValue(icbReadEep, 1, Hidden);
		SetValue(icbWriteFlash, 1, Hidden);
		SetValue(icbWriteEep, 1, Hidden);
	}
}


//==================>>> e2CmdWindow::TypeToMenuId <<<=======================
int e2CmdWindow::TypeToMenuId(long type)
{
	int k;
	int rv = -1;

	for (k = 0; index_menu_type[k].menu_id != 0; k++)
	{
		if (index_menu_type[k].type == type)
		{
			rv = index_menu_type[k].menu_id;
			break;
		}
	}

	return rv;
}

void e2CmdWindow::TypeToCbxId(long type, int& idx1, int& idx2)
{
	int k;

	idx1 = idx2 = -1;
	for (k = 0; index_menu_type[k].menu_id != 0; k++)
	{
		if (index_menu_type[k].type == type)
		{
			idx1 = index_menu_type[k].cbx1_id;
			idx2 = index_menu_type[k].cbx2_id;
			break;
		}
	}
}

long e2CmdWindow::CbxIdToType(int idx1, int idx2)
{
	int k;
	long rv = -1;

	for (k = 0; index_menu_type[k].menu_id != 0; k++)
	{
		if (index_menu_type[k].cbx1_id == idx1 && index_menu_type[k].cbx2_id == idx2)
		{
			rv = index_menu_type[k].type;
			break;
		}
	}

	return rv;
}

long GetEEPTypeFromString(char const *name)
{
	int k;
	long rv = -1;

	for (k = 0; index_menu_type[k].menu_id != 0; k++)
	{
		long new_type = index_menu_type[k].type;
		char const *sp = GetEEPTypeString( GetE2PPriType(new_type), GetE2PSubType(new_type) );
		if ( sp && strcasecmp(name, sp) == 0 )
		{
			rv = new_type;
			break;
		}
	}

	return rv;
}


//==================>>> e2CmdWindow::MenuIdToType <<<=======================
long e2CmdWindow::MenuIdToType(int id)
{
	int k;

	for (k = 0; index_menu_type[k].menu_id != 0; k++)
		if (index_menu_type[k].menu_id == id)
			break;
	return index_menu_type[k].type;
}

void e2CmdWindow::MenuIdToCbxId(int id, int& idx1, int& idx2)
{
	int k;

	idx1 = idx2 = -1;
	for (k = 0; index_menu_type[k].menu_id != 0; k++)
		if (index_menu_type[k].menu_id == id)
			break;
	idx1 = index_menu_type[k].cbx1_id;
	idx2 = index_menu_type[k].cbx2_id;
}

void e2CmdWindow::CbxMenuInit()
{
	//Initialize "Device" menu
	int k, j;

	//generic
	for (j = 0; DeviceMenu[j].label != NULL; j++)
	{
		if (DeviceMenu[j].SubMenu == noSub)
		{
			//14/08/98
			long type = MenuIdToType(DeviceMenu[j].menuId);
			DeviceMenu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			DeviceMenu[j].checked = 0;
		}

		if (j < COMBOLIST_SIZE)
			comboList1[j] = DeviceMenu[j].label;
	}
	if (j < COMBOLIST_SIZE)
		comboList1[j] = 0;
	else
		comboList1[COMBOLIST_SIZE-1] = 0;		//Null terminated list

	//i2c8Menu
	for (j = 0; i2c8Menu[j].label != NULL; j++)
	{
		if (i2c8Menu[j].SubMenu == noSub)
		{
			int id = i2c8Menu[j].menuId;
			long type = MenuIdToType(id);
			i2c8Menu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			i2c8Menu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 0;		//<< -- 0
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

	//i2c16Menu
	for (j = 0; i2c16Menu[j].label != NULL; j++)
	{
		if (i2c16Menu[j].SubMenu == noSub)
		{
			int id = i2c16Menu[j].menuId;
			long type = MenuIdToType(id);
			i2c16Menu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			i2c16Menu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 1;		//<< -- 1
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

	//at17xx menu
	for (j = 0; at17Menu[j].label != NULL; j++)
	{
		if (at17Menu[j].SubMenu == noSub)
		{
			int id = at17Menu[j].menuId;
			long type = MenuIdToType(id);
			at17Menu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			at17Menu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 2;		//<< -- 2
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

	//microwireMenu16
	for (j = 0; microwireMenu[j].label != NULL; j++)
	{
		if (microwireMenu[j].SubMenu == noSub)
		{
			int id = microwireMenu[j].menuId;
			long type = MenuIdToType(id);
			microwireMenu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			microwireMenu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 3;		//<< -- 3
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

	//microwireMenu8
	for (j = 0; microwire8Menu[j].label != NULL; j++)
	{
		if (microwire8Menu[j].SubMenu == noSub)
		{
			int id = microwire8Menu[j].menuId;
			long type = MenuIdToType(id);
			microwire8Menu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			microwire8Menu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 4;		//<< -- 4
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

	//spiMenu
	for (j = 0; spiMenu[j].label != NULL; j++)
	{
		if (spiMenu[j].SubMenu == noSub)
		{
			int id = spiMenu[j].menuId;
			long type = MenuIdToType(id);
			spiMenu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			spiMenu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 5;		//<< -- 5
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

	//avrMenu
	for (j = 0; avrMenu[j].label != NULL; j++)
	{
		if (avrMenu[j].SubMenu == noSub)
		{
			int id = avrMenu[j].menuId;
			long type = MenuIdToType(id);
			avrMenu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			avrMenu[j].checked = 0;

			UserDebug3(UserApp1, "Label: %s, Type: 0x%lx, Id: %d\n", avrMenu[j].label, type, id);

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
			{
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 6;		//<< -- 6
					index_menu_type[k].cbx2_id = j;
					break;
				}
			}
		}
	}

	//at89sMenu
	for (j = 0; at89sMenu[j].label != NULL; j++)
	{
		if (at89sMenu[j].SubMenu == noSub)
		{
			int id = at89sMenu[j].menuId;
			long type = MenuIdToType(id);
			at89sMenu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			at89sMenu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 7;		//<< -- 7
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

	//pic16Menu
	for (j = 0; pic16Menu[j].label != NULL; j++)
	{
		if (pic16Menu[j].SubMenu == noSub)
		{
			int id = pic16Menu[j].menuId;
			long type = MenuIdToType(id);
			pic16Menu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			pic16Menu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 8;		//<< -- 8
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

 	//pic12Menu
	for (j = 0; pic12Menu[j].label != NULL; j++)
	{
		if (pic12Menu[j].SubMenu == noSub)
		{
			int id = pic12Menu[j].menuId;
			long type = MenuIdToType(id);
			pic12Menu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			pic12Menu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 9;		//<< -- 9
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

	//imbusMenu
	for (j = 0; imbusMenu[j].label != NULL; j++)
	{
		if (imbusMenu[j].SubMenu == noSub)
		{
			int id = imbusMenu[j].menuId;
			long type = MenuIdToType(id);
			imbusMenu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			imbusMenu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 10;		//<< -- 10
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

	//sde2506 Menu
	for (j = 0; sde25xxMenu[j].label != NULL; j++)
	{
		if (sde25xxMenu[j].SubMenu == noSub)
		{
			int id = sde25xxMenu[j].menuId;
			long type = MenuIdToType(id);
			sde25xxMenu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			sde25xxMenu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 11;		//<< -- 11
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

	//x2444 Menu
	for (j = 0; x2444_Menu[j].label != NULL; j++)
	{
		if (x2444_Menu[j].SubMenu == noSub)
		{
			int id = x2444_Menu[j].menuId;
			long type = MenuIdToType(id);
			x2444_Menu[j].label = (char *)GetEEPTypeString(GetE2PPriType(type), GetE2PSubType(type));
			x2444_Menu[j].checked = 0;

			for (k = 0; index_menu_type[k].menu_id != 0; k++)
				if (index_menu_type[k].menu_id == id)
				{
					index_menu_type[k].cbx1_id = 12;		//<< -- 12
					index_menu_type[k].cbx2_id = j;
					break;
				}
		}
	}

	for (k = 0; index_menu_type[k].menu_id != 0; k++)
	{
		UserDebug2(UserApp1, "Menu Type: 0x%lx, Id: %d", index_menu_type[k].type, index_menu_type[k].menu_id);
		UserDebug2(UserApp1, " Cbx1: %d, Cbx2: %d\n", index_menu_type[k].cbx1_id, index_menu_type[k].cbx2_id);
	}

	//Clear the check in menu Edit buffer
	EditMenu[2].checked = 0;
}

//==================>>> e2CmdWindow::UpdateStrFromBuf <<<=======================
void e2CmdWindow::UpdateStrFromBuf()
{
	char *s;

	s = awip->GetStringID();
//	SetString(txtStringID, s);

	s = awip->GetComment();
	if (s)
		SetString(txtComment, s);
}

//==================>>> e2CmdWindow::UpdateStrFromStr <<<=======================
void e2CmdWindow::UpdateStrFromStr(char const *s1, char const *s2)
{
	if (s1)
	{
//		SetString(txtStringID, (char *)s1);
		awip->SetStringID(s1);
	}
	if (s2)
	{
		SetString(txtComment, (char *)s2);
		awip->SetComment(s2);
	}
}


HIDDEN char* script_filter[] = { "*.e2s", "*", 0 };
HIDDEN int script_filterIndex = 0;

int e2CmdWindow::OpenScript(char const *file)
{
	char fn[256];
	int rval = 1;

	fn[0] = 0;

	if (file == 0 || strlen(file) == 0)
	{
		if ( verbose == verboseNo )
		{
			rval = BADPARAM;
		}
		else
		{
			vFileSelect fsel(this);
			rval = fsel.FileSelect(STR_MSGOPENSCRIPT, fn, 255, script_filter, script_filterIndex);
		}
	}

	if (rval)
	{
		if (fn[0] && FileExist(fn) )
		{
			char oldname[256];

			if (strlen(THEAPP->script_name) > 0)
			{
				strncpy(oldname, THEAPP->script_name, 255);
				oldname[255] = '\0';
			}
			else
				oldname[0] = '\0';

			strcpy(THEAPP->script_name, fn);

			rval = CmdRunScript(true);
			if (rval != OK)
				strcpy(THEAPP->script_name, oldname);

		}
		else
		{
			if (verbose != verboseNo)
			{
				vNoticeDialog note(this);
				note.Notice(STR_MSGFILENOTFOUND);
			}

			rval = FILENOTFOUND;
		}
	}
	else
		rval = OP_ABORTED;

	return rval;
}



HIDDEN char* filter[] = { "*.e2p",   "*.hex",   "*.mot",    "*.bin",              "*.csm", "*.rom", "*.eep", "*", 0 };
//                         ^^^^^      ^^^^^      ^^^^^       ^^^^^                ^^^^^^^
//                        form E2P  form Intel  form S-rec, form Binary (Raw),    CSM,    gli altri non aggiungono ulteriori formati
HIDDEN int filterIndex = 0;

HIDDEN void AddExtension(char *name, unsigned long maxlen)
{
	char *sp = strrchr(name, '.');	//look for extension
	if ( sp == 0 || strcasecmp(sp, filter[filterIndex]+1) != 0 )
	{	//not found
		if ( strlen(name) + strlen(filter[filterIndex]+1) < maxlen )
			strcat(name, filter[filterIndex]+1);	//append extension
	}
}

HIDDEN int CmpExtension(char const *name, char const *ext)
{
	int rv = 1;

	if ( name && strlen(name) &&
		 ext && strlen(ext) )
	{
		const char *sp = strrchr(name, '.');	//cerca l'estensione
		if (sp)
			rv = strcasecmp(sp, ext);
	}

	return rv;
}

//====================>>> e2CmdWindow::OpenFile <<<====================
int e2CmdWindow::OpenFile(char const *file)
{
	char fn[256];
	int rval = 1;

	fn[0] = 0;

	if (file == 0 || strlen(file) == 0)
	{
		if ( verbose == verboseNo )
		{
			rval = BADPARAM;
		}
		else
		{
			filterIndex = (int)awip->GetFileBuf();

			vFileSelect fsel(this);
			if (awip->GetLoadType() == PROG_TYPE)
			{
				rval = fsel.FileSelect(STR_MSGOPENPROGFILE, fn, 255, filter, filterIndex);
			}
			else
			if (awip->GetLoadType() == DATA_TYPE)
			{
				rval = fsel.FileSelect(STR_MSGOPENDATAFILE, fn, 255, filter, filterIndex);
			}
			else
				rval = fsel.FileSelect(STR_MSGOPENFILE, fn, 255, filter, filterIndex);

			THEAPP->SetDefaultFileType( (FileType)filterIndex );
		}
	}
	else
	{
		strncpy(fn, file, 255);
		fn[255] = '\0';
	}

	if (rval)
	{
		if (fn[0] && FileExist(fn) )
		{
			char oldname[256];

			if (awip->GetFileName())
			{
				strncpy(oldname, awip->GetFileName(), 255);
				oldname[255] = '\0';
			}
			else
				oldname[0] = '\0';

			awip->SetFileName(fn);		//Set FileName, update LastFile and PrevFile

			rval = awip->Load();
			if (rval <= 0)
			{
				if (verbose != verboseNo)
				{
					vNoticeDialog note(this);
					note.Notice("Unable to load the file");
				}
			}
			else
			{
				SetTitle();

				UpdateStrFromBuf();
				first_line = 0;
				curIndex = 0;
				Draw();

				rval = OK;
			}
		}
		else
		{
			if (verbose != verboseNo)
			{
				vNoticeDialog note(this);
				note.Notice(STR_MSGFILENOTFOUND);
			}

			rval = FILENOTFOUND;
		}
	}

	UpdateFileMenu();

	return rval;
}

//====================>>> e2CmdWindow::SaveFile <<<====================
int e2CmdWindow::SaveFile(int force_select)
{
	char fn[MAXPATH];
	char const *fnp = awip->GetFileName();
	int err = 0;
	vNoticeDialog note(this);

	if (!force_select && fnp && *fnp)
	{	// Name validated
//		awip->SetNoOfBlock(awip->GetNoOfBank());
		if ( (err = awip->Save()) <= 0 && verbose != verboseNo)
		{
			char str[MAXMSG+1];
			snprintf(str, MAXMSG+1, STR_MSGFILESAVEFAIL " (%d)\n", err);
			str[MAXMSG] = '\0';
			note.Notice(str);
		}
	}
	else
	if (verbose == verboseNo)
	{
		err = BADPARAM;
	}
	else
	{	// Invalid name: select and save the file
		vFileSelect fsel(this);

		fn[0] = 0;
		if (fnp)
		{
			strncpy(fn, fnp, MAXPATH);	//leave space for extension
			fn[MAXPATH-1] = '\0';
		}

		char *s = NULL;
		if (awip->GetSaveType() == PROG_TYPE)
		{
			s = STR_MSGFILESAVEPROG;
		}
		else
		if (awip->GetSaveType() == DATA_TYPE)
		{
			s = STR_MSGFILESAVEDATA;
		}
		else
		{
			s = STR_MSGFILESAVEAS;
		}

		filterIndex = (int)awip->GetFileBuf();

		if ( fsel.FileSelectSave(s, fn, MAXPATH, filter, filterIndex) && fn[0] )
		{
			AddExtension(fn, MAXPATH);

			//Save the old name in case some error occurs, so it can restore it
			char oldname[MAXPATH];
			char *oldnamep;
			if (awip->GetFileName())
			{
				strncpy(oldname, awip->GetFileName(), MAXPATH);
				oldname[MAXPATH-1] = '\0';
				oldnamep = oldname;
			}
			else
				oldnamep = 0;

			awip->SetFileBuf((enum FileType)filterIndex);	//????? Ci vorrebbe un controllo separato dall'estensione sul tipo di file (combobox)
			THEAPP->SetDefaultFileType( awip->GetFileBuf() );
			awip->SetFileName(fn);
			if ( (err = awip->Save()) <= 0 )
			{
				char str[MAXMSG];
				if ( strlen(STR_MSGFILESAVEFAIL) + strlen(fn) + 10 < MAXMSG )
					snprintf(str, MAXMSG, STR_MSGFILESAVEFAIL " %s (%d)\n", fn, err);
				else
					strncpy(str, STR_MSGFILESAVEFAIL, MAXMSG);
				str[MAXMSG-1] = '\0';

				note.Notice(str);
				//ripristina il nome precedente
				awip->SetFileName(oldnamep);
			}
			else
			{
				//Tutto OK, imposta il nuovo titolo
				//vCmdWindow::SetTitle(fn);
				SetTitle();
			}
		}
	}

	//If the Save is ok
	if (err > 0)
	{
		awip->BufChanged(false);
		UpdateStatusBar();
		UpdateFileMenu();

		err = OK;
	}

	return err;
}

#if MAXFNAMEMSG >= MAXMSG
#error "MAXFNAMEMSG should be less than MAXMSG"
#endif

void e2CmdWindow::SetTitle()
{
	if (awip->GetFileName() && strlen(awip->GetFileName()) > 0)
	{
		char str[MAXMSG];

		strncpy(str, STR_TITLE, MAXFNAMEMSG);
		str[MAXFNAMEMSG] = '\0';

		int flen = strlen(awip->GetFileName());
		if (flen < (MAXMSG-MAXFNAMEMSG))
			strcat(str, awip->GetFileName());
		else
		{
			int offset = flen - (MAXMSG-MAXFNAMEMSG) + 1;

			strcat(str, awip->GetFileName() + offset);
		}
		vCmdWindow::SetTitle(str);
	}
	else
		vCmdWindow::SetTitle(DEF_TITLE);
}

const char *e2CmdWindow::GetFileName() const
{
	if (awip->GetFileName() && strlen(awip->GetFileName()) > 0)
		return awip->GetFileName();
	else
		return DEF_FNAME;
}

void e2CmdWindow::UpdateFileMenu()
{
	char const *sp;

	if ( !THEAPP->scriptMode )
	{
		sp = THEAPP->GetLastScript();
		if (sp && strlen(sp) > 0 && strlen(sp) < MAXPATH)
		{
			strncpy(THEAPP->script_name, sp, MAXPATH);
			THEAPP->script_name[MAXPATH-1] = '\0';

			char str[MAXMSG];
			strncpy(str, STR_RUNSCR " ", MAXFNAMEMSG);
			str[MAXFNAMEMSG] = '\0';

			int flen = strlen(THEAPP->script_name);
			if (flen < (MAXMSG-MAXFNAMEMSG))
				strcat(str, THEAPP->script_name);
			else
			{
				int offset = flen - (MAXMSG-MAXFNAMEMSG) + 1;

				strcat(str, THEAPP->script_name + offset);
			}
			SetStringAll(m_RunFile, str);
			SetValueAll(m_RunFile, isSens, Sensitive);
		}
	}

	int data_type;
	sp = THEAPP->GetLastFile(data_type);
	if (sp)
	{
		char str[MAXPATH];
		const char *p = strrchr(sp, '\\');
		if (p)
			strncpy(str,p+1,MAXPATH-6);		//strlen(" DATA") == 6
		else
			strncpy(str,sp,MAXPATH-6);
		str[MAXPATH-6] = '\0';

		if (data_type == DATA_TYPE)
			strcat(str, " DATA");
		else
		if (data_type == PROG_TYPE)
			strcat(str, " PROG");

		SetStringAll(m_File1, str);
		SetValueAll(m_File1, isSens, Sensitive);
	}
	else
	{
		SetStringAll(m_File1, "");
		SetValueAll(m_File1, notSens, Sensitive);
	}

	sp = THEAPP->GetPrevFile(data_type);
	if (sp)
	{
		char str[MAXPATH];
		char *p = (char *)strrchr(sp, '\\');
		if (p)
			strncpy(str,p+1,MAXPATH-6);		//strlen(" DATA") == 6
		else
			strncpy(str,sp,MAXPATH-6);
		str[MAXPATH-6] = '\0';

		if (data_type == DATA_TYPE)
			strcat(str, " DATA");
		else
		if (data_type == PROG_TYPE)
			strcat(str, " PROG");

		SetStringAll(m_File2, str);
		SetValueAll(m_File2, isSens, Sensitive);
	}
	else
	{
		SetStringAll(m_File2, "");
		SetValueAll(m_File2, notSens, Sensitive);
	}
}

void e2CmdWindow::PostInit()
{
	vFont font90(vfDefaultFixed);
	e2Canvas->SetFont(font90);

	UpdateStrFromBuf();
	SetTitle();
	first_line = 0;
	curIndex = 0;
	Draw();
//	UpdateChipType();
	UpdateMenuType();

	char const *sp = GetEEPTypeString(awip->GetEEPPriType(), awip->GetEEPSubType());
	UpdateStrFromStr(sp);
	UpdateStatusBar();

	UpdateFileMenu();

	if ( THEAPP->GetBogoMips() == 0 )
	{
		vNoticeDialog note(this);
		note.Notice(STR_MSGNEEDCALIB);
	}
	if ( THEAPP->GetParPortNo() < 0 )
	{
		vNoticeDialog note(this);
		note.Notice(STR_MSGNEEDSETUP);
	}
}

//====================>>> e2CmdWindow::NextLine <<<====================
int e2CmdWindow::NextLine()
{
	int no_line = awip->GetSize() / awip->GetHexPerLine();
	int rows = e2Canvas->GetRows() - 1;

	if ( first_line < no_line - rows )
	{
		first_line++;
		Draw();
	}
	return first_line;
}

//====================>>> e2CmdWindow::PrevLine <<<====================
int e2CmdWindow::PrevLine()
{
	if ( first_line > 0 )
	{
		first_line--;
		Draw();
	}
	return first_line;
}

//====================>>> e2CmdWindow::NextPage <<<====================
int e2CmdWindow::NextPage()
{
	int no_line = awip->GetSize() / awip->GetHexPerLine();
	int rows = e2Canvas->GetRows() - 1;

	if ( first_line < no_line - rows )
	{
		first_line += rows;
			if (first_line > no_line - rows)
				first_line = no_line - rows;
		Draw();
	}
	return first_line;
}

//====================>>> e2CmdWindow::PrevPage <<<====================
int e2CmdWindow::PrevPage()
{
	int rows = e2Canvas->GetRows() - 1;

	if ( first_line > 0 )
	{
		first_line -= rows;
		if (first_line < 0)
			first_line = 0;
		Draw();
	}
	return first_line;
}

//====================>>> e2CmdWindow::FirstPage <<<====================
void e2CmdWindow::FirstPage()
{
	int no_line = awip->GetSize() / awip->GetHexPerLine();
	int rows = e2Canvas->GetRows() - 1;

	if (no_line > rows)
	{
		first_line = 0;
		Draw();
	}
}

//====================>>> e2CmdWindow::LastPage <<<====================
void e2CmdWindow::LastPage()
{
	int no_line = awip->GetSize() / awip->GetHexPerLine();
	int rows = e2Canvas->GetRows() - 1;

	if ( no_line > rows )
	{
		first_line = no_line - rows;
		Draw();
	}
}

//====================>>> e2CmdWindow::ScrollV <<<====================
void e2CmdWindow::ScrollV(int top)
{
	int no_line = awip->GetSize() / awip->GetHexPerLine();
	int rows = e2Canvas->GetRows() - 1;

#if 0
	// first_line : no_line-rows = top : 100
	first_line = top * (no_line - rows) / 100;	//** 01/05/1998 **
#else
	// first_line : no_line : top : 100
	first_line = top * no_line / 100;
#endif
	if ( first_line < 0 )
		first_line = 0;
	else
	if ( first_line > no_line - rows )
		first_line = no_line - rows;

	Draw();
}

//*** 13/09/99
//const int Hex1_s = 6;
const int Hex1_s = 10;
const int Hex1_e = Hex1_s+23;
const int Hex2_s = Hex1_e+3;
const int Hex2_e = Hex2_s+23;
const int Ascii_s = Hex2_e+4;
const int Ascii_e = Ascii_s+16;

//==================>>> e2CmdWindow::CoordToIndex <<<===================
int e2CmdWindow::CoordToIndex(int row, int col)
{
	int index = -1;

	//first 8 bytes
	if ( col >= Hex1_s && col < Hex1_e )
	{
		col -= Hex1_s;
		if ((col % 3) != 2)
		{
			index = col / 3;
			col = index * 3 + Hex1_s;
		}
	}
	else
	//second 8 bytes
	if ( col >= Hex2_s && col < Hex2_e )
	{
		col -= Hex2_s;
		if ((col % 3) != 2)
		{
			index = 8 + col / 3;
			col = (index - 8)*3 + Hex2_s;
		}
	}
	else
	//ascii 16 chars
	if ( col >= Ascii_s && col < Ascii_e )
	{
		index = col - Ascii_s;
	}

	if (index > -1)
	{
		// index contiene l'indice all'interno del buffer del char da cambiare
		index += (first_line + row) * 16;
	}

	return index;
}

//==================>>> e2CmdWindow::IndexToCoord <<<===================
void e2CmdWindow::IndexToCoord(int index, int &row, int &col)
{
	row = -1;
	col = -1;

	if (index > -1)
	{
		int crow = index / 16;

		if (crow < first_line + e2Canvas->GetRows() - 1)
			row = crow - first_line;

		int ccol = index % 16;

		if (ccol > 7)
			col = (ccol - 8) * 3 + Hex2_s;
		else
			col = ccol * 3 + Hex1_s;
	}
}

//====================>>> e2CmdWindow::CharEdit <<<==================
void e2CmdWindow::CharEdit(int row, int col)
{
	if ( !editbuf_enabled || !awip->IsBufferValid() )
		return;

	if (row == -1 && col == -1)
	{
		if (curIndex >= awip->GetSize())
			curIndex = 0;

		int rv = (awip->GetBufPtr())[curIndex];

		editModalDialog ed(this,rv);
		if ( ed.editAction(STR_MSGINSNEWVAL, rv) )
		{
			(awip->GetBufPtr())[curIndex] = rv;

			awip->RecalcCRC();
			awip->BufChanged();
			UpdateStatusBar();
		}
		if (++curIndex >= awip->GetSize())
			curIndex = 0;

		Draw();
	}
	else
	{
		int index = CoordToIndex(row, col);

		if (index > -1)
		{
			if (index >= awip->GetSize())
				return;

			curIndex = index + 1;

			if (col >= Ascii_s)
			{
				char str[MAXMSG];                // a buffer for reply
				char *sp;

				int k;
				sp = (char *)awip->GetBufPtr() + index;
				for (k = 0; k < 255 && isprint(*sp); k++, sp++)
				{
					str[k] = *sp;
				}
				str[k] = '\0';

				editModalDialog2 ed(this, str);
				snprintf(str, MAXMSG, STR_MSGENTERTEXT " %04Xh", index);
				str[MAXMSG-1] = '\0';
				sp = str;
				if ( ed.editAction(str,sp,255) )
				{
					while (*sp && index < awip->GetBufSize())
						(awip->GetBufPtr())[index++] = *sp++;
					awip->RecalcCRC();
					awip->BufChanged();
					UpdateStatusBar();
				}
			}
			else
			{
				int rv = (awip->GetBufPtr())[index];

				editModalDialog ed(this,rv);
				if ( ed.editAction(STR_MSGINSNEWVAL, rv) )
				{
					(awip->GetBufPtr())[index] = rv;

					awip->RecalcCRC();
					awip->BufChanged();
					UpdateStatusBar();
				}
			}

			if (curIndex >= awip->GetSize())
				curIndex = 0;
			Draw();
		}
	}
}

//====================>>> e2CmdWindow::Draw <<<====================
void e2CmdWindow::Draw(int rows, int cols)
{
	if (awip == 0)
		return;			// ** Vlib 1.22 call Draw before the AppWinInfo is created ** 28/08/99

	if ( !awip->IsBufferValid() )	// ** 01/05/1998 **
		return;

	int no_line;
	int new_top, new_shown;
	int k;

	long size = awip->GetSize();// ? awip->GetSize() : awip->GetBufSize();
	long splitted_size = awip->GetSplittedInfo() / awip->GetHexPerLine();

	no_line = (size + awip->GetHexPerLine() - 1) / awip->GetHexPerLine();

	if (!rows)
		rows = e2Canvas->GetRows();

	rows--;				// to avoid the scrolling

	//Caso in cui non c'e` file o tutto il file sta nella finestra
	if (no_line == 0 || rows >= no_line)
	{
		first_line = 0;
		e2Canvas->ShowVScroll(0);	// Hide Vert Scroll
	}
	else
	{
		//Caso in cui si ingrandisce una finestra che contiene un file
		// visualizzato in fondo
		if (rows > no_line - first_line)
		{
			first_line = no_line - rows;
			if (first_line < 0)
				first_line = 0;
		}

		// rows : no_line = shown : 100
		new_shown = rows * 100 / no_line;

		// first_line : no_line-rows = top : 100
		new_top = first_line * 100 / (no_line - rows);

		e2Canvas->SetVScroll(new_shown, new_top);
		e2Canvas->ShowVScroll(1);	// Show Vert Scroll
	}

//	e2Canvas->Clear();
	e2Canvas->GotoRC(0,0);
	for (k = first_line; k < first_line + rows && k < no_line; k++)
	{
#ifdef	_NO_COLOR
		e2Canvas->DrawText(awip->Dump(k));
#else
		e2Canvas->DrawAttrText(awip->Dump(k,1), ChRed + ChDimColor );
		if (k >= splitted_size)
			e2Canvas->DrawAttrText(awip->Dump(k,2), ChBlue + ChDimColor  );
		else
			e2Canvas->DrawAttrText(awip->Dump(k,2), ChGreen + ChDimColor );
		e2Canvas->DrawAttrText(awip->Dump(k,3), ChMagenta + ChDimColor  );
#endif
	}
	e2Canvas->ClearToEnd(k-first_line, 0);

	int r = -1, c = -1;
	if (editbuf_enabled)
		IndexToCoord(curIndex, r, c);

	if (r > -1 && c > -1)
	{
		e2Canvas->GotoRC(r,c);
		e2Canvas->ShowTextCursor();
	}
	else
		e2Canvas->HideTextCursor();
}

//====================>>> e2CmdWindow::Print <<<====================
void e2CmdWindow::Print()
{
	int no_line = (awip->GetSize() + awip->GetHexPerLine() - 1) / awip->GetHexPerLine();
	int k;
	int a,b,cHeight;
	int curRow = 0, curPage = 0;
    // Print current picture

    vPrintDC pdc;               // create a vPrintDC object
    vPrinter printer;           // and a printer to set attributes

#ifdef __unix__	   // setup the printer
	char *def_print_name = "ponyprog.ps";
#else
	char *def_print_name = "ponyprog.prn";
#endif
	if (!printer.Setup(def_print_name))
		return;

    pdc.SetPrinter(printer);    // change to the printer we setup

    if (!pdc.BeginPrinting())   // call BeginPrinting first
        return;

	pdc.SetTranslate(36,36);    // Add 1/2" (36 * 1/72") margins

	pdc.TextHeight(a,b);
	cHeight = a+b;
	char str[MAXMSG];

	k = 0;
	while (k < no_line)
	{
		pdc.BeginPage();
		curRow = 0;
		snprintf(str, MAXMSG, STR_MSGPAGE " %d   ---   " APPNAME " by " AUTHORNAME , ++curPage);
		str[MAXMSG-1] = '\0';
		pdc.DrawText(0,curRow++ * cHeight, str);
		if (curPage == 1)
		{
			curRow++;
			snprintf(str, MAXMSG, "File  : %s", GetFileName());
			str[MAXMSG-1] = '\0';
			pdc.DrawText(0,curRow++ * cHeight, str);
			snprintf(str, MAXMSG, "Device: %s", awip->GetStringID());
			str[MAXMSG-1] = '\0';
			pdc.DrawText(0,curRow++ * cHeight, str);
			snprintf(str, MAXMSG, "Note  : %s", awip->GetComment());
			str[MAXMSG-1] = '\0';
			pdc.DrawText(0,curRow++ * cHeight, str);
			snprintf(str, MAXMSG, "Size  : %ld Bytes    CRC: %04X", GetDevSize(), awip->GetCRC());
			str[MAXMSG-1] = '\0';
			pdc.DrawText(0,curRow++ * cHeight, str);
		}
		curRow++;
		for (; k < no_line && curRow < 66; k++)
		{
			pdc.DrawText(0, curRow++ * cHeight,(char *)awip->Dump(k));
		}
		pdc.EndPage();
	}

    pdc.EndPrinting();          // Finish printing
}

HIDDEN int FileExist(char const *name)
{
	FILE *fh;
	int rval = 0;

	if ( (fh = fopen(name, "rb")) )
	{
		rval = 1;
		fclose(fh);
	}

	return rval;
}
