# ------------------------------------------------------------------------------
#
#               HP-15C LCD Font Package for the HP-15C Simulator
#
#                          (c) 2017-2018 Torsten Manz
#
# ------------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>
#
# ------------------------------------------------------------------------------

package require Tcl 8
package provide hplcd 1.0.0

namespace eval ::hplcd {

set DIGIT {
  {M 398 725 L 396 728 Q 393 731 389 734 Q 387 736 385.0 737.5 Q 383 739 381 741
   Q 379 742 376.5 743.0 Q 374 744 372 744 L 76 744 Q 69 744 62.5 741.5
   Q 56 739 51 736 Q 45 732 42 729 L 39 727 L 112 651 L 328 651 L 398 725}
  {M 31 394 L 35 390 Q 39 387 44 382 Q 45 381 46.0 380.0 Q 47 379 49 378
   Q 53 375 58 372 Q 61 371 63 371 L 64 371 Q 66 372 74.5 379.5 Q 83 387 93 397
   Q 94 397 94.5 397.5 Q 95 398 95 399 Q 106 409 115 418 L 123 427 L 102 638
   L 27 716 Q 25 714 22.5 711.5 Q 20 709 17 704 Q 13 698 9.0 689.5 Q 5 681 2 672
   Q 1 670 0.5 667.5 Q 0 665 0 663 L 31 394}
  {M 434 674 Q 434 675 431.0 684.5 Q 428 694 410 710 Q 407 709 396.5 699.0
   Q 386 689 375 676 Q 374 676 373 675 L 372 674 Q 359 660 349 648 L 338 637
   L 362 420 L 370 412 Q 377 405 387 395 Q 388 394 389.0 393.0 Q 390 392 391 391
   Q 400 383 408 376 Q 415 371 418 371 L 419 371 Q 422 372 427.5 375.0
   Q 433 378 439 383 Q 440 384 441.5 385.0 Q 443 386 444 386 Q 452 392 458 397
   L 463 402 L 434 674}
  {M 402 359 Q 402 361 395.5 368.5 Q 389 376 380 384 Q 379 384 378.0 385.0
   Q 377 386 377 387 Q 367 395 359 402 L 351 409 L 127 409 L 119 402
   Q 111 396 102 387 Q 100 386 99.0 385.0 Q 98 384 97 383 Q 89 376 82.5 369.0
   Q 76 362 76 359 Q 76 357 84.0 350.0 Q 92 343 102 335 Q 103 334 104.0 333.5
   Q 105 333 105 332 Q 117 324 126 317 L 135 310 L 358 310 L 365 316
   Q 372 323 380 332 Q 381 333 382.0 334.0 Q 383 335 384 336 Q 391 343 396.0 349.5
   Q 401 356 402 359}
  {M 63 63 Q 64 61 64.5 59.5 Q 65 58 66 56 Q 72 39 78 33 L 84 28 L 156 106
   L 135 293 L 125 301 Q 115 309 102 319 Q 101 320 100 320 Q 88 330 77.5 337.5
   Q 67 345 66 345 Q 64 344 60.5 340.5 Q 57 337 54 332 Q 53 330 52.0 328.5
   Q 51 327 50 326 Q 45 318 42 312 L 38 306 L 63 63}
  {M 462 321 L 457 325 Q 451 330 445 336 Q 444 337 443.0 337.5 Q 442 338 441 339
   Q 435 344 429.0 347.5 Q 423 351 421 351 Q 417 350 410.0 344.0 Q 403 338 395 330
   Q 394 329 392.5 327.5 Q 391 326 390 325 Q 381 315 374 307 L 366 299 L 391 108
   L 401 96 Q 410 85 422 71 Q 423 70 424.0 69.0 Q 425 68 426 67 Q 437 55 447.0 45.0
   Q 457 35 460 35 Q 462 35 465.0 37.5 Q 468 40 471 44 Q 473 46 475.0 48.5
   Q 477 51 479 54 Q 483 61 487 67 L 490 73 L 462 321}
  {M 98 15 L 101 12 Q 103 10 107 7 Q 111 5 116.5 2.5 Q 122 0 128 0 L 408 0 L 414 1
   Q 419 3 425 6 Q 431 9 436.5 12.5 Q 442 16 442 20 Q 442 23 432.5 34.5
   Q 423 46 411 60 Q 411 61 410.0 61.5 Q 409 62 408 63 Q 395 78 385 89 L 374 100
   L 176 100 L 98 15}
  {M 550 721 L 552 697 L 554 674 Q 556 651 584 651 L 639 651 Q 663 651 663 670
   L 663 674 L 660 697 L 657 721 Q 654 744 627 744 L 575 744 Q 550 744 550 724
   L 550 721}
  {M 545 783 Q 570 786 584.5 786.5 Q 599 787 613 787 Q 618 788 623 788
   Q 633 788 645 787 Q 602 874 546 897 Q 526 906 516 906 Q 504 906 504 895
   Q 504 888 510 876 Q 531 831 545 783}
}

#    7
#  5   6
#    4
#  2   3
#    1    8
#         9
array set SEGMENTS {
  { } { }
  . {8}
  , {8 9}
  - {4}
  0 {1 2 5 7 6 3}
  1 {3 6}
  2 {1 2 4 6 7}
  3 {1 3 4 6 7}
  4 {3 4 5 6}
  5 {1 3 4 5 7}
  6 {1 2 3 4 5 7}
  7 {3 6 7}
  8 {1 2 3 4 5 6 7}
  9 {1 3 4 5 6 7}
  A {2 3 4 5 6 7}
  B {1 2 3 4 5}
  C {1 2 5 7}
  D {1 2 3 4 6}
  E {1 2 4 5 7}
  I {3 6}
  N {2 3 4}
  O {1 2 3 4}
  P {2 4 5 6 7}
  R {2 4}
  V {1 2 3}
  i {6}
  g {1 3 4 5 6 7}
  l {3 6}
  n {5 6 7}
  r {5 7}
  u {4 5 6}
}

}


# ------------------------------------------------------------------------------
proc ::hplcd::Draw { wid tag } {

  variable DIGIT

  set seg 1
  foreach ii $DIGIT {
    set coords [join $ii]
    $wid create path $coords -stroke "" -tags [list $tag "$tag\s$seg"]
    incr seg
  }

}

# ------------------------------------------------------------------------------
proc ::hplcd::Set { wid tag char } {

  variable SEGMENTS

  foreach seg $SEGMENTS($char) {
    $wid addtag On withtag "$tag\s$seg"
  }

}