/* DirectFB Image Viewer
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Sven Neumann <sven@convergence.de>
 *          Andreas Hundt <andi@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include <linux/soundcard.h>

#include <directfb.h>

#include "dfbsee.h"
#include "interface.h"
#include "volume.h"
#include "volume-tables.h"

static int mixer_fd = -1;
static int volume   = -1;


#define AUDIO_VOLUME(v)   ((int) display2audio[CLAMP ((v), 0, 100)])
#define DISPLAY_VOLUME(v) ((int) audio2display[CLAMP ((v), 0, 100)])

int
volume_open ()
{
  int vol;

  mixer_fd = open ("/dev/mixer", O_RDWR);
  if (mixer_fd < 0)
    {
      perror ("volume_open: error opening /dev/mixer");
      return errno;
    }

  if (ioctl (mixer_fd, SOUND_MIXER_READ_VOLUME, &vol) < 0)
    {
      perror ("volume_open: SOUND_MIXER_READ_VOLUME failed");
      close (mixer_fd);
      mixer_fd = -1;
      volume = -1;
      return errno;
    }

  volume = (((vol & 0xFF) << 8) + (vol & 0xFF00)) / 512;
  volume = DISPLAY_VOLUME (volume);
  interface_set_volume (volume);

  return 0;
}

void
volume_adjust (int value)
{
  if (value && mixer_fd != -1)
    {
      int newvol;

      newvol = CLAMP (volume + value, 0, 100);
      
      if (newvol != volume)
        {
          volume = newvol;

          newvol = AUDIO_VOLUME (volume);
          newvol |= (newvol << 8);
          if (ioctl (mixer_fd, SOUND_MIXER_WRITE_VOLUME, &newvol) < 0)
            {
              perror ("volume_adjust: SOUND_MIXER_WRITE_VOLUME failed");
              return;
            }

          interface_set_volume (volume);
        }
    }
}

void volume_close ()
{
  close (mixer_fd);
  mixer_fd = -1;
  volume = -1;
 
  interface_set_volume (-1);
}
