#include <stdio.h>
#include <stdlib.h>

#include <math.h>

#define GAMMA 120.0

int
main (void)
{
  int i;
  int j;
  double logG;

  logG = log (GAMMA + 1.0);

  printf ("/* Logarithmic volume mapping tables */\n");

  printf ("\nconst unsigned char audio2display[101] = {\n");

  for (i = 0; i <= 100; i++)
    {
      j = (int) ((exp (((double) (i) / 100.0) * logG) - 1.0) / GAMMA 
                  * 100.0 + 0.5);
      printf ("%3d", j);
      if (i < 100)
        printf (", ");
      if (i % 10 == 9)
        printf ("\n");
    }
  printf (" };\n");
  
  printf ("\nconst unsigned char display2audio[101] = {\n");

  for (i = 0; i <= 100; i++)
    {
      j = (int) (log ((((double) (i)) / 100.0) * GAMMA + 1.0) / logG
                 * 100.0 + 0.5);
      printf ("%3d", j);
      if (i < 100)
        printf (", ");
      if (i % 10 == 9)
        printf ("\n");
    }
  printf (" };\n");

  return 0;
}
