/* DirectFB Image Viewer
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Sven Neumann <sven@convergence.de>
 *          Andreas Hundt <andi@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>

#include <directfb.h>

#include "dfbsee.h"
#include "video-load.h"


IDirectFBVideoProvider *
video_load (const char              *filename, 
            int                     *width, 
            int                     *height,
            double                  *length,
            int                     *can_seek,
            DFBColorAdjustmentFlags *color_adjust_caps)
{
  DFBSurfaceDescription         dsc;
  DFBVideoProviderCapabilities  caps;
  IDirectFBVideoProvider       *provider;

  err = dfb->CreateVideoProvider (dfb, filename, &provider);

  if (err)
    {
      *width = 0;
      *height = 0;
      DirectFBError (NULL, err);
      return NULL;
    }

  provider->GetSurfaceDescription (provider, &dsc);

  *width = dsc.width;
  *height = dsc.height;

  provider->GetCapabilities (provider, &caps);
  provider->GetLength (provider, length);

  *color_adjust_caps = DCAF_NONE;
  if (caps & DVCAPS_BRIGHTNESS) *color_adjust_caps |= DCAF_BRIGHTNESS;
  if (caps & DVCAPS_CONTRAST)   *color_adjust_caps |= DCAF_CONTRAST;
  if (caps & DVCAPS_HUE)        *color_adjust_caps |= DCAF_HUE;
  if (caps & DVCAPS_SATURATION) *color_adjust_caps |= DCAF_SATURATION;

  *can_seek = (caps & DVCAPS_SEEK) != 0;

  return provider;
}
