/* DirectFB Image Viewer
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Sven Neumann <sven@convergence.de>
 *          Andreas Hundt <andi@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include <directfb.h>

#include "dfbsee.h"
#include "options.h"
#include "media.h"


Media *
options_parse (int    argc, 
               char **argv)
{
  Media *media       = NULL;
  int print_usage    = 0;
  int print_version  = 0;
  int i;

  if (argc < 2)
    print_usage = 1;

  for (i = 1; i < argc && !print_usage && !print_version; i++)
    {
      if (strcmp (argv[i], "--version") == 0 || strcmp (argv[i], "-v") == 0)
	{
	  print_version = 1;
	}
      else if (strcmp (argv[i], "--fullscreen") == 0 ||
	       strcmp (argv[i], "-f") == 0)
	{
	  fullscreen = 1;
	}
      else if (strcmp (argv[i], "--zoom") == 0 || strcmp (argv[i], "-z") == 0)
	{
          zoomed = 1;
	}
      else if (strcmp (argv[i], "--override-ratio") == 0 ||
	       strcmp (argv[i], "-r") == 0)
	{          
          int w, h;

	  override_ratio = 1;
          if (i + 1 < argc && sscanf (argv[i+1], "%d:%d", &w, &h) == 2)
            {
              i++;
              if (w > 0 && h > 0)
                aspect = (double) w / (double) h;
            }
	}
      else if (strcmp (argv[i], "--corner") == 0 || 
               strcmp (argv[i], "-c") == 0)
	{
          corner = 1;
	}
       else if (strcmp (argv[i], "--slide-show") == 0 || 
               strcmp (argv[i], "-s") == 0)
         {
           if (i + 1 < argc && sscanf (argv[i+1], "%d", &slide_show) == 1)
             i++;
           else 
             slide_show = -1;
	}
      else if (strcmp (argv[i], "--time") == 0 || 
               strcmp (argv[i], "-t") == 0)
	{
          show_time = 1;
	}
      else if (strcmp (argv[i], "--mode") == 0 || strcmp (argv[i], "-m") == 0)
	{
	  if (++i < argc && 
              sscanf (argv[i], "%dx%d@%d", 
                      &screen_width, &screen_height, &screen_depth) == 3)
	    {
	      set_mode = 1;
	    }
	  else
	    {
	      print_usage = 1;
	    }
	}
      else
	{
          media = media_add (argv[i]);
        }
    }

  if (print_version)
    {
      printf ("DFBSee version " VERSION "\n");
      return NULL;
    }

  if (print_usage || !media)
    {
      printf ("DFBSee version " VERSION
	      " - an Image Viewer and Video Player using DirectFB\n"
	      "\n" "Usage: %s [options] <file> [...]\n\n", argv[0]);
      printf ("Options:\n"
	      "  -v, --version                Print version information.\n"
	      "  -f, --fullscreen             Start in fullscreen mode.\n"
	      "  -z, --zoom                   Start zoomed.\n"
	      "  -s, --slide-show <secs>      Run in slide show mode (secs >= 0).\n"
	      "  -r, --override-ratio [n:n]   Override aspect ratio.\n"
              "  -c, --corner                 Put images/video in topleft corner.\n"
              "  -t, --time                   Show current time.\n"
	      "  -m, --mode <nnn>x<nnn>@<nn>  Switch framebuffer to nnn x nnn @ nn bpp.\n");
      return NULL;
    }

  return media;
}
