/* DirectFB Image Viewer
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Sven Neumann <sven@convergence.de>
 *          Andreas Hundt <andi@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MEDIA_H__
#define __MEDIA_H__


struct _Media 
{
  char                    *filename;
  int                      loaded;
  char                    *error;

  int                      width;
  int                      height;
  DFBImageCapabilities     caps;

  RotationType             rot;

  double                   zoom;

  double                   length;
  int                      running;

  int                      can_seek;
  DFBColorAdjustmentFlags  color_adjust_caps;
  DFBColorAdjustmentFlags  color_adjustment;

  IDirectFBSurface        *image;
  IDirectFBVideoProvider  *video;

  Media                   *prev;
  Media                   *next;
};


/*  media_add() always returns the head of the media list  */
Media * media_add         (const char       *filename);

Media * media_previous    (Media            *media);
Media * media_next        (Media            *media);

void    media_set_dest    (Media            *media,
                           IDirectFBSurface *dest);

void    media_set_zoom    (Media            *media,
                           double            zoom);
void    media_redraw      (Media            *media);
void    media_rotate      (Media            *media,
                           int               negative);

void    media_toggle_play (Media            *media);
void    media_home        (Media            *media);
void    media_end         (Media            *media);
void    media_skip        (Media            *media,
                           double            skip);

double  media_calc_size   (Media            *media,
                           double            zoom,
                           DFBRectangle     *rect);

void    media_deinit      (void);

void    media_color_adjust (Media           *media,
                            int              value);
void    media_set_color_adjustment (Media                   *media,
                                    DFBColorAdjustmentFlags  flags);


#endif /*  __IMAGE_LOAD_H__  */
