/* DirectFB Image Viewer
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Sven Neumann <sven@convergence.de>
 *          Andreas Hundt <andi@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __INTERFACE_H__
#define __INTERFACE_H__

typedef enum 
{
  NONE     = 0,       /* do nothing (waits for the last update to finish) */
  SCREEN   = 1 << 0,  /* clear the whole screen */
  CLEAR    = 1 << 1,  /* clear the image area   */
  IMAGE    = 1 << 2,  /* draw the image/video   */
  FRAME    = 1 << 3,  /* draw the frame         */
  TITLE    = 1 << 4,  /* draw the title         */
  SIZE     = 1 << 5,  /* draw width and height  */
  ZOOM     = 1 << 6,  /* draw zoom factor       */
  TIME     = 1 << 7,  /* draw current time      */
  PROGRESS = 1 << 8,  /* draw video progress    */
  VOLUME   = 1 << 9,  /* draw volume            */
  COLOR    = 1 << 10, /* draw color adjustment  */
  MESSAGE  = 1 << 11, /* draw message           */
  HELP     = 1 << 12
} InterfaceUpdateFlags;


IDirectFBSurface * interface_init        (void);
void               interface_deinit      (void);

void               interface_set_media   (Media                *media);
void               interface_set_volume  (int                   volume);
void               interface_set_zoom    (double                zoom);
void               interface_set_rect    (DFBRectangle         *rect);
void               interface_set_message (const char           *message,
                                          int                   animate);
void               interface_update      (InterfaceUpdateFlags  update);
void               interface_lock        (void);
void               interface_unlock      (void);


#endif /*  __INTERFACE_H__  */
