/* DirectFB Image Viewer
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Sven Neumann <sven@convergence.de>
 *          Andreas Hundt <andi@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __INTERFACE_DRAW_H__
#define __INTERFACE_DRAW_H__


IDirectFBSurface * interface_draw_init     (void);
void               interface_draw_deinit   (void);
void               interface_draw_clear    (int                 screen);
void               interface_draw_frame    (void);
void               interface_draw_title    (const char         *title);
int                interface_draw_message  (const char         *message,
                                            int                 frame);
void               interface_draw_size     (int                 width, 
                                            int                 height);
void               interface_draw_zoom     (double              zoom);
void               interface_draw_progress (double              pos, 
                                            double              length);
void               interface_draw_volume   (int                 volume);
void               interface_draw_time     (const time_t       *now);
void               interface_draw_image    (IDirectFBSurface       *image,
                                            int                     width,
                                            int                     height,
                                            DFBImageCapabilities    caps,
                                            DFBRectangle           *rect);
void               interface_draw_video    (IDirectFBVideoProvider *video,
                                            int                     width,
                                            int                     height,
                                            DFBRectangle           *rect,
                                            RotationType            rot);
void               interface_draw_help     (void);
void           interface_draw_color_adjust (DFBColorAdjustment     *adj);


#endif /*  __INTERFACE_DRAW_H__  */
