/* DirectFB Image Viewer
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Sven Neumann <sven@convergence.de>
 *          Andreas Hundt <andi@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>

#include <directfb.h>

#include "dfbsee.h"
#include "image-load.h"


IDirectFBSurface *
image_load (const char           *filename, 
            int                  *width, 
            int                  *height,
            DFBImageCapabilities *caps)
{
  IDirectFBSurface       *surface;
  DFBSurfaceDescription   dsc;
  DFBImageDescription     image_dsc;
  IDirectFBImageProvider *provider;

  err = dfb->CreateImageProvider (dfb, filename, &provider);

  if (err)
    {
      *width = 0;
      *height = 0;
      return NULL;
    }

  provider->GetImageDescription (provider, &image_dsc);
  provider->GetSurfaceDescription (provider, &dsc);

  *width  = dsc.width;
  *height = dsc.height;
  primary->GetPixelFormat (primary, &dsc.pixelformat); 

  DFBCHECK (dfb->CreateSurface (dfb, &dsc, &surface));

  provider->RenderTo (provider, surface);

  provider->Release (provider);

  if (image_dsc.caps & DICAPS_COLORKEY)
    surface->SetSrcColorKey (surface, 
                             image_dsc.colorkey_r,
                             image_dsc.colorkey_g,
                             image_dsc.colorkey_b);

  *caps = image_dsc.caps;

  return surface;
}
