/* DirectFB Image Viewer
 *
 * Copyright (C) 2001  convergence integrated media
 * Authors: Sven Neumann <sven@convergence.de>
 *          Andreas Hundt <andi@convergence.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DFBSEE_H__
#define __DFBSEE_H__

/* macro for a safe call to DirectFB functions */
#define DFBCHECK(x...)                                                     \
               err = x;                                                    \
               if (err != DFB_OK) {                                        \
                    fprintf( stderr, "%s <%d>:\n\t", __FILE__, __LINE__ ); \
                    DirectFBErrorFatal( #x, err );                         \
               }

#define MIN(a,b) ((a) < (b) ? (a) : (b))
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define CLAMP(x,l,u) ((x) < (l) ? (l) : ((x) > (u) ? (u) : (x))) 


extern IDirectFB        *dfb;
extern IDirectFBSurface *primary;
extern DFBResult         err;
extern int    screen_width;
extern int    screen_height;
extern int    screen_depth;
extern int    fullscreen;
extern int    override_ratio;
extern int    corner;
extern int    set_mode;
extern int    show_time;
extern int    zoomed;
extern int    slide_show;
extern int    hw_stretchblit;
extern double aspect;

typedef struct _Media Media;

typedef enum
{
  ROT_NONE,
  ROT_LEFT,
  ROT_RIGHT,
  ROT_HALF
} RotationType;


#endif /*  __DFBSEE_H__  */
