 //   Copyright (c) 2012-2016 Giovanni Lagorio. John Abbott, Anna M. Bigatti
//
//   This file is part of the source of CoCoALib, the CoCoA Library.
//
//   CoCoALib is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   CoCoALib is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with CoCoALib.  If not, see <http://www.gnu.org/licenses/>.

#include "BuiltInOneLiners.H"
#include "CoCoALibSupplement.H"

using namespace std;
using namespace boost;
using namespace boost::iostreams;
using namespace CoCoA::AST;
using namespace CoCoA::LexerNS;
using namespace CoCoA::ParserNS;

namespace CoCoA {
namespace InterpreterNS {

//  extern std::vector<NameFunPair> builtIns; // declared in BuiltInFunctions.C

////// functions on BIGINT
DECLARE_COCOALIB_FUNCTION1(factorial, INT)
DECLARE_COCOALIB_FUNCTION1(primorial, INT)
DECLARE_COCOALIB_FUNCTION1(fibonacci, INT)
DECLARE_COCOALIB_FUNCTION1(FloorSqrt, INT) // AMB
DECLARE_COCOALIB_FUNCTION1(NextProbPrime, INT) // AMB
DECLARE_COCOALIB_FUNCTION1(PrevProbPrime, INT) // JAA
DECLARE_COCOALIB_FUNCTION1(SmallestNonDivisor, INT) // JAA
DECLARE_COCOALIB_FUNCTION2(FactorMultiplicity, INT, INT) // JAA
DECLARE_COCOALIB_FUNCTION2(RoundDiv, INT, INT) // JAA
DECLARE_COCOALIB_FUNCTION2(FloorRoot, INT, INT) // AMB
DECLARE_COCOALIB_FUNCTION3(PowerMod, INT, INT, INT)
DECLARE_COCOALIB_FUNCTION2(KroneckerSymbol, INT, INT)
DECLARE_COCOALIB_FUNCTION1(IsEven, INT) // AMB
DECLARE_COCOALIB_FUNCTION1(IsOdd, INT) // AMB
DECLARE_COCOALIB_FUNCTION1(IsSquare, INT) // JAA
DECLARE_COCOALIB_FUNCTION1(IsPrime, INT) // AMB
DECLARE_COCOALIB_FUNCTION1(IsProbPrime, INT) // AMB
DECLARE_COCOALIB_FUNCTION1(EulerTotient, INT) // JAA
DECLARE_COCOALIB_FUNCTION1(PrimitiveRoot, INT) // JAA
DECLARE_COCOALIBFORC5_FUNCTION1(NextPrime, INT)
DECLARE_COCOALIBFORC5_FUNCTION1(PrevPrime, INT)
// see BuiltinFunctions-CoCoALib DECLARE_COCOALIBFORC5_FUNCTION1(reseed, INT)
DECLARE_COCOALIBFORC5_FUNCTION2(random, INT, INT)
DECLARE_COCOALIBFORC5_FUNCTION1(ContFrac, RAT)
DECLARE_COCOALIBFORC5_FUNCTION1(CFApproximants, RAT)
DECLARE_COCOALIBFORC5_FUNCTION2(BinomialRepr, INT, INT)
DECLARE_COCOALIBFORC5_FUNCTION4(BinomialReprShift, INT, INT, INT, INT)
DECLARE_COCOALIBFORC5_FUNCTION1(NumPartitions, INT)

////// functions on BIGRAT
DECLARE_COCOALIB_FUNCTION2(CFApprox, RAT, RAT) // AMB

////// functions on RINGELEM
DECLARE_COCOALIB_FUNCTION1(CanonicalRepr, RINGELEM) // AMB
DECLARE_COCOALIB_FUNCTION1(ClearDenom, RINGELEM) // AMB
//DECLARE_COCOALIB_FUNCTION1(CommonDenom, RINGELEM) // --> BuiltinFunctions
DECLARE_COCOALIB_FUNCTION1(ContentFreeFactor, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(IndetsIn, RINGELEM) // JAA - TEMPORARY
DECLARE_COCOALIB_FUNCTION1(IsConstant, RINGELEM) // AMB
DECLARE_COCOALIB_FUNCTION1(IsIndet, RINGELEM) // AMB
DECLARE_COCOALIB_FUNCTION1(IsIndetPosPower, RINGELEM) // AMB
DECLARE_COCOALIB_FUNCTION1(IsEvenPoly, RINGELEM) // JAA
DECLARE_COCOALIB_FUNCTION1(IsOddPoly, RINGELEM)  // JAA
DECLARE_COCOALIB_FUNCTION1(IsInvertible, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(IsIrred, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(IsMonomial, RINGELEM) // AMB
DECLARE_COCOALIB_FUNCTION1(IsPthPower, RINGELEM) // JAA
DECLARE_COCOALIB_FUNCTION1(IsZeroDivisor, RINGELEM) // AMB
// DECLARE_COCOALIB_FUNCTION1(LF, RINGELEM) // AMB -- also for ideals
DECLARE_COCOALIB_FUNCTION1(PthRoot, RINGELEM) // JAA
DECLARE_COCOALIB_FUNCTION1(content, RINGELEM) // AMB
DECLARE_COCOALIB_FUNCTION1(FixedDivisor, RINGELEM) // AMB
DECLARE_COCOALIB_FUNCTION1(factor, RINGELEM)
//DECLARE_COCOALIB_FUNCTION1(factor_AlgExtn, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(graeffe, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(graeffe3, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(CoeffHeight, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(RootBound_Birkhoff, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(RootBound_Cauchy, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(RootBound_Lagrange, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(RootBound_LMS, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(RootBound_simple, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(NumTerms, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(SqFreeFactor, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(NumRealRoots, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(SturmSeq, RINGELEM)
DECLARE_COCOALIB_FUNCTION1(monic, RINGELEM) // AMB //if LC(f)==1???
DECLARE_COCOALIB_FUNCTION2(IsDivisible, RINGELEM, RINGELEM)
DECLARE_COCOALIB_FUNCTION2(deriv, RINGELEM, RINGELEM) // AMB
DECLARE_COCOALIB_FUNCTION2(RatReconstructPoly, RINGELEM, INT) // AMB
DECLARE_COCOALIB_FUNCTION2(RingElems, RING, STRING)
// DECLARE_COCOALIB_FUNCTION2(ReadExpr, RING, STRING) --> RingElem(R, s)
// DECLARE_COCOALIB_FUNCTION3(MinPolyQuot, RINGELEM, IDEAL, RINGELEM) to BIFunc
DECLARE_COCOALIB_FUNCTION3(MinPolyQuotDef, RINGELEM, IDEAL, RINGELEM)
DECLARE_COCOALIB_FUNCTION3(MinPolyQuotDefLin, RINGELEM, IDEAL, RINGELEM)
DECLARE_COCOALIB_FUNCTION3(MinPolyQuotElim, RINGELEM, IDEAL, RINGELEM)
DECLARE_COCOALIB_FUNCTION3(MinPolyQuotMat, RINGELEM, IDEAL, RINGELEM)
DECLARE_COCOALIBFORC5_FUNCTION1(IsTerm, RINGELEM)
DECLARE_COCOALIBFORC5_FUNCTION1(monomials, RINGELEM)
DECLARE_COCOALIBFORC5_FUNCTION1(support, RINGELEM)
DECLARE_COCOALIBFORC5_FUNCTION2(CoeffListWRT, RINGELEM, RINGELEM) // AMB+JAA
DECLARE_COCOALIBFORC5_FUNCTION2(CoeffOfTerm, RINGELEM, RINGELEM)
DECLARE_COCOALIBFORC5_FUNCTION2(DensePoly, RING, INT) // AMB
DECLARE_COCOALIBFORC5_FUNCTION2(IsCoprime, RINGELEM, RINGELEM) // AMB
DECLARE_COCOALIBFORC5_FUNCTION2(SmoothFactor, INT, INT)

////// functions on MODULEELEM
DECLARE_COCOALIB_FUNCTION1(FirstNonZero, MODULEELEM) // AMB
DECLARE_COCOALIBFORC5_FUNCTION1(FirstNonZeroPosn, MODULEELEM) // AMB
DECLARE_COCOALIBFORC5_FUNCTION1(LPosn, MODULEELEM) // AMB

////// functions on RING (and PolyRing)
DECLARE_COCOALIB_FUNCTION0(RingQQ)
DECLARE_COCOALIB_FUNCTION0(RingZZ)
DECLARE_COCOALIB_FUNCTION1(BaseRing, RING)
DECLARE_COCOALIB_FUNCTION1(characteristic, RING)
DECLARE_COCOALIB_FUNCTION1(CoeffEmbeddingHom, RING)
DECLARE_COCOALIB_FUNCTION1(CoeffRing, RING)
DECLARE_COCOALIB_FUNCTION1(DefiningIdeal, RING)
DECLARE_COCOALIB_FUNCTION1(EmbeddingHom, RING)
DECLARE_COCOALIB_FUNCTION1(GradingDim, RING) // AMB
DECLARE_COCOALIB_FUNCTION1(GradingMat, RING) // AMB
DECLARE_COCOALIB_FUNCTION1(HVector, RING) // AMB
DECLARE_COCOALIB_FUNCTION1(HilbertPoly, RING) // AMB
DECLARE_COCOALIB_FUNCTION1(RingID, RING)
DECLARE_COCOALIB_FUNCTION1(HasLex, RING)
DECLARE_COCOALIB_FUNCTION1(HasMatrixOrdering, RING)
DECLARE_COCOALIB_FUNCTION1(HasPositiveGrading, RING) // AMB 2019-09
DECLARE_COCOALIB_FUNCTION1(HasStdDegLex, RING)
DECLARE_COCOALIB_FUNCTION1(HasStdDegRevLex, RING)
DECLARE_COCOALIB_FUNCTION1(IsCommutative, RING)
DECLARE_COCOALIB_FUNCTION1(IsField, RING)
DECLARE_COCOALIB_FUNCTION1(IsFiniteField, RING)
DECLARE_COCOALIB_FUNCTION1(IsFractionField, RING)
DECLARE_COCOALIB_FUNCTION1(IsIntegralDomain, RING)
DECLARE_COCOALIB_FUNCTION1(IsOrderedDomain, RING)
DECLARE_COCOALIB_FUNCTION1(IsPolyRing, RING)
DECLARE_COCOALIB_FUNCTION1(IsQQ, RING)
DECLARE_COCOALIB_FUNCTION1(IsQuotientRing, RING)
DECLARE_COCOALIB_FUNCTION1(IsStdGraded, RING)
DECLARE_COCOALIB_FUNCTION1(IsTrueGCDDomain, RING)
DECLARE_COCOALIB_FUNCTION1(IsZZ, RING)
DECLARE_COCOALIB_FUNCTION1(LogCardinality, RING)
DECLARE_COCOALIB_FUNCTION1(NewFractionField, RING)  // AMB
DECLARE_COCOALIB_FUNCTION1(NewZZmod, INT)   // JAA
DECLARE_COCOALIB_FUNCTION2(NewRingFqLog, INT, INT)  // AMB
DECLARE_COCOALIB_FUNCTION2(NewRingFqVec, INT, INT)  // AMB
DECLARE_COCOALIB_FUNCTION1(NumIndets, RING)
DECLARE_COCOALIB_FUNCTION1(one, RING)
DECLARE_COCOALIB_FUNCTION1(OrdMat, RING) // AMB
DECLARE_COCOALIB_FUNCTION1(owner, RINGELEM)
//DECLARE_COCOALIB_FUNCTION1(zero, RING)  // now also for modules
//DECLARE_COCOALIB_FUNCTION1(NewWeylAlgebra, ..)  // AMB
//DECLARE_COCOALIB_FUNCTION2(NewQuotientRing, RING, IDEAL)  // moved to BIF
DECLARE_COCOALIB_FUNCTION1(QQEmbeddingHom, RING)
DECLARE_COCOALIBFORC5_FUNCTION1(RingQQt, INT) // AMB

////// functions for RINGHOM
DECLARE_COCOALIB_FUNCTION1(IdentityHom, RING) // AMB
DECLARE_COCOALIB_FUNCTION1(QuotientingHom, RING) // AMB
DECLARE_COCOALIB_FUNCTION1(codomain, RINGHOM) // AMB
DECLARE_COCOALIB_FUNCTION1(domain, RINGHOM) // AMB
DECLARE_COCOALIB_FUNCTION2(CanonicalHom, RING, RING) // GL
DECLARE_COCOALIB_FUNCTION1(IsInjective, RINGHOM) // JAA
DECLARE_COCOALIB_FUNCTION1(IsSurjective, RINGHOM) // JAA
DECLARE_COCOALIB_FUNCTION1(ker, RINGHOM) // JAA
DECLARE_COCOALIB_FUNCTION1(ker_H, RINGHOM) // JAA
DECLARE_COCOALIB_FUNCTION2(ChainCanonicalHom, RING, RING) // AMB
DECLARE_COCOALIB_FUNCTION2(LiftPolyFromFpxToQQx, RING, RINGELEM) // AMB

////// functions on MAT
//DECLARE_COCOALIB_FUNCTION1(FrobeniusNorm2, MAT) // AMB
//DECLARE_COCOALIB_FUNCTION1(OperatorNorm1, MAT) // AMB
//DECLARE_COCOALIB_FUNCTION1(OperatorNormInfinity, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(IsAntiSymmetric, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(IsDiagonal, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(IsSymmetric, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(IsTermOrdering, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(LinKer, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(NumCols, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(NumRows, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(PseudoInverse, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(adj, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(det, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(DetDirect, MAT) // JAA
DECLARE_COCOALIB_FUNCTION1(inverse, MAT) // AMB
DECLARE_COCOALIB_FUNCTION1(RowReducedForm, MAT) // JAA
DECLARE_COCOALIB_FUNCTION1(rk, MAT) // AMB
DECLARE_COCOALIB_FUNCTION2(ConcatAntiDiag, MAT, MAT) // AMB
DECLARE_COCOALIB_FUNCTION2(IdealOfPoints, RING, MAT) // JAA
DECLARE_COCOALIB_FUNCTION2(IdealOfProjectivePoints, RING, MAT) // AMB
DECLARE_COCOALIB_FUNCTION2(LinSolve, MAT, MAT) // JAA
DECLARE_COCOALIB_FUNCTION2(ConcatDiag, MAT, MAT) // AMB
DECLARE_COCOALIB_FUNCTION2(ConcatHor, MAT, MAT) // AMB
DECLARE_COCOALIB_FUNCTION2(ConcatVer, MAT, MAT) // AMB
DECLARE_COCOALIB_FUNCTION2(TensorMat, MAT, MAT) // AMB
DECLARE_COCOALIB_FUNCTION4(BlockMat2x2, MAT, MAT, MAT, MAT) // AMB
DECLARE_COCOALIBFORC5_FUNCTION1(LexMat, INT)
DECLARE_COCOALIBFORC5_FUNCTION1(RevLexMat, INT)
DECLARE_COCOALIBFORC5_FUNCTION1(StdDegLexMat, INT)
DECLARE_COCOALIBFORC5_FUNCTION1(StdDegRevLexMat, INT)
DECLARE_COCOALIBFORC5_FUNCTION1(XelMat, INT)
DECLARE_COCOALIBFORC5_FUNCTION1(transposed, MAT)
DECLARE_COCOALIBFORC5_FUNCTION2(GetCol, MAT, INT)
DECLARE_COCOALIBFORC5_FUNCTION2(GetRow, MAT, INT)
DECLARE_COCOALIBFORC5_FUNCTION2(IdentityMat, RING, INT)
DECLARE_COCOALIBFORC5_FUNCTION3(NewDenseMat, RING, INT, INT)
DECLARE_COCOALIBFORC5_FUNCTION3(ZeroMat, RING, INT, INT)
//DECLARE_COCOALIBFORC5_FUNCTION4(FilledMat, RING, INT, INT, RINGELEM) // removed from CoCoALib
DECLARE_COCOALIBFORC5_FUNCTION3(ClosePassingPoly, RING, MAT, MAT)

////// functions on IDEAL
DECLARE_COCOALIB_FUNCTION1(AlexanderDual, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION1(AreGensMonomial, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION1(AreGensSqFreeMonomial, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION1(DenSigma, IDEAL) // AMB 2018-03
DECLARE_COCOALIB_FUNCTION1(DimQuot, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION1(GBasisByHomog, IDEAL) // AMB 2018-08
DECLARE_COCOALIB_FUNCTION1(GBasisRealSolve, IDEAL)
DECLARE_COCOALIB_FUNCTION1(GBasisSelfSatCore, IDEAL)
DECLARE_COCOALIB_FUNCTION1(HasGBasis, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION1(HilbertSeriesQuot, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION1(IdealOfGBasis, IDEAL)  // AMB 2017-02
DECLARE_COCOALIB_FUNCTION1(IdealOfMinGens, IDEAL) // AMB 2017-02
DECLARE_COCOALIB_FUNCTION1(IsMaximal, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION1(IsPrimary, IDEAL) // AMB 2018-03
DECLARE_COCOALIB_FUNCTION1(IsRadical_tmp, IDEAL) // AMB 2018-03
DECLARE_COCOALIB_FUNCTION1(IsZeroDim, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION1(MayerVietorisTreeN1, IDEAL)
DECLARE_COCOALIB_FUNCTION1(MultiplicityQuot, IDEAL) // AMB
//DECLARE_COCOALIB_FUNCTION1(NumGens, IDEAL) now also for modules 2019-03
DECLARE_COCOALIB_FUNCTION1(PrimaryDecomposition, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION1(ShapeLemma, IDEAL) // AMB 2018-02
//DECLARE_COCOALIB_FUNCTION1(radical_0dim, IDEAL) // AMB 2018-03 -- rm 2019-10
DECLARE_COCOALIB_FUNCTION1(radical_tmp, IDEAL) // AMB 2019-10
DECLARE_COCOALIB_FUNCTION2(IsSigmaGoodPrime, INT, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION2(MinPowerInIdeal, RINGELEM, IDEAL) // JAA
DECLARE_COCOALIB_FUNCTION2(NF, RINGELEM, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION2(colon, IDEAL, IDEAL) // AMB
DECLARE_COCOALIB_FUNCTION2(intersect, IDEAL, IDEAL) // AMB
//DECLARE_COCOALIB_FUNCTION1(GBasis, IDEAL) now also for modules
//DECLARE_COCOALIB_FUNCTION1(MinGens, IDEAL) now also for modules
//DECLARE_COCOALIB_FUNCTION1(gens, IDEAL)   now also for modules
//DECLARE_COCOALIB_FUNCTION2(IsContained, IDEAL, IDEAL) now also for modules
//DECLARE_COCOALIB_FUNCTION2(IsElem, RINGELEM, IDEAL) now also for modules
DECLARE_COCOALIBFORC5_FUNCTION1(HilbertNumQuot, IDEAL) // AMB
DECLARE_COCOALIBFORC5_FUNCTION1(JanetBasis, IDEAL)
DECLARE_COCOALIBFORC5_FUNCTION1(QuotientBasis, IDEAL)
DECLARE_COCOALIBFORC5_FUNCTION1(QuotientBasisSorted, IDEAL)

////// functions on MODULE
DECLARE_COCOALIB_FUNCTION1(SubmoduleOfMinGens, MODULE) // AMB 2017-09
DECLARE_COCOALIBFORC5_FUNCTION2(SubmoduleCols, MODULE, MAT) // AMB
DECLARE_COCOALIBFORC5_FUNCTION2(SubmoduleRows, MODULE, MAT) // AMB

////// UTILS
DECLARE_COCOALIBFORC5_FUNCTION0(CpuTime)
DECLARE_COCOALIBFORC5_FUNCTION0(date)
DECLARE_COCOALIBFORC5_FUNCTION0(TimeOfDay)  // time is a keyword (unused)
DECLARE_COCOALIB_FUNCTION0(VerbosityLevel)
// DECLARE_COCOALIB_FUNCTION0(NewSymbol)
// DECLARE_COCOALIB_FUNCTION1(NewSymbols, INT)

} // namespace AST
} // namespace CoCoA
