#ifndef CoCoA_NumTheory_factor_H
#define CoCoA_NumTheory_factor_H

//   Copyright (c)  2009,2012  John Abbott

//   This file is part of the source of CoCoALib, the CoCoA Library.

//   CoCoALib is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.

//   CoCoALib is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.

//   You should have received a copy of the GNU General Public License
//   along with CoCoALib.  If not, see <http://www.gnu.org/licenses/>.
//   -------------------------------------------------------------------------


#include "CoCoA/factorization.H"

namespace CoCoA
{
  
  class MachineInt; // fwd decl -- defined in MachineInt.H


  long radical(const MachineInt& n);
  BigInt radical(const BigInt& N);

  factorization<long>   SmoothFactor(const MachineInt& N, const MachineInt& TrialLimit);
  factorization<BigInt> SmoothFactor(const BigInt& N,     const MachineInt& TrialLimit);
  factorization<BigInt> SmoothFactor(const BigInt& N,     const BigInt& TrialLimit);

  factorization<long>   factor(const MachineInt& N);
  factorization<BigInt> factor(const BigInt& N);

  class PollardRhoSeq
  {
  public:
    PollardRhoSeq(const BigInt& N, long StartVal, long incr);
    void myAdvance(long n); // advance by AT LEAST n iters
    friend bool IsEnded(const PollardRhoSeq& PRS);
    friend const BigInt& GetFactor(const PollardRhoSeq& PRS);
    friend long GetNumIters(const PollardRhoSeq& PRS);
    friend std::ostream& operator<<(std::ostream& out, const PollardRhoSeq& PRS);
  private: // data members
    long myNumIters; // counts how many steps
    long myAnchorIterNum;
    BigInt myAnchorVal;
    BigInt myN;
    BigInt myCurrVal;
    BigInt myGCD;
    long myStartVal;
    long myIncr;
    long myBlockSize; // how many 
  };

  bool IsEnded(const PollardRhoSeq& PRS);
  const BigInt& GetFactor(const PollardRhoSeq& PRS);
  long GetNumIters(const PollardRhoSeq& PRS);
  std::ostream& operator<<(std::ostream& out, const PollardRhoSeq& PRS);


  BigInt SumOfFactors(const MachineInt& N, long k=1); // sum of k-th powers of all factors
//  BigInt SumOfFactors(const BigInt& N, long k=1);

  long SmallestNonDivisor(const MachineInt& N);
  long SmallestNonDivisor(const BigInt& N);

  bool IsSqFree(const MachineInt& n);
  bool3 IsSqFree(BigInt N);

  long FactorMultiplicity(const MachineInt& p, const MachineInt& n);
  long FactorMultiplicity(const MachineInt& p, BigInt N);
  long FactorMultiplicity(const BigInt& p, BigInt N);

} // end of namespace CoCoA



// RCS header/log in the next few lines
// $Header: /Volumes/Home_1/cocoa/cvs-repository/CoCoALib-0.99/include/CoCoA/NumTheory-factor.H,v 1.2 2019/09/16 17:31:28 abbott Exp $
// $Log: NumTheory-factor.H,v $
// Revision 1.2  2019/09/16 17:31:28  abbott
// Summary: Added PollardRhoSeq
//
// Revision 1.1  2019/03/18 11:24:19  abbott
// Summary: Split NumTheory into several smaller files
//
//

#endif
