// Copyright (c) 2012  Anna M. Bigatti
// This file is part of the CoCoALib suite of examples.
// You are free to use any part of this example in your own programs.

#include "CoCoA/library.H"
using namespace CoCoA;
using namespace std;

//----------------------------------------------------------------------
const string ShortDescription =
  "This is an example showing some basic C++  \n"
  "you need to know to use CoCoALib           \n";

const string LongDescription =
  "printing, vector, ... \n";
//----------------------------------------------------------------------

namespace CoCoA
{

  void program()
  {
    GlobalManager CoCoAFoundations;

    //-- PRINTING -------------------------------------------------
    // cout is the "print" statement
    // endl is "end of line"
    cout << ShortDescription << endl;
    // flush is to force printing
    cout << "flush: to print *NOW*" << flush;
    cout << "... otherwise \"cout\" waits for a convenient time" << flush;
    cout << endl;  // flush + newline

    //-- VECTOR -------------------------------------------------
    std::vector<long> VecLong1; // empty vector of longs -- CoCoALib uses "long"
    std::vector<long> VecLong2(4, 100); // --> [100, 100, 100, 100]
    // in C++ there is no pretty way to initialize a vector
    // in CoCoALib there is this way (up to 4 args of the same type)
    std::vector<int> VecInt3 = CoCoAVector(3,4,5); // --> [3, 4, 5]

    // equiv to cocoa first(VecLong3, len(VecLong3)-1)
    cout << vector<int>(VecInt3.begin(), VecInt3.end()-1) << endl;

    // equiv to cocoa first(VecLong3, 2)
    cout << vector<int>(VecInt3.begin(), VecInt3.begin()+2) << endl;

    // equiv to cocoa first(VecLong3)
    cout << VecInt3.front() << endl;
    
    // equiv to cocoa last(VecLong3)
    cout << VecInt3.back() << endl;
    


    //  push_back, reserve, 

    // what else?
  }

} // end of namespace CoCoA

//----------------------------------------------------------------------
// Use main() to handle any uncaught exceptions and warn the user about them.
int main()
{
  try
  {
    CoCoA::program();
    return 0;
  }
  catch (const CoCoA::ErrorInfo& err)
  {
    cerr << "***ERROR***  UNCAUGHT CoCoA error";
    ANNOUNCE(cerr, err);
  }
  catch (const std::exception& exc)
  {
    cerr << "***ERROR***  UNCAUGHT std::exception: " << exc.what() << endl;
  }
  catch(...)
  {
    cerr << "***ERROR***  UNCAUGHT UNKNOWN EXCEPTION" << endl;
  }

  CoCoA::BuildInfo::PrintAll(cerr);
  return 1;
}

//----------------------------------------------------------------------
// RCS header/log in the next few lines
// $Header: /Volumes/Home_1/cocoa/cvs-repository/CoCoALib-0.99/examples/ex-c++.C,v 1.5 2016/11/18 07:36:56 bigatti Exp $
// $Log: ex-c++.C,v $
// Revision 1.5  2016/11/18 07:36:56  bigatti
// -- more examples
//
// Revision 1.4  2015/06/29 15:51:44  bigatti
// -- code in namespace CoCoA
//
// Revision 1.3  2013/05/31 15:10:27  bigatti
// -- just a little more...
//
// Revision 1.2  2012/05/11 10:13:21  bigatti
// -- moved semicolon for bug in my html-index code
//
// Revision 1.1  2012/05/11 10:07:57  bigatti
// first import
//
// Revision 1.5  2010/12/17 16:07:54  abbott
// Ensured that all i/o in examples is on standard C++ streams
// (rather than GlobalInput(), etc).
//
// Revision 1.4  2008/10/07 12:12:54  abbott
// Removed useless commented out #include.
//
// Revision 1.3  2007/05/31 16:06:16  bigatti
// -- removed previous unwanted checked-in version
//
// Revision 1.1.1.1  2007/03/09 15:16:11  abbott
// Imported files
//
// Revision 1.9  2007/03/07 11:51:40  bigatti
// -- improved test alignment
//
// Revision 1.8  2007/03/03 14:15:45  bigatti
// -- "foundations" renamed into "GlobalManager"
//
// Revision 1.7  2007/03/02 17:46:40  bigatti
// -- unique RingZ and RingQ
// -- requires foundations.H ;  foundations blah;  (thik of a better name)
//
// Revision 1.6  2007/03/02 10:47:53  cocoa
// First stage of RingZ modifications -- tests do not compile currently, Anna will fix this.
//
// Revision 1.5  2007/03/01 13:52:59  bigatti
// -- minor: fixed typo
//
// Revision 1.4  2007/02/28 15:15:56  bigatti
// -- minor: removed quotes in description
//
// Revision 1.3  2007/02/12 16:27:43  bigatti
// -- added strings ShortDescription and LongDescription for indexing
//
// Revision 1.2  2007/02/10 18:44:03  cocoa
// Added "const" twice to each test and example.
// Eliminated dependency on io.H in several files.
// Improved BuildInfo, and added an example about how to use it.
// Some other minor cleaning.
//
// Revision 1.1.1.1  2006/05/30 11:39:36  cocoa
// Imported files
//
// Revision 1.1  2006/03/12 21:28:34  cocoa
// Major check in after many changes
//
