
/*
 * CINELERRA
 * Copyright (C) 2008 Adam Williams <broadcast at earthling dot net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include "vtrack.h"
#include "recordablevtracks.h"
#include "tracks.h"

// This is only used for menu effects so use playable tracks instead.

RecordableVTracks::RecordableVTracks(Tracks *tracks)
 : ArrayList<VTrack*>()
{
	Track *current_track;
	for(current_track = tracks->first; 
		current_track; 
		current_track = current_track->next)
	{
		if(current_track->record && current_track->data_type == TRACK_VIDEO) 
			append((VTrack*)current_track);
	}
}
