/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFMEDIA_KEYBINDINGS_H__
#define __XFMEDIA_KEYBINDINGS_H__

#include <glib.h>
#include <gdk/gdk.h>

G_BEGIN_DECLS

typedef struct
{
	gchar *keybind_id;
	guint keyval;
	GdkModifierType modmask;
} XfmediaKeybinding;

void xfmedia_keybindings_init();
void xfmedia_keybindings_cleanup();

gboolean xfmedia_keybindings_load(const gchar *file);
gboolean xfmedia_keybindings_save(const gchar *file);

G_CONST_RETURN gchar *xfmedia_keybindings_lookup(guint keyval, GdkModifierType modmask);
void xfmedia_keybindings_modify(const gchar *function, guint keyval, GdkModifierType modmask);

GList *xfmedia_keybindings_get_list();
void xfmedia_keybindings_free_list(GList *list);


G_END_DECLS

#endif
