/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <gtk/gtk.h>

#include <libxfce4util/libxfce4util.h>

#include "equaliser.h"
#include "xfmedia-common.h"
#include "mainwin.h"
#include <xfmedia/xfmedia-settings.h>

#define EQ_BANDS (XINE_PARAM_EQ_16000HZ - XINE_PARAM_EQ_30HZ + 1)

static const gchar *eq_bands[EQ_BANDS] =
{
    "30 Hz",
    "60 Hz",
    "120 Hz",
    "250 Hz",
    "500 Hz",
    "1 kHz",
    "2 kHz",
    "4 kHz",
    "8 kHz",
    "16 kHz"
};

/*
static gint eq_cache[EQ_BANDS];

static inline gboolean
eq_cache_is_zeros()
{
    gint i;
    
    for(i = 0; i < EQ_BANDS; i++) {
        if(eq_cache[i] != 0)
            return FALSE;
    }
    
    return TRUE;
}
*/

#if 0
static void
preamp_value_changed_cb(GtkRange *range, gpointer user_data)
{
    XfmediaMainwin *mwin = user_data;
    
    xfmedia_xine_set_param(mwin->xfx, XINE_PARAM_AUDIO_AMP_LEVEL,
            (gint)gtk_range_get_value(range));
}
#endif

static void
equaliser_value_changed_cb(GtkRange *range, gpointer user_data)
{
    XfmediaMainwin *mwin = user_data;
    gint idx, value;
    gchar setting[128];
    
    idx = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(range),
            "xfmedia-eq-band-id"));
    value = (gint)gtk_range_get_value(range);
    
    DBG("setting band %d to %d", idx, value+100);
    xfmedia_xine_set_param(mwin->xfx, idx+XINE_PARAM_EQ_30HZ, value+100);
    /*eq_cache[idx] = value;*/
    
    g_snprintf(setting, 128, "/xfmedia/general/eq_band_%d", idx);
    xfmedia_settings_set_int(setting, value);
    
    /*xfmedia_xine_set_param(mwin->xfx, XINE_PARAM_AUDIO_AMP_MUTE, 0);
    if(eq_cache_is_zeros()) {
        DBG("setting preamp to 100");
        //xfmedia_xine_set_param(mwin->xfx, XINE_PARAM_AUDIO_AMP_LEVEL, 100);
        //xfmedia_xine_set_param(mwin->xfx, XINE_PARAM_AUDIO_AMP_MUTE, 1);
    } else {
        DBG("setting preamp to 200");
        //xfmedia_xine_set_param(mwin->xfx, XINE_PARAM_AUDIO_AMP_LEVEL, 400);
        //xfmedia_xine_set_param(mwin->xfx, XINE_PARAM_AUDIO_AMP_MUTE, 0);
    }*/
}

static void
equaliser_zero_winptr(GtkWidget **win)
{
    if(win)
        *win = NULL;
}

void
xfmedia_equaliser_show(XfmediaMainwin *mwin)
{
    static GtkWidget *win = NULL;
    GtkWidget *topvbox, *hbox, *vbox, *slider, *lbl, /**sep,*/ *btn;
    gint i;
    GtkSizeGroup *sg;
    
    if(win) {
        gtk_window_present(GTK_WINDOW(win));
        return;
    }
    
    win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(win), _("Equalizer"));
    gtk_window_set_transient_for(GTK_WINDOW(win), GTK_WINDOW(mwin->window));
    gtk_container_set_border_width(GTK_CONTAINER(win), BORDER);
    gtk_widget_set_size_request(win, -1, 350);
    g_signal_connect_swapped(G_OBJECT(win), "destroy",
            G_CALLBACK(equaliser_zero_winptr), &win);
    
    topvbox = gtk_vbox_new(FALSE, BORDER);
    gtk_widget_show(topvbox);
    gtk_container_add(GTK_CONTAINER(win), topvbox);
    
    /* FIXME: REMOVE ME LATER */
    
    lbl = gtk_label_new("Yes, I know this thing doesn't work right.  Don't file bugs yet.");
    gtk_widget_show(lbl);
    gtk_box_pack_start(GTK_BOX(topvbox), lbl, FALSE, FALSE, 0);
    
    /* FIXME: END REMOVE ME LATER */
    
    hbox = gtk_hbox_new(FALSE, BORDER);
    gtk_widget_show(hbox);
    gtk_box_pack_start(GTK_BOX(topvbox), hbox, TRUE, TRUE, 0);
    
#if 0
    /* preamp */
    
    vbox = gtk_vbox_new(FALSE, BORDER/4);
    gtk_widget_show(vbox);
    gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 0);
    
    slider = gtk_vscale_new_with_range(0.0, 1000.0, 1);
    gtk_scale_set_digits(GTK_SCALE(slider), 0);
    gtk_scale_set_value_pos(GTK_SCALE(slider), GTK_POS_TOP);
    gtk_scale_set_draw_value(GTK_SCALE(slider), TRUE);
    gtk_range_set_inverted(GTK_RANGE(slider), TRUE);
    gtk_range_set_update_policy(GTK_RANGE(slider), GTK_UPDATE_DISCONTINUOUS);
    gtk_range_set_value(GTK_RANGE(slider),
            xfmedia_xine_get_param(mwin->xfx, XINE_PARAM_AUDIO_AMP_LEVEL));
    gtk_widget_show(slider);
    gtk_box_pack_start(GTK_BOX(vbox), slider, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(slider), "value-changed",
            G_CALLBACK(preamp_value_changed_cb), mwin);
    
    lbl = gtk_label_new(_("Preamp"));
    gtk_widget_show(lbl);
    gtk_box_pack_start(GTK_BOX(vbox), lbl, FALSE, FALSE, 0);
    
    /* separator */
    sep = gtk_alignment_new(0.5, 0.5, 1.0, 1.0);
    gtk_widget_set_size_request(sep, 25, 1);
    gtk_widget_show(sep);
    gtk_box_pack_start(GTK_BOX(hbox), sep, FALSE, FALSE, 0);
#endif
    
    /* eq bands */
    sg = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);
    for(i = 0; i < EQ_BANDS; i++) {
        vbox = gtk_vbox_new(FALSE, BORDER/4);
        gtk_widget_show(vbox);
        gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 0);
        gtk_size_group_add_widget(sg, vbox);
        
        slider = gtk_vscale_new_with_range(-99.0, 100.0, 1);
        gtk_scale_set_digits(GTK_SCALE(slider), 0);
        gtk_scale_set_value_pos(GTK_SCALE(slider), GTK_POS_TOP);
        gtk_scale_set_draw_value(GTK_SCALE(slider), TRUE);
        gtk_range_set_inverted(GTK_RANGE(slider), TRUE);
        gtk_range_set_update_policy(GTK_RANGE(slider), GTK_UPDATE_DISCONTINUOUS);
        DBG("init slider %d to %d", i, xfmedia_xine_get_param(mwin->xfx, i+XINE_PARAM_EQ_30HZ)-100);
        gtk_range_set_value(GTK_RANGE(slider),
                xfmedia_xine_get_param(mwin->xfx, i+XINE_PARAM_EQ_30HZ)-100);
        gtk_widget_show(slider);
        gtk_box_pack_start(GTK_BOX(vbox), slider, TRUE, TRUE, 0);
        g_object_set_data(G_OBJECT(slider), "xfmedia-eq-band-id",
                GINT_TO_POINTER(i));
        g_signal_connect(G_OBJECT(slider), "value-changed",
                G_CALLBACK(equaliser_value_changed_cb), mwin);
        
        lbl = gtk_label_new(eq_bands[i]);
        gtk_widget_show(lbl);
        gtk_box_pack_start(GTK_BOX(vbox), lbl, FALSE, FALSE, 0);
    }
    
    hbox = gtk_hbox_new(FALSE, BORDER);
    gtk_widget_show(hbox);
    gtk_box_pack_end(GTK_BOX(topvbox), hbox, FALSE, FALSE, 0);
    
    btn = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
    gtk_widget_show(btn);
    gtk_box_pack_end(GTK_BOX(hbox), btn, FALSE, FALSE, 0);
    g_signal_connect_swapped(G_OBJECT(btn), "clicked",
            G_CALLBACK(gtk_widget_destroy), win);
    
    gtk_widget_show(win);
    gtk_widget_set_size_request(win, -1, -1);
}

void
xfmedia_equaliser_init(XfmediaMainwin *mwin)
{
    gint i, value/*, preamp_val = 100*/;
    gchar setting[128];
    
    for(i = 0; i < EQ_BANDS; i++) {
        g_snprintf(setting, 128, "/xfmedia/general/eq_band_%d", i);
        value = xfmedia_settings_get_int(setting);
        if(value < -99) {
            value = -99;
            xfmedia_settings_set_int(setting, -99);
        } else if(value > 100) {
            value = 100;
            xfmedia_settings_set_int(setting, 100);
        }
        DBG("init band %d to %d", i, value+100);
        xfmedia_xine_set_param(mwin->xfx, i+XINE_PARAM_EQ_30HZ, value+100);
        /*eq_cache[i] = value;*/
        /*if(value != 0)
            preamp_val = 200;*/
    }
    
    /*
    //xfmedia_xine_set_param(mwin->xfx, XINE_PARAM_AUDIO_AMP_MUTE, 0);
    DBG("setting preamp to %d", preamp_val);
    //xfmedia_xine_set_param(mwin->xfx, XINE_PARAM_AUDIO_AMP_LEVEL, preamp_val);
    */
}
