
#!/bin/bash
#
# Copyright (C) 2018 by Michael Olbrich <m.olbrich@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# WARNING: This file is generated with 'update_spdx.py' from
# 'licenses.json' and 'exceptions.json'.
#
# The source files can be found in the SPDX data repository:
# https://github.com/spdx/license-list-data.git

ptxd_make_spdx() {
    license="${1}"

    case "${license}" in
	0BSD) ;;
	AAL) osi="true" ;;
	Abstyles) ;;
	Adobe-2006) ;;
	Adobe-Glyph) ;;
	ADSL) ;;
	AFL-1.1) osi="true" ;;
	AFL-1.2) osi="true" ;;
	AFL-2.0) osi="true" ;;
	AFL-2.1) osi="true" ;;
	AFL-3.0) osi="true" ;;
	Afmparse) ;;
	AGPL-1.0) ;;
	AGPL-3.0-only) osi="true" ;;
	AGPL-3.0-or-later) osi="true" ;;
	Aladdin) ;;
	AMDPLPA) ;;
	AML) ;;
	AMPAS) ;;
	ANTLR-PD) ;;
	Apache-1.0) ;;
	Apache-1.1) osi="true" ;;
	Apache-2.0) osi="true" ;;
	APAFML) ;;
	APL-1.0) osi="true" ;;
	APSL-1.0) osi="true" ;;
	APSL-1.1) osi="true" ;;
	APSL-1.2) osi="true" ;;
	APSL-2.0) osi="true" ;;
	Artistic-1.0-cl8) osi="true" ;;
	Artistic-1.0-Perl) osi="true" ;;
	Artistic-1.0) osi="true" ;;
	Artistic-2.0) osi="true" ;;
	Bahyph) ;;
	Barr) ;;
	Beerware) ;;
	BitTorrent-1.0) ;;
	BitTorrent-1.1) ;;
	Borceux) ;;
	BSD-1-Clause) ;;
	BSD-2-Clause-FreeBSD) ;;
	BSD-2-Clause-NetBSD) ;;
	BSD-2-Clause-Patent) osi="true" ;;
	BSD-2-Clause) osi="true" ;;
	BSD-3-Clause-Attribution) ;;
	BSD-3-Clause-Clear) ;;
	BSD-3-Clause-LBNL) ;;
	BSD-3-Clause-No-Nuclear-License-2014) ;;
	BSD-3-Clause-No-Nuclear-License) ;;
	BSD-3-Clause-No-Nuclear-Warranty) ;;
	BSD-3-Clause) osi="true" ;;
	BSD-4-Clause-UC) ;;
	BSD-4-Clause) ;;
	BSD-Protection) ;;
	BSD-Source-Code) ;;
	BSL-1.0) osi="true" ;;
	bzip2-1.0.5) ;;
	bzip2-1.0.6) ;;
	Caldera) ;;
	CATOSL-1.1) osi="true" ;;
	CC-BY-1.0) ;;
	CC-BY-2.0) ;;
	CC-BY-2.5) ;;
	CC-BY-3.0) ;;
	CC-BY-4.0) ;;
	CC-BY-NC-1.0) ;;
	CC-BY-NC-2.0) ;;
	CC-BY-NC-2.5) ;;
	CC-BY-NC-3.0) ;;
	CC-BY-NC-4.0) ;;
	CC-BY-NC-ND-1.0) ;;
	CC-BY-NC-ND-2.0) ;;
	CC-BY-NC-ND-2.5) ;;
	CC-BY-NC-ND-3.0) ;;
	CC-BY-NC-ND-4.0) ;;
	CC-BY-NC-SA-1.0) ;;
	CC-BY-NC-SA-2.0) ;;
	CC-BY-NC-SA-2.5) ;;
	CC-BY-NC-SA-3.0) ;;
	CC-BY-NC-SA-4.0) ;;
	CC-BY-ND-1.0) ;;
	CC-BY-ND-2.0) ;;
	CC-BY-ND-2.5) ;;
	CC-BY-ND-3.0) ;;
	CC-BY-ND-4.0) ;;
	CC-BY-SA-1.0) ;;
	CC-BY-SA-2.0) ;;
	CC-BY-SA-2.5) ;;
	CC-BY-SA-3.0) ;;
	CC-BY-SA-4.0) ;;
	CC0-1.0) ;;
	CDDL-1.0) osi="true" ;;
	CDDL-1.1) ;;
	CDLA-Permissive-1.0) ;;
	CDLA-Sharing-1.0) ;;
	CECILL-1.0) ;;
	CECILL-1.1) ;;
	CECILL-2.0) ;;
	CECILL-2.1) osi="true" ;;
	CECILL-B) ;;
	CECILL-C) ;;
	ClArtistic) ;;
	CNRI-Jython) ;;
	CNRI-Python-GPL-Compatible) ;;
	CNRI-Python) osi="true" ;;
	Condor-1.1) ;;
	CPAL-1.0) osi="true" ;;
	CPL-1.0) osi="true" ;;
	CPOL-1.02) ;;
	Crossword) ;;
	CrystalStacker) ;;
	CUA-OPL-1.0) osi="true" ;;
	Cube) ;;
	curl) ;;
	D-FSL-1.0) ;;
	diffmark) ;;
	DOC) ;;
	Dotseqn) ;;
	DSDP) ;;
	dvipdfm) ;;
	ECL-1.0) osi="true" ;;
	ECL-2.0) osi="true" ;;
	EFL-1.0) osi="true" ;;
	EFL-2.0) osi="true" ;;
	eGenix) ;;
	Entessa) osi="true" ;;
	EPL-1.0) osi="true" ;;
	EPL-2.0) osi="true" ;;
	ErlPL-1.1) ;;
	EUDatagrid) osi="true" ;;
	EUPL-1.0) ;;
	EUPL-1.1) osi="true" ;;
	EUPL-1.2) osi="true" ;;
	Eurosym) ;;
	Fair) osi="true" ;;
	Frameworx-1.0) osi="true" ;;
	FreeImage) ;;
	FSFAP) ;;
	FSFUL) ;;
	FSFULLR) ;;
	FTL) ;;
	GFDL-1.1-only) ;;
	GFDL-1.1-or-later) ;;
	GFDL-1.2-only) ;;
	GFDL-1.2-or-later) ;;
	GFDL-1.3-only) ;;
	GFDL-1.3-or-later) ;;
	Giftware) ;;
	GL2PS) ;;
	Glide) ;;
	Glulxe) ;;
	gnuplot) ;;
	GPL-1.0-only) ;;
	GPL-1.0-or-later) ;;
	GPL-2.0-only) osi="true" ;;
	GPL-2.0-or-later) osi="true" ;;
	GPL-3.0-only) osi="true" ;;
	GPL-3.0-or-later) osi="true" ;;
	gSOAP-1.3b) ;;
	HaskellReport) ;;
	HPND) osi="true" ;;
	IBM-pibs) ;;
	ICU) ;;
	IJG) ;;
	ImageMagick) ;;
	iMatix) ;;
	Imlib2) ;;
	Info-ZIP) ;;
	Intel-ACPI) ;;
	Intel) osi="true" ;;
	Interbase-1.0) ;;
	IPA) osi="true" ;;
	IPL-1.0) osi="true" ;;
	ISC) osi="true" ;;
	JasPer-2.0) ;;
	JSON) ;;
	LAL-1.2) ;;
	LAL-1.3) ;;
	Latex2e) ;;
	Leptonica) ;;
	LGPL-2.0-only) osi="true" ;;
	LGPL-2.0-or-later) osi="true" ;;
	LGPL-2.1-only) osi="true" ;;
	LGPL-2.1-or-later) osi="true" ;;
	LGPL-3.0-only) osi="true" ;;
	LGPL-3.0-or-later) osi="true" ;;
	LGPLLR) ;;
	Libpng) ;;
	libtiff) ;;
	LiLiQ-P-1.1) osi="true" ;;
	LiLiQ-R-1.1) osi="true" ;;
	LiLiQ-Rplus-1.1) osi="true" ;;
	LPL-1.0) osi="true" ;;
	LPL-1.02) osi="true" ;;
	LPPL-1.0) ;;
	LPPL-1.1) ;;
	LPPL-1.2) ;;
	LPPL-1.3a) ;;
	LPPL-1.3c) osi="true" ;;
	MakeIndex) ;;
	MirOS) osi="true" ;;
	MIT-advertising) ;;
	MIT-CMU) ;;
	MIT-enna) ;;
	MIT-feh) ;;
	MIT) osi="true" ;;
	MITNFA) ;;
	Motosoto) osi="true" ;;
	mpich2) ;;
	MPL-1.0) osi="true" ;;
	MPL-1.1) osi="true" ;;
	MPL-2.0-no-copyleft-exception) osi="true" ;;
	MPL-2.0) osi="true" ;;
	MS-PL) osi="true" ;;
	MS-RL) osi="true" ;;
	MTLL) ;;
	Multics) osi="true" ;;
	Mup) ;;
	NASA-1.3) osi="true" ;;
	Naumen) osi="true" ;;
	NBPL-1.0) ;;
	NCSA) osi="true" ;;
	Net-SNMP) ;;
	NetCDF) ;;
	Newsletr) ;;
	NGPL) osi="true" ;;
	NLOD-1.0) ;;
	NLPL) ;;
	Nokia) osi="true" ;;
	NOSL) ;;
	Noweb) ;;
	NPL-1.0) ;;
	NPL-1.1) ;;
	NPOSL-3.0) osi="true" ;;
	NRL) ;;
	NTP) osi="true" ;;
	OCCT-PL) ;;
	OCLC-2.0) osi="true" ;;
	ODbL-1.0) ;;
	OFL-1.0) ;;
	OFL-1.1) osi="true" ;;
	OGTSL) osi="true" ;;
	OLDAP-1.1) ;;
	OLDAP-1.2) ;;
	OLDAP-1.3) ;;
	OLDAP-1.4) ;;
	OLDAP-2.0.1) ;;
	OLDAP-2.0) ;;
	OLDAP-2.1) ;;
	OLDAP-2.2.1) ;;
	OLDAP-2.2.2) ;;
	OLDAP-2.2) ;;
	OLDAP-2.3) ;;
	OLDAP-2.4) ;;
	OLDAP-2.5) ;;
	OLDAP-2.6) ;;
	OLDAP-2.7) ;;
	OLDAP-2.8) ;;
	OML) ;;
	OpenSSL) ;;
	OPL-1.0) ;;
	OSET-PL-2.1) osi="true" ;;
	OSL-1.0) osi="true" ;;
	OSL-1.1) ;;
	OSL-2.0) osi="true" ;;
	OSL-2.1) osi="true" ;;
	OSL-3.0) osi="true" ;;
	PDDL-1.0) ;;
	PHP-3.0) osi="true" ;;
	PHP-3.01) ;;
	Plexus) ;;
	PostgreSQL) osi="true" ;;
	psfrag) ;;
	psutils) ;;
	Python-2.0) osi="true" ;;
	Qhull) ;;
	QPL-1.0) osi="true" ;;
	Rdisc) ;;
	RHeCos-1.1) ;;
	RPL-1.1) osi="true" ;;
	RPL-1.5) osi="true" ;;
	RPSL-1.0) osi="true" ;;
	RSA-MD) ;;
	RSCPL) osi="true" ;;
	Ruby) ;;
	SAX-PD) ;;
	Saxpath) ;;
	SCEA) ;;
	Sendmail) ;;
	SGI-B-1.0) ;;
	SGI-B-1.1) ;;
	SGI-B-2.0) ;;
	SimPL-2.0) osi="true" ;;
	SISSL-1.2) ;;
	SISSL) osi="true" ;;
	Sleepycat) osi="true" ;;
	SMLNJ) ;;
	SMPPL) ;;
	SNIA) ;;
	Spencer-86) ;;
	Spencer-94) ;;
	Spencer-99) ;;
	SPL-1.0) osi="true" ;;
	SugarCRM-1.1.3) ;;
	SWL) ;;
	TCL) ;;
	TCP-wrappers) ;;
	TMate) ;;
	TORQUE-1.1) ;;
	TOSL) ;;
	Unicode-DFS-2015) ;;
	Unicode-DFS-2016) ;;
	Unicode-TOU) ;;
	Unlicense) ;;
	UPL-1.0) osi="true" ;;
	Vim) ;;
	VOSTROM) ;;
	VSL-1.0) osi="true" ;;
	W3C-19980720) ;;
	W3C-20150513) ;;
	W3C) osi="true" ;;
	Watcom-1.0) osi="true" ;;
	Wsuipa) ;;
	WTFPL) ;;
	X11) ;;
	Xerox) ;;
	XFree86-1.1) ;;
	xinetd) ;;
	Xnet) osi="true" ;;
	xpp) ;;
	XSkat) ;;
	YPL-1.0) ;;
	YPL-1.1) ;;
	Zed) ;;
	Zend-2.0) ;;
	Zimbra-1.3) ;;
	Zimbra-1.4) ;;
	zlib-acknowledgement) ;;
	Zlib) osi="true" ;;
	ZPL-1.1) ;;
	ZPL-2.0) osi="true" ;;
	ZPL-2.1) ;;
	AGPL-3.0) deprecated="true" ;;
	eCos-2.0) deprecated="true" ;;
	GFDL-1.1) deprecated="true" ;;
	GFDL-1.2) deprecated="true" ;;
	GFDL-1.3) deprecated="true" ;;
	GPL-1.0+) deprecated="true" ;;
	GPL-1.0) deprecated="true" ;;
	GPL-2.0+) deprecated="true" ;;
	GPL-2.0-with-autoconf-exception) deprecated="true" ;;
	GPL-2.0-with-bison-exception) deprecated="true" ;;
	GPL-2.0-with-classpath-exception) deprecated="true" ;;
	GPL-2.0-with-font-exception) deprecated="true" ;;
	GPL-2.0-with-GCC-exception) deprecated="true" ;;
	GPL-2.0) deprecated="true" ;;
	GPL-3.0+) deprecated="true" ;;
	GPL-3.0-with-autoconf-exception) deprecated="true" ;;
	GPL-3.0-with-GCC-exception) deprecated="true" ;;
	GPL-3.0) deprecated="true" ;;
	LGPL-2.0+) deprecated="true" ;;
	LGPL-2.0) deprecated="true" ;;
	LGPL-2.1+) deprecated="true" ;;
	LGPL-2.1) deprecated="true" ;;
	LGPL-3.0+) deprecated="true" ;;
	LGPL-3.0) deprecated="true" ;;
	Nunit) deprecated="true" ;;
	StandardML-NJ) deprecated="true" ;;
	wxWindows) deprecated="true" ;;
	389-exception) exception="true" ;;
	Autoconf-exception-2.0) exception="true" ;;
	Autoconf-exception-3.0) exception="true" ;;
	Bison-exception-2.2) exception="true" ;;
	Bootloader-exception) exception="true" ;;
	Classpath-exception-2.0) exception="true" ;;
	CLISP-exception-2.0) exception="true" ;;
	DigiRule-FOSS-exception) exception="true" ;;
	eCos-exception-2.0) exception="true" ;;
	Fawkes-Runtime-exception) exception="true" ;;
	FLTK-exception) exception="true" ;;
	Font-exception-2.0) exception="true" ;;
	freertos-exception-2.0) exception="true" ;;
	GCC-exception-2.0) exception="true" ;;
	GCC-exception-3.1) exception="true" ;;
	gnu-javamail-exception) exception="true" ;;
	i2p-gpl-java-exception) exception="true" ;;
	Libtool-exception) exception="true" ;;
	Linux-syscall-note) exception="true" ;;
	LZMA-exception) exception="true" ;;
	mif-exception) exception="true" ;;
	Nokia-Qt-exception-1.1) exception="true" ;;
	OCCT-exception-1.0) exception="true" ;;
	openvpn-openssl-exception) exception="true" ;;
	Qwt-exception-1.0) exception="true" ;;
	u-boot-exception-2.0) exception="true" ;;
	WxWindows-exception-3.1) exception="true" ;;
	*) return 1 ;;
    esac
}
export -f ptxd_make_spdx
