# -*-makefile-*-
#
# Copyright (C) 2014 by Michael Olbrich <m.olbrich@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
PACKAGES-$(PTXCONF_MUNIN) += munin

#
# Paths and names
#
MUNIN_VERSION	:= 2.0.20
MUNIN_MD5	:= 08ba9c8a5b53b217eaac1c1fa592f3de
MUNIN		:= munin-$(MUNIN_VERSION)
MUNIN_SUFFIX	:= tar.gz
MUNIN_URL	:= $(call ptx/mirror, SF, munin/$(MUNIN).$(MUNIN_SUFFIX))
MUNIN_SOURCE	:= $(SRCDIR)/$(MUNIN).$(MUNIN_SUFFIX)
MUNIN_DIR	:= $(BUILDDIR)/$(MUNIN)
MUNIN_LICENSE	:= GPL-2.0-only
MUNIN_MAKE_PAR	:= NO

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

MUNIN_MAKE_CFG	:= $(MUNIN_DIR)/Makefile.config.ptx

$(STATEDIR)/munin.prepare:
	@$(call targetinfo)
	@echo '# Generated by PTXdist'						>  $(MUNIN_MAKE_CFG)
	@echo 'PREFIX = $$(DESTDIR)/usr'					>> $(MUNIN_MAKE_CFG)
	@echo 'CONFDIR = $$(DESTDIR)/etc/munin'					>> $(MUNIN_MAKE_CFG)
	@echo 'LIBDIR = $$(PREFIX)/lib/munin'					>> $(MUNIN_MAKE_CFG)
	@echo 'HTMLDIR = $$(DESTDIR)/var/www/munin'				>> $(MUNIN_MAKE_CFG)
	@echo 'CGIDIR = $$(HTMLDIR)/cgi'					>> $(MUNIN_MAKE_CFG)
	@echo 'DBDIR = $$(DESTDIR)/var/munin'					>> $(MUNIN_MAKE_CFG)
	@echo 'DBDIRNODE = $$(DESTDIR)/var/munin-node'				>> $(MUNIN_MAKE_CFG)
	@echo 'LOGDIR = $$(DESTDIR)/var/log'					>> $(MUNIN_MAKE_CFG)
	@echo 'STATEDIR = $$(DESTDIR)/run'					>> $(MUNIN_MAKE_CFG)
	@echo 'PERL = /usr/bin/perl'						>> $(MUNIN_MAKE_CFG)
	@echo 'GOODSH = /bin/bash'						>> $(MUNIN_MAKE_CFG)
	@echo 'PERLSITELIB = $(PERL_SITELIB)'					>> $(MUNIN_MAKE_CFG)
	@echo 'OSTYPE = linux'							>> $(MUNIN_MAKE_CFG)
	@echo 'HOSTNAME = $(call remove_quotes,$(PTXCONF_ROOTFS_ETC_HOSTNAME))'	>> $(MUNIN_MAKE_CFG)
	@echo 'MKTEMP = mktemp -p /tmp/ $$1'					>> $(MUNIN_MAKE_CFG)
	@echo 'VERSION = $(MUNIN_VERSION)'					>> $(MUNIN_MAKE_CFG)
	@echo 'USER = root'							>> $(MUNIN_MAKE_CFG)
	@echo 'GROUP = root'							>> $(MUNIN_MAKE_CFG)
	@echo 'CHECKUSER ='							>> $(MUNIN_MAKE_CFG)
	@echo 'CHECKGROUP ='							>> $(MUNIN_MAKE_CFG)
	@echo 'JCVALID = no'							>> $(MUNIN_MAKE_CFG)
	@echo 'HASSETR = 1'							>> $(MUNIN_MAKE_CFG)
	@$(call touch)

MUNIN_MAKE_ENV		:= $(CROSS_ENV)
MUNIN_MAKE_OPT		:= CONFIG=$(MUNIN_MAKE_CFG) PERL="perl -I."
MUNIN_INSTALL_OPT	:= CONFIG=$(MUNIN_MAKE_CFG) install

# ----------------------------------------------------------------------------
# Target-Install
# ----------------------------------------------------------------------------

MONIN_TOOLS := \
	munin-async \
	munin-asyncd \
	munin-datafile2storable \
	munin-graph \
	munin-html \
	munin-limits \
	munin-storable2datafile \
	munin-update

$(STATEDIR)/munin.targetinstall:
	@$(call targetinfo)

	@$(call install_init, munin)
	@$(call install_fixup, munin,PRIORITY,optional)
	@$(call install_fixup, munin,SECTION,base)
	@$(call install_fixup, munin,AUTHOR,"Michael Olbrich <m.olbrich@pengutronix.de>")
	@$(call install_fixup, munin,DESCRIPTION,missing)

	@$(call install_tree, munin, 0, 0, -, /usr/lib/munin/plugins)
	@$(call install_copy, munin, 0, 0, 0644, -, $(PERL_SITELIB)/Munin/Plugin.pm)
	@$(call install_tree, munin, 0, 0, -, $(PERL_SITELIB)/Munin/Plugin)
	@$(call install_tree, munin, 0, 0, -, $(PERL_SITELIB)/Munin/Common)
ifdef PTXCONF_MUNIN_MASTER
	@$(call install_alternative, munin, 0, 0, 0644, /etc/munin/munin.conf)
	@$(call install_tree, munin, 0, 0, -, /etc/munin/templates)
	@$(call install_tree, munin, 0, 0, -, /etc/munin/static)

	@$(call install_copy, munin, 0, 0, 0755, -, /usr/bin/munin-cron)
	@$(call install_copy, munin, 0, 0, 0755, -, /usr/bin/munin-check)

	@$(foreach tool, $(MONIN_TOOLS), \
		$(call install_copy, munin, 0, 0, 0755, -, /usr/lib/munin/$(tool));)

	@$(call install_tree, munin, 0, 0, -, $(PERL_SITELIB)/Munin/Master)
endif
ifdef PTXCONF_MUNIN_NODE
	@$(call install_alternative, munin, 0, 0, 0644, /etc/munin/munin-node.conf)
	@$(call install_copy, munin, 0, 0, 0755, /etc/munin/plugin-conf.d/)
	@$(call install_copy, munin, 0, 0, 0755, /etc/munin/plugins/)
	@$(foreach plugin, $(call remove_quotes,$(PTXCONF_MUNIN_NODE_PLUGINS)), \
		$(call install_link, munin, /usr/lib/munin/plugins/$(plugin), \
		/etc/munin/plugins/$(plugin));)

	@$(call install_copy, munin, 0, 0, 0755, -, /usr/sbin/munin-node-configure)
	@$(call install_copy, munin, 0, 0, 0755, -, /usr/sbin/munin-sched)
	@$(call install_copy, munin, 0, 0, 0755, -, /usr/sbin/munin-run)
	@$(call install_copy, munin, 0, 0, 0755, -, /usr/sbin/munin-node)

	@$(call install_tree, munin, 0, 0, -, $(PERL_SITELIB)/Munin/Node)
ifdef PTXCONF_MUNIN_NODE_SYSTEMD_UNIT
	@$(call install_alternative, munin, 0, 0, 0644, \
		/usr/lib/systemd/system/munin-node.service)
	@$(call install_link, munin, ../munin-node.service, \
		/usr/lib/systemd/system/multi-user.target.wants/munin-node.service)
endif
endif
	@$(call install_finish, munin)

	@$(call touch)

# vim: syntax=make
