/*
 * Decompiled with CFR 0.152.
 */
package net.sf.phpeasyvcs;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import net.sf.phpeasyvcs.Base64Encoder;
import net.sf.phpeasyvcs.JSON;
import net.sf.phpeasyvcs.ProgressEvent;
import net.sf.phpeasyvcs.ProgressListener;
import net.sf.phpeasyvcs.Synchronizer;
import netscape.javascript.JSObject;

public class SynchronizerApplet
extends JApplet
implements ProgressListener {
    private static final long serialVersionUID = 1L;
    private JSObject window;
    private JLabel target;
    private File localRoot = null;
    private URL remoteRoot = null;
    private Pattern excludePattern = null;
    private Map<String, String> cookieMap = new HashMap<String, String>();
    private Status status = Status.NONE;
    private String errorCallback = "showError";
    private String selectResultCallback = "showLocalRoot";
    private String scanProgressCallback = "showScanProgress";
    private String scanResultCallback = "showScanResult";
    private String syncProgressCallback = "showSyncProgress";
    private String syncResultCallback = "showSyncResult";

    public void init() {
        String label = "Drag and Drop Files Here";
        try {
            UIManager.setLookAndFeel("org.fife.plaf.Office2003.Office2003LookAndFeel");
        }
        catch (Exception e1) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            }
            catch (Exception e) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.target = new JLabel(label);
        this.target.setVerticalAlignment(0);
        this.target.setHorizontalAlignment(0);
        this.target.setBorder(new LineBorder(Color.black));
        this.target.setOpaque(true);
        this.getContentPane().add((Component)this.target, "Center");
        try {
            this.window = JSObject.getWindow((Applet)this);
            this.getCookies();
            this.remoteRoot = new URL(this.getParameter("root"));
            if (this.getParameter("excludePattern") != null && this.getParameter("excludePattern") != "") {
                try {
                    this.excludePattern = Pattern.compile("^(" + this.getParameter("excludePattern") + ")$");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.getParameter("showError") != null) {
                this.errorCallback = this.getParameter("showError");
            }
            if (this.getParameter("setLocalRoot") != null) {
                this.selectResultCallback = this.getParameter("setLocalRoot");
            }
            if (this.getParameter("showScanProgress") != null) {
                this.scanProgressCallback = this.getParameter("showScanProgress");
            }
            if (this.getParameter("showScanResult") != null) {
                this.scanResultCallback = this.getParameter("showScanResult");
            }
            if (this.getParameter("showSyncProgress") != null) {
                this.syncProgressCallback = this.getParameter("showSyncProgress");
            }
            if (this.getParameter("showSyncResult") != null) {
                this.syncResultCallback = this.getParameter("showSyncResult");
            }
        }
        catch (Exception e) {
            this.window.call("showError", e.getMessage());
        }
    }

    private void getCookies() {
        JSObject document = (JSObject)this.window.getMember("document");
        String cookies = (String)document.getMember("cookie");
        if (cookies != null) {
            for (String cookie : cookies.split(";")) {
                int pos = cookie.indexOf(61);
                if (pos <= 0) continue;
                this.cookieMap.put(cookie.substring(0, pos).trim(), cookie.substring(pos + 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean selectLocalRoot(boolean doSync) {
        SynchronizerApplet synchronizerApplet = this;
        synchronized (synchronizerApplet) {
            if (this.status != Status.NONE) {
                return false;
            }
            this.status = Status.SELECTING;
        }
        Runnable selector = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SynchronizerApplet.this.doSelectLocalRoot();
                }
                finally {
                    SynchronizerApplet synchronizerApplet = SynchronizerApplet.this;
                    synchronized (synchronizerApplet) {
                        SynchronizerApplet.this.status = Status.NONE;
                    }
                }
                if (SynchronizerApplet.this.localRoot != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                SynchronizerApplet.this.scan();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        };
        new Thread(selector).start();
        return true;
    }

    private void doSelectLocalRoot() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JFileChooser chooser = new JFileChooser();
                if (SynchronizerApplet.this.cookieMap.containsKey("localroot") && new File((String)SynchronizerApplet.this.cookieMap.get("localroot")).isDirectory()) {
                    chooser.setCurrentDirectory(new File((String)SynchronizerApplet.this.cookieMap.get("localroot")));
                }
                chooser.setFileSelectionMode(1);
                if (chooser.showOpenDialog(SynchronizerApplet.this) == 0) {
                    SynchronizerApplet.this.localRoot = chooser.getSelectedFile();
                }
                return null;
            }
        });
        if (this.localRoot != null) {
            this.window.call(this.selectResultCallback, this.localRoot.getPath());
        }
    }

    public String getLocalRoot() {
        return this.localRoot != null ? this.localRoot.getPath() : "";
    }

    public boolean scan() throws Exception {
        return this.scan("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scan(final String dir) throws Exception {
        SynchronizerApplet synchronizerApplet = this;
        synchronized (synchronizerApplet) {
            if (this.status != Status.NONE && this.localRoot == null) {
                return false;
            }
            this.status = Status.SCANNING;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SynchronizerApplet.this.doScan(dir);
                }
                finally {
                    SynchronizerApplet synchronizerApplet = SynchronizerApplet.this;
                    synchronized (synchronizerApplet) {
                        SynchronizerApplet.this.status = Status.NONE;
                    }
                }
            }
        }).start();
        return true;
    }

    private void doScan(final String dir) {
        try {
            List<Synchronizer.Entry> entries = AccessController.doPrivileged(new PrivilegedAction<List<Synchronizer.Entry>>(){

                @Override
                public List<Synchronizer.Entry> run() {
                    try {
                        String cookies = "PHPSESSID=" + (String)SynchronizerApplet.this.cookieMap.get("PHPSESSID");
                        Synchronizer synchronizer = new Synchronizer(SynchronizerApplet.this.localRoot, SynchronizerApplet.this.remoteRoot, SynchronizerApplet.this.excludePattern, cookies);
                        synchronizer.addProgressListener(SynchronizerApplet.this);
                        return synchronizer.scan(dir);
                    }
                    catch (Exception e) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SynchronizerApplet.this.window.call(SynchronizerApplet.this.errorCallback, e.getMessage());
                            }
                        });
                        return new ArrayList<Synchronizer.Entry>();
                    }
                }
            });
            this.window.call(this.scanResultCallback, dir, JSON.encode(entries));
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SynchronizerApplet.this.window.call(SynchronizerApplet.this.errorCallback, e.getMessage());
                }
            });
        }
    }

    public void progressOccurred(final ProgressEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SynchronizerApplet.this.status == Status.SCANNING) {
                    SynchronizerApplet.this.window.call(SynchronizerApplet.this.scanProgressCallback, event.getProgress(), event.getTotal(), Float.valueOf(event.getPercent()));
                } else if (SynchronizerApplet.this.status == Status.SYNCING) {
                    SynchronizerApplet.this.window.call(SynchronizerApplet.this.syncProgressCallback, event.getProgress(), event.getTotal(), Float.valueOf(event.getPercent()));
                }
            }
        });
    }

    public String getLocalFileContent(final String path) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String run() {
                Reader r = null;
                try {
                    int len;
                    r = new InputStreamReader((InputStream)new FileInputStream(SynchronizerApplet.this.localRoot + "/" + path), "UTF-8");
                    StringBuilder sb = new StringBuilder();
                    char[] cb = new char[65536];
                    while ((len = r.read(cb)) >= 0) {
                        sb.append(cb, 0, len);
                    }
                    String string = sb.toString();
                    return string;
                }
                catch (Exception e) {
                    String string = e.getMessage();
                    return string;
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        });
    }

    public String getLocalFileContentBase64(final String path) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String run() {
                InputStream in = null;
                try {
                    int len;
                    in = new FileInputStream(SynchronizerApplet.this.localRoot + "/" + path);
                    StringBuilder sb = new StringBuilder();
                    byte[] buf = new byte[54];
                    while ((len = in.read(buf)) >= 0) {
                        sb.append(Base64Encoder.encode(buf, 0, len)).append("\r\n");
                    }
                    String string = sb.toString();
                    return string;
                }
                catch (Exception e) {
                    String string = e.getMessage();
                    return string;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        });
    }

    public boolean setLocalFileContent(final String path, final String content) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() {
                Writer w = null;
                try {
                    w = new OutputStreamWriter((OutputStream)new FileOutputStream(SynchronizerApplet.this.localRoot + "/" + path), "UTF-8");
                    w.write(content);
                    Boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (w != null) {
                        try {
                            w.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync(final String syncActionJSON, final String comment) throws Exception {
        SynchronizerApplet synchronizerApplet = this;
        synchronized (synchronizerApplet) {
            if (this.status != Status.NONE) {
                return false;
            }
            this.status = Status.SYNCING;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SynchronizerApplet.this.doSync(syncActionJSON, comment);
                }
                finally {
                    SynchronizerApplet synchronizerApplet = SynchronizerApplet.this;
                    synchronized (synchronizerApplet) {
                        SynchronizerApplet.this.status = Status.NONE;
                    }
                }
            }
        }).start();
        return true;
    }

    private void doSync(String syncActionJSON, final String comment) {
        List syncActionObjects = (List)JSON.decode(syncActionJSON);
        final ArrayList<Synchronizer.SyncAction> syncActions = new ArrayList<Synchronizer.SyncAction>();
        for (Map sao : syncActionObjects) {
            Synchronizer.Action action = Synchronizer.Action.valueOf(sao.get("action").toString());
            String path = sao.get("path").toString();
            Long size = ((Number)sao.get("size")).longValue();
            syncActions.add(new Synchronizer.SyncAction(action, path, size));
        }
        try {
            List<Synchronizer.SyncAction> failedActions = AccessController.doPrivileged(new PrivilegedAction<List<Synchronizer.SyncAction>>(){

                @Override
                public List<Synchronizer.SyncAction> run() {
                    try {
                        String cookies = "PHPSESSID=" + (String)SynchronizerApplet.this.cookieMap.get("PHPSESSID");
                        Synchronizer synchronizer = new Synchronizer(SynchronizerApplet.this.localRoot, SynchronizerApplet.this.remoteRoot, cookies);
                        synchronizer.addProgressListener(SynchronizerApplet.this);
                        return synchronizer.sync(syncActions, comment);
                    }
                    catch (Exception e) {
                        SynchronizerApplet.this.window.call(SynchronizerApplet.this.errorCallback, e.getMessage());
                        return new ArrayList<Synchronizer.SyncAction>();
                    }
                }
            });
            this.window.call(this.syncResultCallback, failedActions.size() > 0 ? JSON.encode(failedActions) : Boolean.valueOf(true));
        }
        catch (Throwable e) {
            this.window.call(this.errorCallback, e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        NONE,
        SELECTING,
        SCANNING,
        SYNCING;

    }
}

