/*
 * Decompiled with CFR 0.152.
 */
package net.sf.phpeasyvcs;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import net.sf.phpeasyvcs.Downloader;
import net.sf.phpeasyvcs.ProgressEvent;
import net.sf.phpeasyvcs.ProgressListener;
import netscape.javascript.JSObject;

public class DownloadApplet
extends Applet
implements ProgressListener {
    private static final long serialVersionUID = 1L;
    private JSObject window;
    private JLabel target;
    private URL remoteRoot = null;
    private Set<String> filesToDownload = new LinkedHashSet<String>();
    private Map<String, String> cookieMap = new HashMap<String, String>();
    private Status status = Status.NONE;
    private Thread downloadThread = null;
    private File tempDir = null;
    private List<File> tempFiles = null;
    private String errorCallback = "showError";
    private String initCallback = "showDownload";
    private String downloadStartCallback = "startDownload";
    private String downloadProgressCallback = "showDownloadProgress";
    private String downloadResultCallback = "showDownloadResult";

    public void init() {
        String label = "Drag to file system";
        try {
            UIManager.setLookAndFeel("org.fife.plaf.Office2003.Office2003LookAndFeel");
        }
        catch (Exception e1) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            }
            catch (Exception e) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
        this.setLayout(new BorderLayout());
        this.target = new JLabel(label);
        this.target.setVerticalAlignment(0);
        this.target.setHorizontalAlignment(0);
        this.target.setOpaque(false);
        this.target.setEnabled(true);
        this.target.setTransferHandler(new FileTransferHandler());
        this.add((Component)this.target, "Center");
        this.target.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                JComponent comp = (JComponent)evt.getSource();
                DownloadApplet.this.startDownloadToTemp();
                comp.getTransferHandler().exportAsDrag(comp, evt, 1);
            }
        });
        try {
            this.window = JSObject.getWindow((Applet)this);
            this.getCookies();
            this.remoteRoot = new URL(this.getParameter("root"));
            if (this.getParameter("showError") != null) {
                this.errorCallback = this.getParameter("showError");
            }
            if (this.getParameter("showDownload") != null) {
                this.initCallback = this.getParameter("showDownload");
            }
            if (this.getParameter("startDownload") != null) {
                this.downloadStartCallback = this.getParameter("startDownload");
            }
            if (this.getParameter("showDownloadProgress") != null) {
                this.downloadProgressCallback = this.getParameter("showDownloadProgress");
            }
            if (this.getParameter("showDownloadResult") != null) {
                this.downloadResultCallback = this.getParameter("showDownloadResult");
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DownloadApplet.this.window.call(DownloadApplet.this.initCallback, new Object[0]);
                }
            });
        }
        catch (Exception e) {
            this.target.setText("Error: " + e.getMessage());
        }
    }

    private void getCookies() {
        JSObject document = (JSObject)this.window.getMember("document");
        String cookies = (String)document.getMember("cookie");
        if (cookies != null) {
            for (String cookie : cookies.split(";")) {
                int pos = cookie.indexOf(61);
                if (pos <= 0) continue;
                this.cookieMap.put(cookie.substring(0, pos), cookie.substring(pos + 1));
            }
        }
    }

    public void addFile(String name) {
        this.filesToDownload.add(name);
    }

    public void removeFile(String name) {
        this.filesToDownload.remove(name);
    }

    public void removeAllFiles() {
        this.filesToDownload.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download() {
        DownloadApplet downloadApplet = this;
        synchronized (downloadApplet) {
            if (this.status != Status.NONE) {
                return false;
            }
            this.status = Status.SELECTING;
        }
        Runnable selector = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean isDone;
                Boolean done = false;
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DownloadApplet.this.window.call(DownloadApplet.this.downloadStartCallback, new Object[0]);
                        }
                    });
                    done = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            try {
                                JFileChooser chooser = new JFileChooser();
                                chooser.setFileSelectionMode(1);
                                if (chooser.showOpenDialog(DownloadApplet.this) == 0) {
                                    File dir = chooser.getSelectedFile();
                                    String cookies = "PHPSESSID=" + (String)DownloadApplet.this.cookieMap.get("PHPSESSID");
                                    Downloader downloader = new Downloader(DownloadApplet.this.remoteRoot, cookies);
                                    downloader.addProgressListener(DownloadApplet.this);
                                    return downloader.downloadFiles(dir, DownloadApplet.this.filesToDownload);
                                }
                                return false;
                            }
                            catch (Exception e) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        DownloadApplet.this.window.call(DownloadApplet.this.errorCallback, e.getMessage());
                                    }
                                });
                                return false;
                            }
                        }
                    });
                    isDone = done;
                }
                catch (Throwable throwable) {
                    boolean isDone2 = done;
                    SwingUtilities.invokeLater(new Runnable(isDone2){
                        final /* synthetic */ boolean val$isDone;
                        {
                            this.val$isDone = bl;
                        }

                        public void run() {
                            DownloadApplet.this.window.call(DownloadApplet.this.downloadResultCallback, this.val$isDone);
                        }
                    });
                    DownloadApplet downloadApplet = DownloadApplet.this;
                    synchronized (downloadApplet) {
                        DownloadApplet.this.status = Status.NONE;
                    }
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                DownloadApplet downloadApplet = DownloadApplet.this;
                synchronized (downloadApplet) {
                    DownloadApplet.this.status = Status.NONE;
                }
            }
        };
        new Thread(selector).start();
        return true;
    }

    public boolean startDownloadToTemp() {
        if (this.tempDir == null) {
            try {
                File tmpFile = File.createTempFile("phpeasyvcs", ".tmp");
                tmpFile.delete();
                this.tempDir = new File(tmpFile.getPath() + ".d");
                this.tempDir.mkdirs();
            }
            catch (IOException e) {
                return false;
            }
        }
        if (this.downloadThread != null && this.downloadThread.getState() != Thread.State.TERMINATED) {
            return false;
        }
        this.tempFiles = null;
        this.downloadThread = new Thread(new Runnable(){

            public void run() {
                DownloadApplet.this.tempFiles = AccessController.doPrivileged(new PrivilegedAction<List<File>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public List<File> run() {
                        boolean isDone;
                        ArrayList<File> arrayList;
                        boolean done = false;
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    DownloadApplet.this.window.call(DownloadApplet.this.downloadStartCallback, new Object[0]);
                                }
                            });
                            try {
                                String cookies = "PHPSESSID=" + (String)DownloadApplet.this.cookieMap.get("PHPSESSID");
                                Downloader downloader = new Downloader(DownloadApplet.this.remoteRoot, cookies);
                                downloader.addProgressListener(DownloadApplet.this);
                                done = downloader.downloadFiles(DownloadApplet.this.tempDir, DownloadApplet.this.filesToDownload);
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            ArrayList<File> files = new ArrayList<File>();
                            for (String name : DownloadApplet.this.filesToDownload) {
                                File file = new File(DownloadApplet.this.tempDir + "/" + name);
                                if (!file.exists()) continue;
                                files.add(file);
                            }
                            arrayList = files;
                            isDone = done;
                        }
                        catch (Throwable throwable) {
                            boolean isDone2 = done;
                            SwingUtilities.invokeLater(new Runnable(isDone2){
                                final /* synthetic */ boolean val$isDone;
                                {
                                    this.val$isDone = bl;
                                }

                                public void run() {
                                    DownloadApplet.this.window.call(DownloadApplet.this.downloadResultCallback, this.val$isDone);
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        return arrayList;
                    }
                });
            }
        });
        this.downloadThread.start();
        return true;
    }

    public void destroy() {
        if (this.tempDir != null) {
            this.delete(this.tempDir);
        }
    }

    public void delete(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.delete(f);
            }
        }
        file.delete();
    }

    public void progressOccurred(final ProgressEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DownloadApplet.this.window.call(DownloadApplet.this.downloadProgressCallback, event.getSource().toString(), event.getProgress(), event.getTotal(), Float.valueOf(event.getPercent()));
            }
        });
    }

    private class FileTransferable
    implements Transferable {
        private DataFlavor uriListFlavor = null;
        private List<File> files = null;

        public FileTransferable() {
            try {
                this.uriListFlavor = new DataFlavor("text/uri-list;class=" + InputStream.class.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        public DataFlavor[] getTransferDataFlavors() {
            if (this.uriListFlavor != null) {
                return new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor, this.uriListFlavor};
            }
            return new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DataFlavor.javaFileListFlavor) || flavor.equals(DataFlavor.stringFlavor) || this.uriListFlavor != null && flavor.equals(this.uriListFlavor);
        }

        public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            if (this.files == null) {
                while (DownloadApplet.this.downloadThread.getState() != Thread.State.TERMINATED) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
                List<Object> list = this.files = DownloadApplet.this.tempFiles != null ? DownloadApplet.this.tempFiles : new ArrayList();
            }
            if (flavor.equals(DataFlavor.javaFileListFlavor)) {
                return this.files;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.files.size(); ++i) {
                    sb.append(this.files.get(i).getAbsolutePath());
                    if (i >= this.files.size() - 1) continue;
                    sb.append("\n");
                }
                return sb.toString();
            }
            if (flavor.equals(this.uriListFlavor)) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.files.size(); ++i) {
                    sb.append(new File(this.files.get(i).getAbsolutePath()).toURI().toString());
                    if (i >= this.files.size() - 1) continue;
                    sb.append("\r\n");
                }
                return new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
            }
            return this.files;
        }
    }

    private class FileTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        private FileTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            return new FileTransferable();
        }

        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        NONE,
        SELECTING,
        DOWNLOADING;

    }
}

