.\"
.\" Manual page for the ESP Package Manager (EPM) setup types file format.
.\"
.\" Copyright 2020 by Jim Jagielski
.\" Copyright 1999-2017 by Michael R Sweet
.\" Copyright 1999-2007 by Easy Software Products, all rights reserved.
.\"
.\" Licensed under the Apache License, Version 2.0 (the "License");
.\" you may not use this file except in compliance with the License.
.\" You may obtain a copy of the License at
.\"
.\"    http://www.apache.org/licenses/LICENSE-2.0
.\" 
.\" Unless required by applicable law or agreed to in writing, software
.\" distributed under the License is distributed on an "AS IS" BASIS,
.\" WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
.\" See the License for the specific language governing permissions and
.\" limitations under the License.
.\"
.TH setup.types 5 "ESP Package Manager" "20 November 2020" "Jim Jagielski"
.SH NAME
setup.types \- epm gui setup types file format.
.SH DESCRIPTION
The EPM
.BR setup (1)
program normally presents the user with a list of software products to install, which is called a "custom" software installation.
.LP
If a file called \fIsetup.types\fR is present in the package directory, the user will instead be presented with a list of installation types.
Each type has an associated product list which determines the products that are installed by default.
If a type has no products associated with it, then it is treated as a custom installation and the user is presented with a list of packages to choose from.
.SH FILE FORMAT
The \fIsetup.types\fR file is an ASCII text file consisting of type and product lines.
Comments can be inserted by starting a line with the pound sign (#).
Each installation type is defined by a line starting with the word TYPE.
Products are defined by a line starting with the word INSTALL:
.in 5
.nf

TYPE Typical End-User Configuration
INSTALL foo
INSTALL foo-help
TYPE Typical Developer Configuration
INSTALL foo
INSTALL foo-help
INSTALL foo-devel
INSTALL foo-examples
TYPE Custom Configuration
.fi
.in
.LP
In the example above, three installation types are defined.
Since the last type includes no products, the user will be presented with the full list of products to choose from.
.SH SEE ALSO
.BR epm (1),
.BR setup (1).
.SH COPYRIGHT
Copyright \[co] 1999-2017 by Michael R Sweet, All Rights Reserved.
Copyright \[co] 2020 by Jim Jagielski, All Rights Reserved.
.LP
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
.LP
   http://www.apache.org/licenses/LICENSE-2.0
.LP
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
