.\"
.\" Manual page for the ESP Package Manager (EPM).
.\"
.\" Copyright 2020 by Jim Jagielski
.\" Copyright 1999-2017 by Michael R Sweet
.\" Copyright 1999-2007 by Easy Software Products, all rights reserved.
.\"
.\" Licensed under the Apache License, Version 2.0 (the "License");
.\" you may not use this file except in compliance with the License.
.\" You may obtain a copy of the License at
.\"
.\"    http://www.apache.org/licenses/LICENSE-2.0
.\" 
.\" Unless required by applicable law or agreed to in writing, software
.\" distributed under the License is distributed on an "AS IS" BASIS,
.\" WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
.\" See the License for the specific language governing permissions and
.\" limitations under the License.
.\"
.TH mkepmlist 1 "ESP Package Manager" "20 November 2020" "Jim Jagielski"
.SH NAME
mkepmlist \- make an epm list file from a directory.
.SH SYNOPSIS
.B mkepmlist
[
.B \-g
.I group
] [
.B \-u
.I user
] [
.B \-\-prefix
.I directory
]
.I directory
[ ...
.I directory
]
.SH DESCRIPTION
.B mkepmlist (1)
recursively generates file list entries for files, links, and directories.
The file list is send to the standard output.
.SH OPTIONS
.B mkepmlist
supports the following options:
.TP 5
\fB\-g \fIgroup\fR
Overrides the group ownership of the files in the specified directories with the specified group name.
.TP 5
\fB\-u \fIuser\fR
Overrides the user ownership of the files in the specified directories with the specified user name.
.TP 5
\fB\-\-prefix \fIdirectory\fR
Adds the specified directory to the destination path.
For example, if you installed files to "/opt/foo" and wanted to build a distribution that installed the files in "/usr/local", the following command would generate a file
list that is installed in "/usr/local":
.nf
.br
     mkepmlist \-\-prefix=/usr/local /opt/foo >foo.list
.fi
.SH SEE ALSO
.BR epm (1),
.BR epminstall (1),
.BR epm.list (5).
.SH COPYRIGHT
Copyright \[co] 1999-2017 by Michael R Sweet, All Rights Reserved.
Copyright \[co] 2020 by Jim Jagielski, All Rights Reserved.
.LP
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
.LP
   http://www.apache.org/licenses/LICENSE-2.0
.LP
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
