.\"
.\" Manual page for the ESP Package Manager (EPM) list file format.
.\"
.\" Copyright 2020 by Jim Jagielski
.\" Copyright 1999-2017 by Michael R Sweet
.\" Copyright 1999-2010 by Easy Software Products, all rights reserved.
.\"
.\" Licensed under the Apache License, Version 2.0 (the "License");
.\" you may not use this file except in compliance with the License.
.\" You may obtain a copy of the License at
.\"
.\"    http://www.apache.org/licenses/LICENSE-2.0
.\" 
.\" Unless required by applicable law or agreed to in writing, software
.\" distributed under the License is distributed on an "AS IS" BASIS,
.\" WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
.\" See the License for the specific language governing permissions and
.\" limitations under the License.
.\"
.TH epm.list 5 "ESP Package Manager" "20 November 2020" "Jim Jagielski"
.SH NAME
epm.list \- epm list file format.
.SH DESCRIPTION
Each
.BR epm (1)
product has an associated list file that describes the files to include with the product.
Comment lines begin with the "#" character and are ignored.
All other non-blank lines must begin with a letter, dollar sign ("$"), or the percent sign ("%") as follows:
.TP 5
$name=value
Sets the named variable to \fIvalue\fR.
\fBNote:\fR Variables set in the list file are overridden by variables specified on the command-line or in the current environment.
.TP 5
%arch all
Uses following files and directives on all processor architectures.
.TP 5
%arch \fIarchitecture [... architecture]\fR
Uses following files and directives on the named processor architectures.
.TP 5
%arch !\fIarchitecture [... architecture]\fR
Uses following files and directives on all but the named processor
architectures.
.TP 5
%copyright \fIcopyright notice\fR
Sets the copyright notice for the file.
.TP 5
%description \fIdescription text\fR
Adds a line of descriptive text to the distribution. Multiple lines are
supported.
.TP 5
%format \fIformat [... format]\fR
Uses following files and directives only if the distribution format is the same as \fIformat\fR.
.TP 5
%format !\fIformat [... format]\fR
Uses following files and directives only if the distribution format is not the same as \fIformat\fR.
.TP 5
%if \fIvariable\fR [... variable]\fR
.TP 5
%if !\fIvariable\fR [... variable]\fR
.TP 5
%ifdef \fIvariable\fR [... variable]\fR
.TP 5
%ifdef !\fIvariable\fR [... variable]\fR
.TP 5
%elseif \fIvariable\fR [... variable]\fR
.TP 5
%elseif !\fIvariable\fR [... variable]\fR
.TP 5
%elseifdef \fIvariable\fR [... variable]\fR
.TP 5
%elseifdef !\fIvariable\fR [... variable]\fR
.TP 5
%else
.TP 5
%endif
Conditionally includes lines in the list file.
The \fI%if\fR lines include the lines that follow if the named variables are (not) defined with a value.
The \fI%ifdef\fR lines include the lines that follow if the named variables are (not) defined with any value.
These conditional lines cannot be nested.
.TP 5
%include \fIfilename\fR
Includes files listed in \fIfilename\fR.
.TP 5
%incompat \fIproduct\fR
.TP 5
%incompat \fIfilename\fR
Indicates that this product is incompatible with the named product or file.
.TP 5
%install \fIscript or program\fR
Specifies a script or program to be run after all files are installed.
(This has been obsoleted by the %postinstall directive)
.TP 5
%license \fIlicense file\fR
Specifies the file to display as the software license.
.TP 5
%literal(section) \fIline\fR
.TP 5
%literal(section) <\fIfile\fR
.TP 5
%literal(section) <<\fIstring\fR
Specifies format-specific literal data for packaging.
Currently only supported for RPM and PKG packages.
.TP 5
%packager \fIname of packager\fR
Specifies the name of the packager.
.TP 5
%patch \fIscript or program\fR
Specifies a script or program to be run after all files are patched.
(This has been obsoleted by the %postpatch directive)
.TP 5
%postinstall \fIscript or program\fR
.TP 5
%postinstall <\fIscriptfile\fR
.TP 5
%postinstall <<\fIstring\fR
Specifies a script or program to be run after all files are installed.
.TP 5
%postpatch \fIscript or program\fR
.TP 5
%postpatch <\fIscriptfile\fR
.TP 5
%postpatch <<\fIstring\fR
Specifies a script or program to be run after all files are patched.
.TP 5
%postremove \fIscript or program\fR
.TP 5
%postremove <\fIscriptfile\fR
.TP 5
%postremove <<\fIstring\fR
Specifies a script or program to be run after removing files.
.TP 5
%preinstall \fIscript or program\fR
.TP 5
%preinstall <\fIscriptfile\fR
.TP 5
%preinstall <<\fIstring\fR
Specifies a script or program to be run before all files are installed.
.TP 5
%prepatch \fIscript or program\fR
.TP 5
%prepatch <\fIscriptfile\fR
.TP 5
%prepatch <<\fIstring\fR
Specifies a script or program to be run before all files are patched.
.TP 5
%preremove \fIscript or program\fR
.TP 5
%preremove <\fIscriptfile\fR
.TP 5
%preremove <<\fIstring\fR
Specifies a script or program to be run before removing files.
.TP 5
%product \fIproduct name\fR
Specifies the product name.
.TP 5
%readme \fIreadme file\fR
Specifies a README file to be included in the distribution.
.TP 5
%remove \fIscript or program\fR
Specifies a script or program to be run before removing files.
(This has been obsoleted by the %preremove directive)
.TP 5
%release \fInumber\fR
Specifies the release or build number of a product (defaults to 0).
.TP 5
%replaces \fIproduct\fR
Indicates that this product replaces the named product.
.TP 5
%requires \fIproduct\fR
.TP 5
%requires \fIfilename\fR
Indicates that this product requires the named product or file.
.TP 5
%subpackage
.TP 5
%subpackage \fIname\fR
Selects the named subpackage; if no name is given, selects the main (parent) package.
.TP 5
%vendor \fIvendor or author name\fR
Specifies the vendor or author of the product.
.TP 5
%version \fIversion number\fR
Specifies the version number of the product.
.TP 5
%system \fIsystem[-release] [... system[-release]]\fR
Specifies that the following files should only be used for the specified operating systems and releases.
.TP 5
%system !\fIsystem[-release] [... system[-release]]\fR
Specifies that the following files should not be used for the specified operating systems and releases.
.TP 5
%system all
Specifies that the following files are applicable to all operating systems.
.TP 5
c \fImode user group destination source\fR
.TP 5
C \fImode user group destination source\fR
Specifies a configuration file for installation.
The second form specifies that the file has changed or is new and should be included as part of a patch.
Configuration files are installed as "destination.N" if the destination already exists.
.TP 5
d \fImode user group destination -\fR
.TP 5
D \fImode user group destination -\fR
Specifies a directory should be created when installing the software.
The second form specifies that the directory is new and should be included as part of a patch.
.TP 5
f \fImode user group destination source [nostrip()]\fR
.TP 5
F \fImode user group destination source [nostrip()]\fR
Specifies a file for installation.
The second form specifies that the file has changed or is new and should be included as part of a patch.
If the "nostrip()" option is included, the file will not be stripped before the installation is created.
.TP 5
f \fImode user group destination source/pattern [nostrip()]\fR
.TP 5
F \fImode user group destination source/pattern [nostrip()]\fR
Specifies one or more files for installation using shell wildcard patterns.
The second form specifies that the files have changed or are new and should be included as part of a patch.
If the "nostrip()" option is included, the file will not be stripped before the installation is created.
.TP 5
i \fImode user group service-name source ["options"]\fR
.TP 5
I \fImode user group service-name source ["options"]\fR
Specifies an initialization script for installation.
The second form specifies that the file has changed or is new and should be included as part of a patch.
Initialization scripts are stored in /etc/software/init.d and are linked to the appropriate system-specific directories for run levels 0, 2, 3, and 5.
Initialization scripts \fBmust\fR accept at least the \fIstart\fR and \fIstop\fR commands.
The optional \fIoptions\fR following the source filename can be any of the following:
.TP 10
     order(\fIstring\fR)
Specifies the relative startup order compared to the required and used system functions.
Supported values include First, Early, None, Late, and Last (macOS only).
.TP 10
     provides(\fIname(s)\fR)
Specifies names of system functions that are provided by this startup item (macOS only).
.TP 10
     requires(\fIname(s)\fR)
Specifies names of system functions that are required by this startup item (macOS only).
.TP 10
     runlevel(\fIlevels\fR)
Specifies the run levels to use.
.TP 10
     start(\fInumber\fR)
Specifies the starting sequence number from 00 to 99.
.TP 10
     stop(\fInumber\fR)
Specifies the ending sequence number from 00 to 99.
.TP 10
     uses(\fIname(s)\fR)
Specifies names of system functions that are used by this startup
item (macOS only).

.TP 5
l \fImode user group destination source\fR
.TP 5
L \fImode user group destination source\fR
Specifies a symbolic link in the installation.
The second form specifies that the link has changed or is new and should be included as part of a patch.
.TP 5
R \fImode user group destination\fR
Specifies that the file is to be removed upon patching.
The \fIuser\fR and \fIgroup\fR fields are ignored.
The \fImode\fR field is only used to determine if a check should be made for a previous version of the file.
.SH LIST VARIABLES
\fIEPM\fR maintains a list of variables and their values which can be used to substitute values in the list file.
These variables are imported from the current environment and taken from the command-line and list file as provided.
Substitutions occur when the variable name is referenced with the dollar sign ($):
.nf
.br

    %postinstall <<EOF
    echo What is your name:
    read $$name
    Your name is $$name
    EOF

    f 0555 root sys ${bindir}/foo foo
    f 0555 root sys $datadir/foo/foo.dat foo.dat
.fi
.LP
Variable names can be surrounded by curley brackets (${name}) or alone ($name); without brackets the name is terminated by the first slash (/), dash (-), or whitespace.
The dollar sign can be inserted using $$.
.SH SEE ALSO
.BR epm (1),
.BR epminstall (1),
.BR mkepmlist (1).
.SH COPYRIGHT
Copyright \[co] 1999-2017 by Michael R Sweet, All Rights Reserved.
Copyright \[co] 2020 by Jim Jagielski, All Rights Reserved.
.LP
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
.LP
   http://www.apache.org/licenses/LICENSE-2.0
.LP
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
