# -*- coding: utf-8 -*-

#   This file is part of emesene.
#
#    Emesene is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    emesene is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with emesene; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

VERSION = '0.3'
IFACE_NAME = 'org.exaile.Exaile'
IFACE_PATH = '/org/exaile/Exaile'
    
import CurrentSong, string

class Exaile( CurrentSong.DbusBase ):
    '''Exaile Interface'''
    
    def __init__( self ):
        CurrentSong.DbusBase.__init__( self, IFACE_NAME, self.setInterface )
        
        try: self.iface
        except: self.iface = None
       
    def setInterface( self ):
        proxy_obj = self.bus.get_object( IFACE_NAME, IFACE_PATH )
        self.iface = self.module.Interface( proxy_obj, IFACE_NAME )
        
    def getCoverPath( self ):
        if self.iface:
            return ""
        else:
            return None
     
    def setCurrentSongData( self ):
        if self.iface and self.isNameActive(IFACE_NAME):
            self.artist = self.iface.GetTrackAttr('artist')
            self.title = self.iface.GetTrackAttr('title')
            self.album = self.iface.GetTrackAttr('album')
            if self.artist == None:
                self.artist = ""
            if self.title == None:
                self.title = ""
            if self.album == None:
                self.album = ""
	if not self.isPlaying():
                self.artist = ""
                self.title = ""
                self.album = ""
        

    def getVersion( self ):
        try:
            self.iface.GetVersion()
        except:
            return False
        
        return True
    
    def isPlaying( self ):
        trackInfo = str(self.iface.Query())
        if string.split(trackInfo, ", ")[0] == "status: playing":
            self.playing = True
            return True
        else:
            self.playing = False
            return False
        
    def check( self ):
        if not self.iface or not self.isNameActive(IFACE_NAME):
            return
        
        if self.artist != self.iface.GetTrackAttr('artist') or \
           self.title != self.iface.GetTrackAttr('title') or \
           self.album != self.iface.GetTrackAttr('album') or \
           self.playing != self.isPlaying():
            self.setCurrentSongData()
            return True
            
        return False

