/*
 * Copyright (C) 2011 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#ifndef __ME_TV_SERVER_H__
#define __ME_TV_SERVER_H__

#include <glibmm.h>
#include "../common/me-tv-types.h"
#include "channel_manager.h"
#include "scheduled_recording_manager.h"
#include "stream_manager.h"
#include "device_manager.h"
#include "configuration_manager.h"

extern bool				verbose_logging;
extern bool				disable_epg_thread;
extern bool				disable_epg;
extern Glib::ustring	devices;
extern Glib::ustring	preferred_language;
extern int		read_timeout;
extern Glib::ustring	server_address;
extern int		server_port;
extern Glib::ustring	recording_directory;
extern gboolean		remove_colon;
extern guint		record_extra_before;
extern guint		record_extra_after;
extern sigc::signal<void> signal_update;
extern sigc::signal<void, Glib::ustring> signal_error;

extern ChannelManager				channel_manager;
extern ScheduledRecordingManager	scheduled_recording_manager;
extern DeviceManager				device_manager;
extern StreamManager				stream_manager;
extern ConfigurationManager			configuration_manager;

struct StringTable
{
	const char*	text;
	guint		value;
};

void handle_error();

guint convert_string_to_value(const StringTable* table, const Glib::ustring& text);
Glib::ustring convert_value_to_string(const StringTable* table, guint value);

void split_string(StringArray& parts, const Glib::ustring& text, const char* delimiter, gboolean remove_empty, gsize max_length);

#endif
