/*
 * Copyright (C) 2011 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __CONFIGURATION_MANAGER_H__
#define __CONFIGURATION_MANAGER_H__

#include "data.h"
#include <glibmm.h>

class ConfigurationManager
{
private:
	class Entry
	{
	public:
		Entry() : id(0) {}

		guint id;
		Glib::ustring name;
		Glib::ustring value;
	};

	class EntryList : public std::list<Entry>
	{
	public:
		gboolean contains(const Glib::ustring& name);
		void add(const Glib::ustring& name, const Glib::ustring& value);
		void add(int id, const Glib::ustring& name, const Glib::ustring& value);
		Glib::ustring get(const Glib::ustring& name);
	};

	EntryList entries;
	
public:
	void load(Data::Schema& schema, Data::Connection& connection);
	void save(Data::Schema& schema, Data::Connection& connection);

	void set_value(const Glib::ustring& name, const Glib::ustring& value);
	void set_value(const Glib::ustring& name, int value);

	Glib::ustring get_value(const Glib::ustring& name);
	int get_int_value(const Glib::ustring& name);

	void set_default_value(const Glib::ustring& name, const Glib::ustring& value);
	void set_default_value(const Glib::ustring& name, int value);
};

#endif
